/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ShapeBox
extends ShapeBase {
    protected static final class_238 EMPTY_BOX = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected class_238 box = EMPTY_BOX;
    protected class_238 renderPerimeter = EMPTY_BOX;
    protected int enabledSidesMask = 63;
    protected boolean gridEnabled = true;
    protected class_243 gridSize = new class_243(16.0, 16.0, 16.0);
    protected class_243 gridOffset = class_243.field_1353;

    public ShapeBox() {
        super(ShapeType.BOX, Configs.Colors.SHAPE_BOX.getColor());
    }

    public class_238 getBox() {
        return this.box;
    }

    public int getEnabledSidesMask() {
        return this.enabledSidesMask;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public class_243 getGridSize() {
        return this.gridSize;
    }

    public class_243 getGridOffset() {
        return this.gridOffset;
    }

    public void setBox(class_238 box) {
        this.box = box;
        double margin = class_310.method_1551().field_1690.field_1870 * 2;
        this.renderPerimeter = box.method_1014(margin);
        this.setNeedsUpdate();
    }

    public void setEnabledSidesMask(int enabledSidesMask) {
        this.enabledSidesMask = enabledSidesMask;
        this.setNeedsUpdate();
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
        this.setNeedsUpdate();
    }

    public void setGridSize(class_243 gridSize) {
        double x = class_3532.method_15350((double)gridSize.field_1352, (double)0.5, (double)1024.0);
        double y = class_3532.method_15350((double)gridSize.field_1351, (double)0.5, (double)1024.0);
        double z = class_3532.method_15350((double)gridSize.field_1350, (double)0.5, (double)1024.0);
        this.gridSize = new class_243(x, y, z);
        this.setNeedsUpdate();
    }

    public void setGridOffset(class_243 gridOffset) {
        double x = class_3532.method_15350((double)gridOffset.field_1352, (double)0.0, (double)1024.0);
        double y = class_3532.method_15350((double)gridOffset.field_1351, (double)0.0, (double)1024.0);
        double z = class_3532.method_15350((double)gridOffset.field_1350, (double)0.0, (double)1024.0);
        this.gridOffset = new class_243(x, y, z);
        this.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        class_1297 entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.method_1006(entity.method_19538());
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        class_238 box = this.box.method_989(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        this.renderBox(box);
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.needsUpdate = false;
    }

    protected void renderBox(class_238 box) {
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            if (!ShapeBox.isSideEnabled(side, this.enabledSidesMask)) continue;
            ShapeBox.renderBoxSideQuad(box, side, this.color, BUFFER_1);
        }
        Color4f color = Color4f.fromColor((Color4f)this.color, (float)1.0f);
        ShapeBox.renderBoxEnabledEdgeLines(box, color, this.enabledSidesMask, BUFFER_2);
        if (this.gridEnabled) {
            this.renderGridLines(box, color);
        }
    }

    protected void renderGridLines(class_238 box, Color4f color) {
        if (ShapeBox.isSideEnabled(class_2350.field_11033, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.field_1322, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11036, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.field_1325, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11043, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.field_1321, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11035, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.field_1324, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11039, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.field_1323, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11034, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.field_1320, color, BUFFER_2);
        }
    }

    protected void renderGridLinesX(class_238 box, double x, Color4f color, class_287 buffer) {
        for (double y = box.field_1322 + this.gridOffset.field_1351; y <= box.field_1325; y += this.gridSize.field_1351) {
            buffer.method_22912(x, y, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(x, y, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        for (double z = box.field_1321 + this.gridOffset.field_1350; z <= box.field_1324; z += this.gridSize.field_1350) {
            buffer.method_22912(x, box.field_1322, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(x, box.field_1325, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
    }

    protected void renderGridLinesY(class_238 box, double y, Color4f color, class_287 buffer) {
        for (double x = box.field_1323 + this.gridOffset.field_1352; x <= box.field_1320; x += this.gridSize.field_1352) {
            buffer.method_22912(x, y, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(x, y, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        for (double z = box.field_1321 + this.gridOffset.field_1350; z <= box.field_1324; z += this.gridSize.field_1350) {
            buffer.method_22912(box.field_1323, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
    }

    protected void renderGridLinesZ(class_238 box, double z, Color4f color, class_287 buffer) {
        for (double x = box.field_1323 + this.gridOffset.field_1352; x <= box.field_1320; x += this.gridSize.field_1352) {
            buffer.method_22912(x, box.field_1322, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(x, box.field_1325, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        for (double y = box.field_1322 + this.gridOffset.field_1351; y <= box.field_1325; y += this.gridSize.field_1351) {
            buffer.method_22912(box.field_1323, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
    }

    public static boolean isSideEnabled(class_2350 side, int enabledSidesMask) {
        return (enabledSidesMask & 1 << side.method_10146()) != 0;
    }

    public static void renderBoxSideQuad(class_238 box, class_2350 side, Color4f color, class_287 buffer) {
        switch (side) {
            case field_11033: {
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }

    public static void renderBoxEnabledEdgeLines(class_238 box, Color4f color, int enabledSidesMask, class_287 buffer) {
        boolean down = ShapeBox.isSideEnabled(class_2350.field_11033, enabledSidesMask);
        boolean up = ShapeBox.isSideEnabled(class_2350.field_11036, enabledSidesMask);
        boolean north = ShapeBox.isSideEnabled(class_2350.field_11043, enabledSidesMask);
        boolean south = ShapeBox.isSideEnabled(class_2350.field_11035, enabledSidesMask);
        boolean west = ShapeBox.isSideEnabled(class_2350.field_11039, enabledSidesMask);
        boolean east = ShapeBox.isSideEnabled(class_2350.field_11034, enabledSidesMask);
        if (down || north) {
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (up || north) {
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (down || south) {
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (up || south) {
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (down || west) {
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (up || west) {
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (down || east) {
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (up || east) {
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (north || west) {
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (south || west) {
            buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (north || east) {
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
        if (south || east) {
            buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
            buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(color.r, color.g, color.b, color.a).method_1344();
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.addProperty("enabled_sides", (Number)this.enabledSidesMask);
        obj.addProperty("grid_enabled", Boolean.valueOf(this.gridEnabled));
        obj.add("grid_size", (JsonElement)JsonUtils.vec3dToJson((class_243)this.gridSize));
        obj.add("grid_offset", (JsonElement)JsonUtils.vec3dToJson((class_243)this.gridOffset));
        obj.addProperty("minX", (Number)this.box.field_1323);
        obj.addProperty("minY", (Number)this.box.field_1322);
        obj.addProperty("minZ", (Number)this.box.field_1321);
        obj.addProperty("maxX", (Number)this.box.field_1320);
        obj.addProperty("maxY", (Number)this.box.field_1325);
        obj.addProperty("maxZ", (Number)this.box.field_1324);
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.enabledSidesMask = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"enabled_sides", (int)63);
        this.gridEnabled = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"grid_enabled", (boolean)true);
        this.gridSize = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_size");
        this.gridOffset = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_offset");
        if (this.gridSize == null) {
            this.gridSize = new class_243(16.0, 16.0, 16.0);
        }
        if (this.gridOffset == null) {
            this.gridOffset = class_243.field_1353;
        }
        double minX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minX", (double)0.0);
        double minY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minY", (double)0.0);
        double minZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minZ", (double)0.0);
        double maxX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxX", (double)0.0);
        double maxY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxY", (double)0.0);
        double maxZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxZ", (double)0.0);
        this.setBox(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
    }
}

