/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.mixin.IMixinAbstractFurnaceBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_5762;

public class MiscUtils {
    private static final Random RAND = new Random();
    private static final int[] AXOLOTL_COLORS = new int[]{16762860, 9202768, 16438299, 15267835, 11974142};

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static double intAverage(int[] values) {
        int size = values.length;
        long sum = 0L;
        for (int i = 0; i < size; ++i) {
            sum += (long)values[i];
        }
        return (double)sum / (double)values.length;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isOverworld(class_1937 world) {
        return world.method_8597().method_28537();
    }

    public static boolean isStructureWithinRange(@Nullable class_3341 bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.method_35415() - maxRange && playerPos.method_10263() <= bb.method_35418() + maxRange && playerPos.method_10260() >= bb.method_35417() - maxRange && playerPos.method_10260() <= bb.method_35420() + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.minX - maxRange && playerPos.method_10263() <= bb.maxX + maxRange && playerPos.method_10260() >= bb.minZ - maxRange && playerPos.method_10260() <= bb.maxZ + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX == bb2.minX && bb1.minY == bb2.minY && bb1.minZ == bb2.minZ && bb1.maxX == bb2.maxX && bb1.maxY == bb2.maxY && bb1.maxZ == bb2.maxZ;
    }

    public static void addAxolotlTooltip(class_1799 stack, List<class_2561> lines) {
        int variantId;
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("Variant", 3) && (variantId = tag.method_10550("Variant")) >= 0 && variantId < class_5762.class_5767.field_28346.length) {
            class_5762.class_5767 variant = class_5762.class_5767.field_28346[variantId];
            String variantName = variant.method_33238();
            class_2588 labelText = new class_2588("minihud.label.axolotl_tooltip.label");
            class_2588 valueText = new class_2588("minihud.label.axolotl_tooltip.value", new Object[]{variantName, variantId});
            if (variantId < AXOLOTL_COLORS.length) {
                valueText.method_10862(class_2583.field_24360.method_36139(AXOLOTL_COLORS[variantId]));
            }
            lines.add(Math.min(1, lines.size()), (class_2561)labelText.method_10852((class_2561)valueText));
        }
    }

    public static void addBeeTooltip(class_1799 stack, List<class_2561> lines) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("BlockEntityTag", 10)) {
            tag = tag.method_10562("BlockEntityTag");
            class_2499 bees = tag.method_10554("Bees", 10);
            int count = bees.size();
            int babyCount = 0;
            for (int i = 0; i < count; ++i) {
                tag = bees.method_10602(i).method_10562("EntityData");
                if (tag == null) continue;
                if (tag.method_10573("CustomName", 8)) {
                    String beeName = tag.method_10558("CustomName");
                    lines.add(Math.min(1, lines.size()), (class_2561)new class_2588("minihud.label.bee_tooltip.name", new Object[]{class_2561.class_2562.method_10877((String)beeName).getString()}));
                }
                if (!tag.method_10573("Age", 3) || tag.method_10550("Age") >= 0) continue;
                ++babyCount;
            }
            class_2588 text = babyCount > 0 ? new class_2588("minihud.label.bee_tooltip.count_babies", new Object[]{String.valueOf(count), String.valueOf(babyCount)}) : new class_2588("minihud.label.bee_tooltip.count", new Object[]{String.valueOf(count)});
            lines.add(Math.min(1, lines.size()), (class_2561)text);
        }
    }

    public static void addHoneyTooltip(class_1799 stack, List<class_2561> lines) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("BlockStateTag", 10)) {
            tag = tag.method_10562("BlockStateTag");
            String honeyLevel = "0";
            if (tag != null && tag.method_10573("honey_level", 8)) {
                honeyLevel = tag.method_10558("honey_level");
            } else if (tag != null && tag.method_10573("honey_level", 3)) {
                honeyLevel = String.valueOf(tag.method_10550("honey_level"));
            }
            lines.add(Math.min(1, lines.size()), (class_2561)new class_2588("minihud.label.honey_info.level", new Object[]{honeyLevel}));
        }
    }

    public static int getFurnaceXpAmount(class_2609 be) {
        Object2IntOpenHashMap<class_2960> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        class_1937 world = be.method_10997();
        double xp = 0.0;
        for (Object2IntMap.Entry entry : recipes.object2IntEntrySet()) {
            Object t;
            Optional recipeOpt = world.method_8433().method_8130((class_2960)entry.getKey());
            if (!recipeOpt.isPresent() || !((t = recipeOpt.get()) instanceof class_1874)) continue;
            class_1874 recipe = (class_1874)t;
            xp += (double)((float)entry.getIntValue() * recipe.method_8171());
        }
        return (int)xp;
    }
}

