/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.class_1920;
import net.minecraft.class_2338;

public class SmoothBiomeColorBlender
implements BiomeColorBlender {
    private final int[] cachedRet = new int[4];
    private final class_2338.class_2339 mpos = new class_2338.class_2339();

    @Override
    public <T> int[] getColors(class_1920 world, class_2338 origin, ModelQuadView quad, ModelQuadColorProvider<T> colorizer, T state) {
        int[] colors = this.cachedRet;
        boolean aligned = ModelQuadFlags.contains(quad.getFlags(), 1);
        for (int i = 0; i < 4; ++i) {
            colors[i] = aligned ? this.getVertexColor(colorizer, world, state, origin, quad, i) : this.getInterpolatedVertexColor(colorizer, world, state, origin, quad, i);
        }
        return colors;
    }

    private <T> int getVertexColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, class_2338 origin, ModelQuadView quad, int vertexIdx) {
        int x = origin.method_10263() + (int)quad.getX(vertexIdx);
        int y = origin.method_10264() + (int)quad.getY(vertexIdx);
        int z = origin.method_10260() + (int)quad.getZ(vertexIdx);
        int color = this.getBlockColor(colorizer, world, state, x, y, z, quad.getColorIndex());
        return ColorARGB.toABGR(color);
    }

    private <T> int getBlockColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, int x, int y, int z, int colorIdx) {
        return colorizer.getColor(state, world, (class_2338)this.mpos.method_10103(x, y, z), colorIdx);
    }

    private <T> int getInterpolatedVertexColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, class_2338 origin, ModelQuadView quad, int vertexIdx) {
        float x = quad.getX(vertexIdx);
        float y = quad.getY(vertexIdx);
        float z = quad.getZ(vertexIdx);
        int intX = (int)x;
        int intY = (int)y;
        int intZ = (int)z;
        int originX = origin.method_10263() + intX;
        int originY = origin.method_10264() + intY;
        int originZ = origin.method_10260() + intZ;
        int c000 = this.getBlockColor(colorizer, world, state, originX, originY, originZ, quad.getColorIndex());
        int c001 = this.getBlockColor(colorizer, world, state, originX, originY, originZ + 1, quad.getColorIndex());
        int c100 = this.getBlockColor(colorizer, world, state, originX + 1, originY, originZ, quad.getColorIndex());
        int c101 = this.getBlockColor(colorizer, world, state, originX + 1, originY, originZ + 1, quad.getColorIndex());
        int c010 = this.getBlockColor(colorizer, world, state, originX, originY + 1, originZ, quad.getColorIndex());
        int c011 = this.getBlockColor(colorizer, world, state, originX, originY + 1, originZ + 1, quad.getColorIndex());
        int c110 = this.getBlockColor(colorizer, world, state, originX + 1, originY + 1, originZ, quad.getColorIndex());
        int c111 = this.getBlockColor(colorizer, world, state, originX + 1, originY + 1, originZ + 1, quad.getColorIndex());
        float fracX = x - (float)intX;
        float fracY = y - (float)intY;
        float fracZ = z - (float)intZ;
        int dx1 = ColorMixer.getStartRatio(fracX);
        int dx2 = ColorMixer.getEndRatio(fracX);
        int dy1 = ColorMixer.getStartRatio(fracY);
        int dy2 = ColorMixer.getEndRatio(fracY);
        int dz1 = ColorMixer.getStartRatio(fracZ);
        int dz2 = ColorMixer.getEndRatio(fracZ);
        int c00 = ColorMixer.mixARGB(c000, c001, dz1, dz2);
        int c01 = ColorMixer.mixARGB(c100, c101, dz1, dz2);
        int c10 = ColorMixer.mixARGB(c010, c011, dz1, dz2);
        int c11 = ColorMixer.mixARGB(c110, c111, dz1, dz2);
        int c0 = ColorMixer.mixARGB(c00, c01, dy1, dy2);
        int c1 = ColorMixer.mixARGB(c10, c11, dy1, dy2);
        int c = ColorMixer.mixARGB(c0, c1, dx1, dx2);
        return ColorARGB.toABGR(c);
    }
}

