/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.animator;

import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.gui.animator.ValueAnimator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class ConventionValueAnimator<T>
implements ValueAnimator<T> {
    private final ValueAnimator<T> parent;
    private final Supplier<T> convention;
    private final long duration;

    ConventionValueAnimator(ValueAnimator<T> parent, Supplier<T> convention, long duration) {
        this.parent = parent;
        this.convention = convention;
        this.duration = duration;
        this.setAs(convention.get());
    }

    @Override
    public ValueAnimator<T> setTo(T value, long duration) {
        return this.parent.setTo(value, duration);
    }

    @Override
    public T target() {
        return this.convention.get();
    }

    @Override
    public T value() {
        return this.parent.value();
    }

    @Override
    public void update(double delta) {
        this.parent.update(delta);
        T target = this.target();
        if (!Objects.equals(this.parent.target(), target)) {
            this.setTo(target, this.duration);
        }
    }
}

