/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class Widgets {
    private Widgets() {
    }

    public static Widget createDrawableWidget(DrawableConsumer drawable) {
        return ClientInternals.getWidgetsProvider().createDrawableWidget(drawable);
    }

    public static Widget wrapVanillaWidget(class_364 element) {
        return new VanillaWrappedWidget(element);
    }

    public static WidgetWithBounds withTranslate(Widget widget, double x, double y, double z) {
        return Widgets.withTranslate(widget, class_1159.method_24021((float)((float)x), (float)((float)y), (float)((float)z)));
    }

    public static WidgetWithBounds withTranslate(Widget widget, class_1159 translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> translate);
    }

    public static <T extends Widget> WidgetWithBounds withTranslate(T widget, Function<T, class_1159> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> (class_1159)translate.apply(widget));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Supplier<class_1159> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, translate);
    }

    public static WidgetWithBounds wrapRenderer(Rectangle bounds, Renderer renderer) {
        if (renderer instanceof Widget) {
            Widget widget = (Widget)renderer;
            return Widgets.wrapWidgetWithBounds(widget, bounds);
        }
        return new RendererWrappedWidget(renderer, bounds);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget) {
        return Widgets.wrapWidgetWithBounds(widget, null);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget, Rectangle bounds) {
        if (widget instanceof WidgetWithBounds) {
            WidgetWithBounds withBounds = (WidgetWithBounds)widget;
            return withBounds;
        }
        if (bounds == null) {
            return new DelegateWidget(widget);
        }
        return new DelegateWidgetWithBounds(widget, bounds);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createTexturedConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    public static Widget createFilledRectangle(Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createFillRectangleConsumer(rectangle, color));
    }

    public static Label createLabel(Point point, class_2561 text) {
        return ClientInternals.getWidgetsProvider().createLabel(point, (class_5348)text);
    }

    public static Label createClickableLabel(Point point, class_2561 text, @Nullable Consumer<Label> onClick) {
        return Widgets.createLabel(point, text).clickable().onClick(onClick);
    }

    public static Arrow createArrow(Point point) {
        return ClientInternals.getWidgetsProvider().createArrow(new Rectangle(point, new Dimension(24, 17)));
    }

    public static BurningFire createBurningFire(Point point) {
        return ClientInternals.getWidgetsProvider().createBurningFire(new Rectangle(point, new Dimension(14, 14)));
    }

    public static Widget createSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public static Widget createResultSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    public static Panel createCategoryBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle);
    }

    public static Panel createCategoryBase(Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    public static Panel createRecipeBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    public static Panel createRecipeBase(Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    private static boolean shouldRecipeBaseRender(Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && ClientInternals.getWidgetsProvider().isRenderingPanel(panel);
    }

    public static Panel createSlotBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(Panel panel) {
        return true;
    }

    public static Panel createSlotBase(Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    public static Slot createSlot(Point point) {
        return ClientInternals.getWidgetsProvider().createSlot(point);
    }

    public static Slot createSlot(Rectangle bounds) {
        return ClientInternals.getWidgetsProvider().createSlot(bounds);
    }

    public static Button createButton(Rectangle bounds, class_2561 text) {
        return ClientInternals.getWidgetsProvider().createButton(bounds, text);
    }

    public static void produceClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    public static <T> Iterable<T> walk(final Iterable<? extends class_364> listeners, final Predicate<class_364> predicate) {
        return () -> new AbstractIterator<T>(){
            Stack<Iterator<? extends class_364>> stack = new Stack();
            {
                this.stack.push(listeners.iterator());
            }

            protected T computeNext() {
                while (!this.stack.empty()) {
                    WidgetHolder holder;
                    List<? extends class_364> children;
                    Iterator<? extends class_364> peek = this.stack.peek();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (this.stack.isEmpty()) break;
                    class_364 listener = peek.next();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (predicate.test(listener)) {
                        return listener;
                    }
                    if (listener instanceof class_4069) {
                        class_4069 handler = (class_4069)listener;
                        children = handler.method_25396();
                        if (children.isEmpty()) continue;
                        this.stack.push(children.iterator());
                        continue;
                    }
                    if (!(listener instanceof WidgetHolder) || (children = (holder = (WidgetHolder)listener).children()).isEmpty()) continue;
                    this.stack.push(children.iterator());
                }
                return this.endOfData();
            }
        };
    }

    private static class VanillaWrappedWidget
    extends Widget {
        private class_364 element;

        public VanillaWrappedWidget(class_364 element) {
            this.element = Objects.requireNonNull(element);
            this.method_25395(element);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_364 class_3642 = this.element;
            if (class_3642 instanceof class_332) {
                class_332 component = (class_332)class_3642;
                component.method_25304(this.getZ());
            }
            if ((class_3642 = this.element) instanceof class_4068) {
                class_4068 widget = (class_4068)class_3642;
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.element);
        }

        @Override
        @Nullable
        public class_364 method_25399() {
            return this.element;
        }

        @Override
        public void method_25395(@Nullable class_364 guiEventListener) {
            if (guiEventListener == this.element) {
                super.method_25395(this.element);
            } else {
                class_364 class_3642 = this.element;
                if (class_3642 instanceof class_4069) {
                    class_4069 handler = (class_4069)class_3642;
                    handler.method_25395(guiEventListener);
                }
            }
        }

        @Override
        public boolean method_25397() {
            return true;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.element.method_25405(mouseX, mouseY);
        }
    }

    private static class WidgetWithBoundsWithTranslate
    extends DelegateWidget {
        private final Supplier<class_1159> translate;

        private WidgetWithBoundsWithTranslate(WidgetWithBounds widget, Supplier<class_1159> translate) {
            super(widget);
            this.translate = translate;
        }

        @Override
        public void method_25394(class_4587 poseStack, int i, int j, float f) {
            poseStack.method_22903();
            poseStack.method_23760().method_23761().method_22672(this.translate.get());
            class_1162 mouse = this.transformMouse(i, j);
            super.method_25394(poseStack, (int)mouse.method_4953(), (int)mouse.method_4956(), f);
            poseStack.method_22909();
        }

        private class_1162 transformMouse(double mouseX, double mouseY) {
            class_1162 mouse = new class_1162((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            mouse.method_22674(this.translate.get());
            return mouse;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            class_1162 mouse = this.transformMouse(mouseX, mouseY);
            return super.containsMouse(mouse.method_4953(), mouse.method_4956());
        }

        public boolean method_25402(double d, double e, int i) {
            class_1162 mouse = this.transformMouse(d, e);
            return super.method_25402((double)mouse.method_4953(), (double)mouse.method_4956(), i);
        }

        public boolean method_25406(double d, double e, int i) {
            class_1162 mouse = this.transformMouse(d, e);
            return super.method_25406((double)mouse.method_4953(), (double)mouse.method_4956(), i);
        }

        public boolean method_25403(double d, double e, int i, double f, double g) {
            class_1162 mouse = this.transformMouse(d, e);
            return super.method_25403((double)mouse.method_4953(), (double)mouse.method_4956(), i, f, g);
        }

        public boolean method_25401(double d, double e, double f) {
            class_1162 mouse = this.transformMouse(d, e);
            return super.method_25401((double)mouse.method_4953(), (double)mouse.method_4956(), f);
        }
    }

    private static class RendererWrappedWidget
    extends WidgetWithBounds {
        private final Renderer renderer;
        private final Rectangle bounds;

        public RendererWrappedWidget(Renderer renderer, Rectangle bounds) {
            this.renderer = Objects.requireNonNull(renderer);
            this.bounds = Objects.requireNonNull(bounds);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.renderer.render(matrices, this.getBounds(), mouseX, mouseY, delta);
        }

        public List<? extends class_364> method_25396() {
            Renderer renderer = this.renderer;
            if (renderer instanceof class_364) {
                class_364 listener = (class_364)renderer;
                return Collections.singletonList(listener);
            }
            return Collections.emptyList();
        }

        @Override
        public void setZ(int z) {
            this.renderer.setZ(z);
        }

        @Override
        public int getZ() {
            return this.renderer.getZ();
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    private static class DelegateWidgetWithBounds
    extends DelegateWidget {
        private final Rectangle bounds;

        public DelegateWidgetWithBounds(Widget widget, Rectangle bounds) {
            super(widget);
            this.bounds = bounds;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

