/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.logging;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import me.shedaniel.rei.impl.common.logging.Logger;
import org.apache.logging.log4j.Level;

public class FileLogger
implements Logger {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final Writer writer;

    public FileLogger(Path file) {
        try {
            if (file.getParent() != null) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            file.toFile().createNewFile();
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.toFile()), StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    public void throwException(Throwable throwable) {
        throwable.printStackTrace(new PrintWriter(this.writer, true));
    }

    @Override
    public void log(Level level, String message) {
        message = String.format("[%s] [%s/%s] %s", DATE_TIME_FORMATTER.format(LocalDateTime.now()), Thread.currentThread().getName(), level, message);
        try {
            this.writer.write(message);
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void log(Level level, String message, Throwable throwable) {
        this.log(level, message);
        throwable.printStackTrace(new PrintWriter(this.writer, true));
    }
}

