/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_518;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        Display display = context.getDisplay();
        class_465<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        class_1703 menu = context.getMenu();
        MenuInfoContext<class_1703, class_1657, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, display);
        MenuInfo<class_1703, Display> menuInfo = MenuInfoRegistry.getInstance().getClient(display, menuInfoContext, menu);
        if (menuInfo == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            if (e.isApplicable()) {
                return TransferHandler.Result.createFailed(e.getError());
            }
            return TransferHandler.Result.createNotApplicable();
        }
        List<List<class_1799>> input = menuInfo.getInputs(menuInfoContext, false);
        IntList intList = this.hasItems(menuInfoContext, menu, menuInfo, display, input);
        if (!intList.isEmpty()) {
            return TransferHandler.Result.createFailed((class_2561)new class_2588("error.rei.not.enough.materials")).errorRenderer(new ErrorData(menuInfoContext, menuInfo, input, intList));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((class_2561)new class_2588("error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_518) {
            class_518 listener = (class_518)containerScreen;
            listener.method_2659().field_3092.method_2571();
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(display.getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(class_437.method_25442());
        buf.method_10794(menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((class_2960)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (class_2540)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public TransferHandlerErrorRenderer provideErrorRenderer(TransferHandler.Context context, Object data) {
        if (data instanceof ErrorData) {
            MenuInfoContext<class_1703, class_1657, Display> menuInfoContext = ((ErrorData)data).menuInfoContext;
            MenuInfo<class_1703, Display> menuInfo = ((ErrorData)data).menuInfo;
            List<List<class_1799>> inputs = ((ErrorData)data).inputs;
            IntList intList = ((ErrorData)data).intList;
            return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> menuInfo.renderMissingInput(menuInfoContext, inputs, intList, matrices, mouseX, mouseY, delta, widgets, bounds);
        }
        return null;
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<class_1703, class_1657, Display> ofContext(final class_1703 menu, final Display display) {
        return new MenuInfoContext<class_1703, class_1657, Display>(){

            @Override
            public class_1703 getMenu() {
                return menu;
            }

            @Override
            public class_1657 getPlayerEntity() {
                return class_310.method_1551().field_1724;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(MenuInfoContext<class_1703, class_1657, Display> menuInfoContext, class_1703 menu, MenuInfo<class_1703, Display> info, Display display, List<List<class_1799>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(menuInfoContext, recipeFinder);
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List<class_1799> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (class_1799 possibleStack : possibleStacks) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.method_7947(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            intList.add(i);
        }
        return intList;
    }

    private static class ErrorData {
        private MenuInfoContext<class_1703, class_1657, Display> menuInfoContext;
        private MenuInfo<class_1703, Display> menuInfo;
        private List<List<class_1799>> inputs;
        private IntList intList;

        public ErrorData(MenuInfoContext<class_1703, class_1657, Display> menuInfoContext, MenuInfo<class_1703, Display> menuInfo, List<List<class_1799>> inputs, IntList intList) {
            this.menuInfoContext = menuInfoContext;
            this.menuInfo = menuInfo;
            this.inputs = inputs;
            this.intList = intList;
        }
    }
}

