/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import me.shedaniel.rei.plugin.client.runtime.FilteredStacksVisibilityHandler;
import me.shedaniel.rei.plugin.client.runtime.PluginStageExecutionWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchBarHighlightWatcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    private final FilteredStacksVisibilityHandler filteredStacksVisibilityHandler = new FilteredStacksVisibilityHandler();

    public DefaultClientRuntimePlugin() {
        PluginStageExecutionWatcher watcher = new PluginStageExecutionWatcher();
        for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
            instance.registerReloadable(watcher.reloadable(instance));
        }
        REIRuntimeImpl.getInstance().addHintProvider(watcher);
        REIRuntimeImpl.getInstance().addHintProvider(new SearchBarHighlightWatcher());
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (((Boolean)ClientHelperImpl.getInstance().isAprilFools.method_15332()).booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new AbstractRenderer(){
                private class_2960 id = new class_2960("roughlyenoughitems", "textures/gui/kirb.png");

                @Override
                public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)this.id);
                    1.method_25295((class_1159)matrices.method_23760().method_23761(), (int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)this.method_25305(), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(Point point) {
                    return Tooltip.create(new class_2561[]{new class_2585("Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
        ((EntryRegistryImpl)registry).refilterListener.add(this.filteredStacksVisibilityHandler::reset);
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        this.filteredStacksVisibilityHandler.reset();
        registry.registerVisibilityPredicate(this.filteredStacksVisibilityHandler);
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(class_437.class, screen -> {
            FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null && widget.favoritePanelButton.isVisible()) {
                return Collections.singletonList(widget.favoritePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDecider(new DisplayBoundsProvider<AbstractDisplayViewingScreen>(){

            @Override
            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            @Override
            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            @Override
            public class_1269 shouldScreenBeOverlaid(Class<?> screen) {
                return class_1269.field_5812;
            }
        });
        registry.registerDraggableStackProvider(DraggableStackProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().method_25396(), DraggableStackProviderWidget.class::isInstance);
        }));
        registry.registerDraggableStackVisitor(DraggableStackVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().method_25396(), DraggableStackVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultCategoryHandler());
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private class_2960 id;

        private EntryStackFavoriteType(class_2960 id) {
            this.id = id;
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> read(class_2487 object) {
            EntryStack<?> stack;
            try {
                stack = EntryStack.read(object.method_10562("data"));
            }
            catch (Throwable throwable) {
                return DataResult.error((String)throwable.getMessage());
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create EntryStackFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof EntryStack)) {
                return DataResult.error((String)"Creation of EntryStackFavoriteEntry from args expected EntryStack as the first argument!");
            }
            EntryStack stack = (EntryStack)object;
            if (!stack.supportSaving()) {
                return DataResult.error((String)"Creation of EntryStackFavoriteEntry from an unserializable stack!");
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public class_2487 save(EntryStackFavoriteEntry entry, class_2487 tag) {
            tag.method_10566("data", (class_2520)entry.stack.save());
            return tag;
        }
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hash;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hash = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(int button) {
            if (!ClientHelper.getInstance().isCheating() || class_310.method_1551().field_1755 instanceof DisplayScreen) {
                return false;
            }
            EntryStack<?> entry = this.stack.copy();
            if (!entry.isEmpty()) {
                if (entry.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<class_1799> cheatsAs = entry.cheatsAs();
                    EntryStack<Object> entryStack = entry = cheatsAs.isEmpty() ? entry : cheatsAs;
                }
                if (entry.getType() == VanillaEntryTypes.ITEM) {
                    ((class_1799)entry.castValue()).method_7939(button != 1 && !class_437.method_25442() ? 1 : ((class_1799)entry.castValue()).method_7914());
                }
                return ClientHelper.getInstance().tryCheatingEntry(entry);
            }
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public class_2960 getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)other;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }
}

