/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCraftingDisplay<C extends class_1860<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe) {
        super(inputs, outputs, Optional.empty());
        this.recipe = recipe;
    }

    @Nullable
    public static DefaultCraftingDisplay<?> of(class_1860<?> recipe) {
        if (recipe instanceof class_1867) {
            return new DefaultShapelessDisplay((class_1867)recipe);
        }
        if (recipe instanceof class_1869) {
            return new DefaultShapedDisplay((class_1869)recipe);
        }
        if (!recipe.method_8118()) {
            Pair size;
            class_2371 ingredients = recipe.method_8117();
            Pair pair = size = Platform.isFabric() ? null : DefaultCraftingDisplay.getSize(recipe);
            if (!ingredients.isEmpty()) {
                if (size == null) {
                    return new DefaultCustomDisplay(recipe, EntryIngredients.ofIngredients((List<class_1856>)recipe.method_8117()), Collections.singletonList(EntryIngredients.of(recipe.method_8110())));
                }
                return new DefaultCustomShapedDisplay(recipe, EntryIngredients.ofIngredients((List<class_1856>)recipe.method_8117()), Collections.singletonList(EntryIngredients.of(recipe.method_8110())), (Integer)size.getLeft(), (Integer)size.getRight());
            }
        }
        return null;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return this.getOptionalRecipe().map(class_1860::method_8114);
    }

    public <T extends class_1703> List<List<class_1799>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap(ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends class_1703> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultCraftingDisplay.getSlotWithSize(display.getWidth(), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<DefaultCraftingDisplay<?>> serializer() {
        return BasicDisplay.Serializer.ofSimple(DefaultCustomDisplay::simple).inputProvider(display -> display.getOrganisedInputEntries(3, 3));
    }

    @Override
    public List<EntryIngredient> getInputEntries(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(9);
        for (int i = 0; i < 9; ++i) {
            list.add(EntryIngredient.empty());
        }
        List<EntryIngredient> inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, 3), inputEntries.get(i));
        }
        return list;
    }
}

