/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.render.RenderUtils;
import javax.annotation.Nullable;
import net.minecraft.class_4587;
import org.apache.commons.lang3.StringUtils;

public class ButtonGeneric
extends ButtonBase {
    @Nullable
    protected final IGuiIcon icon;
    protected LeftRight alignment = LeftRight.LEFT;
    protected boolean textCentered;
    protected boolean renderDefaultBackground = true;

    public ButtonGeneric(int x, int y, int width, boolean rightAlign, String translationKey, Object ... args) {
        this(x, y, width, 20, fi.dy.masa.malilib.util.StringUtils.translate(translationKey, args), new String[0]);
        if (rightAlign) {
            this.x = x - this.width;
        }
    }

    public ButtonGeneric(int x, int y, int width, int height, String text, String ... hoverStrings) {
        this(x, y, width, height, text, (IGuiIcon)null, hoverStrings);
        this.textCentered = true;
    }

    public ButtonGeneric(int x, int y, int width, int height, String text, IGuiIcon icon, String ... hoverStrings) {
        super(x, y, width, height, text);
        this.icon = icon;
        if (width == -1 && icon != null) {
            this.width += icon.getWidth() + 8;
        }
        if (hoverStrings.length > 0) {
            this.setHoverStrings(hoverStrings);
        }
    }

    public ButtonGeneric(int x, int y, IGuiIcon icon, String ... hoverStrings) {
        this(x, y, icon.getWidth(), icon.getHeight(), "", icon, hoverStrings);
        this.setRenderDefaultBackground(false);
    }

    @Override
    public ButtonGeneric setActionListener(@Nullable IButtonActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public ButtonGeneric setTextCentered(boolean centered) {
        this.textCentered = centered;
        return this;
    }

    public ButtonGeneric setIconAlignment(LeftRight alignment) {
        this.alignment = alignment;
        return this;
    }

    public ButtonGeneric setRenderDefaultBackground(boolean render) {
        this.renderDefaultBackground = render;
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int buttonStyle = this.getTextureOffset(this.hovered);
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.setupBlend();
            RenderUtils.setupBlendSimple();
            if (this.renderDefaultBackground) {
                this.bindTexture(BUTTON_TEXTURES);
                RenderUtils.drawTexturedRect(this.x, this.y, 0, 46 + buttonStyle * 20, this.width / 2, this.height);
                RenderUtils.drawTexturedRect(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + buttonStyle * 20, this.width / 2, this.height);
            }
            if (this.icon != null) {
                int offset = this.renderDefaultBackground ? 4 : 0;
                int x = this.alignment == LeftRight.LEFT ? this.x + offset : this.x + this.width - this.icon.getWidth() - offset;
                int y = this.y + (this.height - this.icon.getHeight()) / 2;
                int u = this.icon.getU() + buttonStyle * this.icon.getWidth();
                this.bindTexture(this.icon.getTexture());
                RenderUtils.drawTexturedRect(x, y, u, this.icon.getV(), this.icon.getWidth(), this.icon.getHeight());
            }
            if (!StringUtils.isBlank((CharSequence)this.displayString)) {
                int y = this.y + (this.height - 8) / 2;
                int color = 0xE0E0E0;
                if (!this.enabled) {
                    color = 0xA0A0A0;
                } else if (this.hovered) {
                    color = 0xFFFFA0;
                }
                if (this.textCentered) {
                    this.drawCenteredStringWithShadow(this.x + this.width / 2, y, color, this.displayString, matrixStack);
                } else {
                    int x = this.x + 6;
                    if (this.icon != null && this.alignment == LeftRight.LEFT) {
                        x += this.icon.getWidth() + 2;
                    }
                    this.drawStringWithShadow(x, y, color, this.displayString, matrixStack);
                }
            }
        }
    }
}

