/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import java.util.Random;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.texture.TextureUploadHelper;
import org.lwjgl.opengl.GL11C;

public class NoiseTexture
extends GlResource {
    int width;
    int height;

    public NoiseTexture(int width, int height) {
        super(GL11C.glGenTextures());
        GlStateManager._bindTexture((int)this.getGlId());
        GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11C.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11C.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11C.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11C.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11C.glTexParameteri((int)3553, (int)33082, (int)0);
        GL11C.glTexParameteri((int)3553, (int)33083, (int)0);
        GL11C.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        this.resize(width, height);
        GlStateManager._bindTexture((int)0);
    }

    void resize(int width, int height) {
        this.width = width;
        this.height = height;
        GlStateManager._bindTexture((int)this.getGlId());
        ByteBuffer pixels = this.generateNoise();
        TextureUploadHelper.resetTextureUploadState();
        GlStateManager._pixelStore((int)3317, (int)1);
        GL11C.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)pixels);
        GlStateManager._bindTexture((int)0);
    }

    private ByteBuffer generateNoise() {
        byte[] pixels = new byte[3 * this.width * this.height];
        Random random = new Random(0L);
        random.nextBytes(pixels);
        ByteBuffer buffer = ByteBuffer.allocateDirect(pixels.length);
        buffer.put(pixels);
        buffer.flip();
        return buffer;
    }

    public int getTextureId() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GL11C.glDeleteTextures((int)this.getGlId());
    }
}

