/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LegacyIdMap;
import net.coderbot.iris.shaderpack.PropertiesPreprocessor;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;

public class IdMap {
    private final Object2IntMap<class_2960> itemIdMap;
    private final Object2IntMap<class_2960> entityIdMap;
    private Object2IntMap<class_2680> blockPropertiesMap;
    private Map<class_2960, class_1921> blockRenderTypeMap;

    IdMap(Path shaderPath) {
        this.itemIdMap = IdMap.loadProperties(shaderPath, "item.properties").map(IdMap::parseItemIdMap).orElse(Object2IntMaps.emptyMap());
        this.entityIdMap = IdMap.loadProperties(shaderPath, "entity.properties").map(IdMap::parseEntityIdMap).orElse(Object2IntMaps.emptyMap());
        IdMap.loadProperties(shaderPath, "block.properties").ifPresent(blockProperties -> {
            this.blockPropertiesMap = IdMap.parseBlockMap(blockProperties, "block.", "block.properties");
            this.blockRenderTypeMap = IdMap.parseRenderTypeMap(blockProperties, "layer.", "block.properties");
        });
        if (this.blockPropertiesMap == null) {
            this.blockPropertiesMap = new Object2IntOpenHashMap();
            LegacyIdMap.addLegacyValues(this.blockPropertiesMap);
        }
        if (this.blockRenderTypeMap == null) {
            this.blockRenderTypeMap = Collections.emptyMap();
        }
    }

    private static Optional<Properties> loadProperties(Path shaderPath, String name) {
        String fileContents = IdMap.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        String processed = PropertiesPreprocessor.process(shaderPath.getParent(), shaderPath, fileContents);
        StringReader propertiesReader = new StringReader(processed);
        Properties properties = new Properties();
        try {
            properties.load(propertiesReader);
        }
        catch (IOException e) {
            Iris.logger.error("Error loading " + name + " at " + shaderPath);
            Iris.logger.catching(Level.ERROR, (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug("An " + name + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException e) {
            Iris.logger.error("An IOException occurred reading " + name + " from the current shaderpack");
            Iris.logger.catching(Level.ERROR, (Throwable)e);
            return null;
        }
    }

    private static Object2IntMap<class_2960> parseItemIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "item.", "item.properties");
    }

    private static Object2IntMap<class_2960> parseEntityIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "entity.", "entity.properties");
    }

    private static Object2IntMap<class_2960> parseIdMap(Properties properties, String keyPrefix, String fileName) {
        Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseIdMap$1(keyPrefix, fileName, (Object2IntMap)idMap, arg_0, arg_1)));
        return Object2IntMaps.unmodifiable((Object2IntMap)idMap);
    }

    private static Object2IntMap<class_2680> parseBlockMap(Properties properties, String keyPrefix, String fileName) {
        Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseBlockMap$2(keyPrefix, fileName, (Object2IntMap)idMap, arg_0, arg_1)));
        return Object2IntMaps.unmodifiable((Object2IntMap)idMap);
    }

    private static void addBlockStates(String entry, Object2IntMap<class_2680> idMap, int intId) {
        class_2960 ResourceLocation;
        int statesStart;
        String[] splitStates = entry.split(":");
        if (splitStates.length == 0) {
            return;
        }
        if (splitStates.length == 1 || splitStates.length == 2 && !splitStates[1].contains("=")) {
            class_2960 ResourceLocation2 = new class_2960(entry);
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(ResourceLocation2);
            if (block == class_2246.field_10124) {
                return;
            }
            for (class_2680 state : block.method_9595().method_11662()) {
                idMap.put((Object)state, intId);
            }
            return;
        }
        if (splitStates[1].contains("=")) {
            statesStart = 1;
            ResourceLocation = new class_2960(splitStates[0]);
        } else {
            statesStart = 2;
            ResourceLocation = new class_2960(splitStates[0], splitStates[1]);
        }
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(ResourceLocation);
        if (!(block != class_2246.field_10124 || ResourceLocation.method_12832().equals("air") && ResourceLocation.method_12836().equals("minecraft"))) {
            Iris.logger.debug("Failed to parse the block ID map entry \"" + entry + "\":");
            Iris.logger.debug("- There is no block with the name " + ResourceLocation + "!");
            return;
        }
        HashMap properties = new HashMap();
        class_2689 stateManager = block.method_9595();
        for (int index = statesStart; index < splitStates.length; ++index) {
            String[] propertyParts = splitStates[index].split("=");
            if (propertyParts.length != 2) {
                Iris.logger.warn("Failed to parse the block ID map entry \"" + entry + "\":");
                Iris.logger.warn("- Block state property filters must be of the form \"key=value\", but " + splitStates[index] + " is not of that form!");
                return;
            }
            String key = propertyParts[0];
            String value = propertyParts[1];
            class_2769 property = stateManager.method_11663(key);
            if (property == null) {
                Iris.logger.warn("Error while parsing the block ID map entry \"" + entry + "\":");
                Iris.logger.warn("- The block " + ResourceLocation + " has no property with the name " + key + ", ignoring!");
                continue;
            }
            properties.put(property, value);
        }
        for (class_2680 state : stateManager.method_11662()) {
            if (!IdMap.checkState(state, properties)) continue;
            idMap.put((Object)state, intId);
        }
    }

    private static boolean checkState(class_2680 state, Map<class_2769<?>, String> expectedValues) {
        for (Map.Entry<class_2769<?>, String> condition : expectedValues.entrySet()) {
            String actualValue;
            class_2769<?> property = condition.getKey();
            String expectedValue = condition.getValue();
            if (expectedValue.equals(actualValue = property.method_11901(state.method_11654(property)))) continue;
            return false;
        }
        return true;
    }

    private static Map<class_2960, class_1921> parseRenderTypeMap(Properties properties, String keyPrefix, String fileName) {
        HashMap<class_2960, class_1921> layerMap = new HashMap<class_2960, class_1921>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            class_1921 layerType;
            String[] key = (String[])keyObject;
            String value = (String)valueObject;
            if (!key.startsWith(keyPrefix)) {
                return;
            }
            switch (key) {
                case "solid": {
                    layerType = class_1921.method_23577();
                    break;
                }
                case "cutout": {
                    layerType = class_1921.method_23581();
                    break;
                }
                case "cutout_mipped": {
                    layerType = class_1921.method_23579();
                    break;
                }
                case "translucent": {
                    layerType = class_1921.method_23583();
                    break;
                }
                default: {
                    Iris.logger.warn("Failed to parse line in " + fileName + ": invalid render layer type: " + (String)key);
                    return;
                }
            }
            for (String part : value.split(" ")) {
                try {
                    class_2960 ResourceLocation = new class_2960(part);
                    layerMap.put(ResourceLocation, layerType);
                }
                catch (Exception e) {
                    Iris.logger.warn("Failed to parse an ResourceLocation in " + fileName + " for the key " + (String)key + ":");
                    Iris.logger.catching(Level.WARN, (Throwable)e);
                }
            }
        }));
        return layerMap;
    }

    public Map<class_2680, Integer> getBlockProperties() {
        return this.blockPropertiesMap;
    }

    public Map<class_2960, Integer> getItemIdMap() {
        return this.itemIdMap;
    }

    public Map<class_2960, Integer> getEntityIdMap() {
        return this.entityIdMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdMap idMap = (IdMap)o;
        return Objects.equals(this.itemIdMap, idMap.itemIdMap) && Objects.equals(this.entityIdMap, idMap.entityIdMap) && Objects.equals(this.blockPropertiesMap, idMap.blockPropertiesMap) && Objects.equals(this.blockRenderTypeMap, idMap.blockRenderTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.itemIdMap, this.entityIdMap, this.blockPropertiesMap, this.blockRenderTypeMap);
    }

    private static /* synthetic */ void lambda$parseBlockMap$2(String keyPrefix, String fileName, Object2IntMap idMap, Object keyObject, Object valueObject) {
        int intId;
        String key = (String)keyObject;
        String value = (String)valueObject;
        if (!key.startsWith(keyPrefix)) {
            return;
        }
        try {
            intId = Integer.parseInt(key.substring(keyPrefix.length()));
        }
        catch (NumberFormatException e) {
            Iris.logger.warn("Failed to parse line in " + fileName + ": invalid key " + key);
            return;
        }
        for (String part : value.split(" ")) {
            try {
                IdMap.addBlockStates(part, (Object2IntMap<class_2680>)idMap, intId);
            }
            catch (Exception e) {
                Iris.logger.warn("Failed to parse an ResourceLocation in " + fileName + " for the key " + key + ":");
                Iris.logger.catching(Level.WARN, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void lambda$parseIdMap$1(String keyPrefix, String fileName, Object2IntMap idMap, Object keyObject, Object valueObject) {
        int intId;
        String key = (String)keyObject;
        String value = (String)valueObject;
        if (!key.startsWith(keyPrefix)) {
            return;
        }
        try {
            intId = Integer.parseInt(key.substring(keyPrefix.length()));
        }
        catch (NumberFormatException e) {
            Iris.logger.warn("Failed to parse line in " + fileName + ": invalid key " + key);
            return;
        }
        for (String part : value.split(" ")) {
            if (part.contains("=")) {
                Iris.logger.warn("Failed to parse an ResourceLocation in " + fileName + " for the key " + key + ": state properties are currently not supported: " + part);
                continue;
            }
            try {
                class_2960 ResourceLocation = new class_2960(part);
                idMap.put((Object)ResourceLocation, intId);
            }
            catch (Exception e) {
                Iris.logger.warn("Failed to parse an ResourceLocation in " + fileName + " for the key " + key + ":");
                Iris.logger.catching(Level.WARN, (Throwable)e);
            }
        }
    }
}

