/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import net.coderbot.iris.shaderpack.DirectiveHolder;

public class PackShadowDirectives {
    public static final int MAX_SHADOW_COLOR_BUFFERS = 2;
    private int resolution = 1024;
    private Float fov = null;
    private float distance = 160.0f;
    private float distanceRenderMul = -1.0f;
    private boolean explicitRenderDistance = false;
    private float intervalSize = 2.0f;
    private final ImmutableList<DepthSamplingSettings> depthSamplingSettings = ImmutableList.of((Object)new DepthSamplingSettings(), (Object)new DepthSamplingSettings());
    private final ImmutableList<SamplingSettings> colorSamplingSettings;

    public PackShadowDirectives() {
        ImmutableList.Builder colorSamplingSettings = ImmutableList.builder();
        for (int i = 0; i < 2; ++i) {
            colorSamplingSettings.add((Object)new SamplingSettings());
        }
        this.colorSamplingSettings = colorSamplingSettings.build();
    }

    public int getResolution() {
        return this.resolution;
    }

    public Float getFov() {
        return this.fov;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getDistanceRenderMul() {
        return this.distanceRenderMul;
    }

    public boolean isDistanceRenderMulExplicit() {
        return this.explicitRenderDistance;
    }

    public float getIntervalSize() {
        return this.intervalSize;
    }

    public ImmutableList<DepthSamplingSettings> getDepthSamplingSettings() {
        return this.depthSamplingSettings;
    }

    public ImmutableList<SamplingSettings> getColorSamplingSettings() {
        return this.colorSamplingSettings;
    }

    public void acceptDirectives(DirectiveHolder directives) {
        directives.acceptCommentIntDirective("SHADOWRES", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptConstIntDirective("shadowMapResolution", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptCommentFloatDirective("SHADOWFOV", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptConstFloatDirective("shadowMapFov", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptCommentFloatDirective("SHADOWHPL", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("shadowDistance", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("shadowDistanceRenderMul", distanceRenderMul -> {
            this.distanceRenderMul = distanceRenderMul;
            this.explicitRenderDistance = true;
        });
        directives.acceptConstFloatDirective("shadowIntervalSize", intervalSize -> {
            this.intervalSize = intervalSize;
        });
        PackShadowDirectives.acceptHardwareFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptDepthMipmapSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorMipmapSettings(directives, this.colorSamplingSettings);
        PackShadowDirectives.acceptDepthFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorFilteringSettings(directives, this.colorSamplingSettings);
    }

    private static void acceptHardwareFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("shadowHardwareFiltering", hardwareFiltering -> {
            for (DepthSamplingSettings samplerSettings : samplers) {
                samplerSettings.setHardwareFiltering(hardwareFiltering);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowHardwareFiltering" + i;
            directives.acceptConstBooleanDirective(name, arg_0 -> PackShadowDirectives.lambda$acceptHardwareFilteringSettings$9((DepthSamplingSettings)samplers.get(i), arg_0));
        }
    }

    private static void acceptDepthMipmapSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexMipmap", ((DepthSamplingSettings)samplers.get(0))::setMipmap);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowtex" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptColorMipmapSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowColorMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowcolor" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
            name = "shadowColor" + i + "Mipmap";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptDepthFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexNearest", ((DepthSamplingSettings)samplers.get(0))::setNearest);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowtex" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
            name = "shadow" + i + "MinMagNearest";
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
        }
    }

    private static void acceptColorFilteringSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        for (int i = 0; i < samplers.size(); ++i) {
            String name = "shadowcolor" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = "shadowColor" + i + "Nearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = "shadowColor" + i + "MinMagNearest";
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
        }
    }

    public String toString() {
        return "PackShadowDirectives{resolution=" + this.resolution + ", fov=" + this.fov + ", distance=" + this.distance + ", distanceRenderMul=" + this.distanceRenderMul + ", intervalSize=" + this.intervalSize + ", depthSamplingSettings=" + this.depthSamplingSettings + ", colorSamplingSettings=" + this.colorSamplingSettings + '}';
    }

    private static /* synthetic */ void lambda$acceptHardwareFilteringSettings$9(DepthSamplingSettings rec$, boolean x$0) {
        rec$.setHardwareFiltering(x$0);
    }

    public static class DepthSamplingSettings
    extends SamplingSettings {
        private boolean hardwareFiltering = false;

        private void setHardwareFiltering(boolean hardwareFiltering) {
            this.hardwareFiltering = hardwareFiltering;
        }

        public boolean getHardwareFiltering() {
            return this.hardwareFiltering;
        }

        @Override
        public String toString() {
            return "DepthSamplingSettings{mipmap=" + this.getMipmap() + ", nearest=" + this.getNearest() + ", hardwareFiltering=" + this.hardwareFiltering + '}';
        }
    }

    public static class SamplingSettings {
        private boolean mipmap = false;
        private boolean nearest = false;

        protected void setMipmap(boolean mipmap) {
            this.mipmap = mipmap;
        }

        protected void setNearest(boolean nearest) {
            this.nearest = nearest;
        }

        public boolean getMipmap() {
            return this.mipmap;
        }

        public boolean getNearest() {
            return this.nearest;
        }

        public String toString() {
            return "SamplingSettings{mipmap=" + this.mipmap + ", nearest=" + this.nearest + '}';
        }
    }
}

