/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.transform;

import net.coderbot.iris.shaderpack.transform.Transformations;

public class BuiltinUniformReplacementTransformer {
    private String normalizedLightmapCoords;
    private static final String NORMALIZED_PLACEHOLDER = "iris_NormalizedLightmapCoords";

    public BuiltinUniformReplacementTransformer() {
        this.normalizedLightmapCoords = "(gl_MultiTexCoord1.xy)";
    }

    public BuiltinUniformReplacementTransformer(float lightmapScale) {
        this.normalizedLightmapCoords = "(gl_MultiTexCoord1.xy * " + lightmapScale + ")";
    }

    public BuiltinUniformReplacementTransformer(String customNormalizedLightmapCoordsExpression) {
        this.normalizedLightmapCoords = customNormalizedLightmapCoordsExpression;
    }

    public void apply(Transformations transformations) {
        this.applyCommonCases(transformations);
        this.applyFallbackCases(transformations);
        transformations.replaceExact(NORMALIZED_PLACEHOLDER, this.normalizedLightmapCoords);
    }

    private void applyCommonCases(Transformations transformations) {
        if (transformations.contains(NORMALIZED_PLACEHOLDER)) {
            throw new AssertionError();
        }
        transformations.replaceExact("(gl_TextureMatrix[1]*gl_MultiTexCoord1).st", NORMALIZED_PLACEHOLDER);
        transformations.replaceExact("(gl_TextureMatrix[1] * gl_MultiTexCoord1).st", NORMALIZED_PLACEHOLDER);
        transformations.replaceExact("(gl_TextureMatrix[1]*gl_MultiTexCoord1).xy", NORMALIZED_PLACEHOLDER);
        transformations.replaceExact("(gl_TextureMatrix[1] * gl_MultiTexCoord1).xy", NORMALIZED_PLACEHOLDER);
        transformations.replaceExact("(gl_TextureMatrix[1] * gl_MultiTexCoord1).s", "iris_NormalizedLightmapCoords.s");
        transformations.replaceExact("gl_TextureMatrix[1] * gl_MultiTexCoord1", "vec4(iris_NormalizedLightmapCoords, 0.0, 1.0)");
        transformations.replaceExact("gl_MultiTexCoord1.xy/255.0", NORMALIZED_PLACEHOLDER);
    }

    private void applyFallbackCases(Transformations transformations) {
        transformations.replaceExact("gl_TextureMatrix[1]", "iris_LightmapTextureMatrix");
        transformations.replaceExact("gl_MultiTexCoord1", "vec4(iris_NormalizedLightmapCoords * 255.0, 0.0, 1.0)");
        if (transformations.contains("iris_LightmapTextureMatrix")) {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform mat4 iris_LightmapTextureMatrix;");
        }
    }
}

