/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.mixin.DimensionTypeAccessor;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.vendored.joml.Math;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class HardcodedCustomUniforms {
    public static void addHardcodedCustomUniforms(UniformHolder holder, FrameUpdateNotifier updateNotifier) {
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeAngle", HardcodedCustomUniforms::getTimeAngle);
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeBrightness", HardcodedCustomUniforms::getTimeBrightness);
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "moonBrightness", HardcodedCustomUniforms::getMoonBrightness);
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowFade", HardcodedCustomUniforms::getShadowFade);
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainStrengthS", HardcodedCustomUniforms.rainStrengthS(updateNotifier));
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "blindFactor", HardcodedCustomUniforms::getBlindFactor);
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isDry", new SmoothedFloat(20.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 0.0f ? 1.0f : 0.0f, updateNotifier));
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isRainy", new SmoothedFloat(20.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 1.0f ? 1.0f : 0.0f, updateNotifier));
        holder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isSnowy", new SmoothedFloat(20.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 2.0f ? 1.0f : 0.0f, updateNotifier));
    }

    private static float getTimeAngle() {
        return (float)HardcodedCustomUniforms.getWorldDayTime() / 24000.0f;
    }

    private static int getWorldDayTime() {
        class_638 level = class_310.method_1551().field_1687;
        long timeOfDay = level.method_8532();
        long dayTime = ((DimensionTypeAccessor)level.method_8597()).getFixedTime().orElse(timeOfDay % 24000L);
        return (int)dayTime;
    }

    private static float getTimeBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * 2.0), 0.0);
    }

    private static float getMoonBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * -2.0), 0.0);
    }

    private static float getShadowFade() {
        return (float)Math.clamp(0.0, 1.0, 1.0 - (java.lang.Math.abs(java.lang.Math.abs((double)CelestialUniforms.getSunAngle() - 0.5) - 0.25) - 0.23) * 100.0);
    }

    private static SmoothedFloat rainStrengthS(FrameUpdateNotifier updateNotifier) {
        return new SmoothedFloat(15.0f, CommonUniforms::getRainStrength, updateNotifier);
    }

    private static float getRawPrecipitation() {
        if (class_310.method_1551().field_1687 == null) {
            return 0.0f;
        }
        class_1959.class_1963 precipitation = class_310.method_1551().field_1687.method_23753(class_310.method_1551().method_1560().method_24515()).method_8694();
        switch (precipitation) {
            case field_9382: {
                return 1.0f;
            }
            case field_9383: {
                return 2.0f;
            }
        }
        return 0.0f;
    }

    private static float getBlindFactor() {
        float blindFactorSqrt = (float)Math.clamp(0.0, 1.0, (double)CommonUniforms.getBlindness() * 2.0 - 1.0);
        return blindFactorSqrt * blindFactorSqrt;
    }

    private static float frac(float value) {
        return java.lang.Math.abs(value % 1.0f);
    }
}

