/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.aocalc.AoConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Indium
implements ClientModInitializer {
    public static final boolean ALWAYS_TESSELATE_INDIUM;
    public static final AoConfig AMBIENT_OCCLUSION_MODE;
    public static final boolean DEBUG_COMPARE_LIGHTING;
    public static final boolean FIX_SMOOTH_LIGHTING_OFFSET;
    public static final boolean FIX_EXTERIOR_VERTEX_LIGHTING;
    public static final boolean FIX_LUMINOUS_AO_SHADE;
    public static final Logger LOGGER;

    private static boolean asBoolean(String property, boolean defValue) {
        switch (Indium.asTriState(property)) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return defValue;
    }

    private static <T extends Enum> T asEnum(String property, T defValue) {
        if (property == null || property.isEmpty()) {
            return defValue;
        }
        for (Enum obj : (Enum[])defValue.getClass().getEnumConstants()) {
            if (!property.equalsIgnoreCase(obj.name())) continue;
            return (T)obj;
        }
        return defValue;
    }

    private static TriState asTriState(String property) {
        if (property == null || property.isEmpty()) {
            return TriState.DEFAULT;
        }
        switch (property.toLowerCase(Locale.ROOT)) {
            case "true": {
                return TriState.TRUE;
            }
            case "false": {
                return TriState.FALSE;
            }
        }
        return TriState.DEFAULT;
    }

    public void onInitializeClient() {
        try {
            RendererAccess.INSTANCE.registerRenderer((Renderer)IndiumRenderer.INSTANCE);
        }
        catch (UnsupportedOperationException e) {
            if (FabricLoader.getInstance().isModLoaded("canvas")) {
                throw new RuntimeException("Failed to load Indium: Indium and Sodium are not compatible with Canvas");
            }
            if (FabricLoader.getInstance().isModLoaded("frex")) {
                String msg = "Failed to load Indium: Indium is not currently compatible with FREX 6.x, as it provides an incompatible implementation of the Fabric Rendering API; the FREX API may be directly supported in future.";
                Optional container = FabricLoader.getInstance().getModContainer("frex");
                if (container.isPresent()) {
                    StringBuilder sb = new StringBuilder(msg);
                    boolean first = true;
                    Optional parent = ((ModContainer)container.get()).getContainingMod();
                    while (parent.isPresent()) {
                        sb.append('\n').append(first ? "  FREX" : "  which");
                        first = false;
                        sb.append(" is bundled as part of ").append(((ModContainer)parent.get()).getMetadata().getName());
                        parent = ((ModContainer)parent.get()).getContainingMod();
                    }
                    throw new RuntimeException(sb.toString());
                }
                throw new RuntimeException(msg);
            }
            throw e;
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)SpriteFinderCache.ReloadListener.INSTANCE);
    }

    static {
        Closeable stream;
        LOGGER = LogManager.getLogger();
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("indium-renderer.properties");
        Properties properties = new Properties();
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                stream = Files.newInputStream(configFile, new OpenOption[0]);
                try {
                    properties.load((InputStream)stream);
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("[Indium] Could not read property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
            }
        }
        ALWAYS_TESSELATE_INDIUM = Indium.asBoolean((String)properties.computeIfAbsent("always-tesselate-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        AMBIENT_OCCLUSION_MODE = Indium.asEnum((String)properties.computeIfAbsent("ambient-occlusion-mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), AoConfig.ENHANCED);
        DEBUG_COMPARE_LIGHTING = Indium.asBoolean((String)properties.computeIfAbsent("debug-compare-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        FIX_SMOOTH_LIGHTING_OFFSET = Indium.asBoolean((String)properties.computeIfAbsent("fix-smooth-lighting-offset", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_EXTERIOR_VERTEX_LIGHTING = Indium.asBoolean((String)properties.computeIfAbsent("fix-exterior-vertex-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_LUMINOUS_AO_SHADE = Indium.asBoolean((String)properties.computeIfAbsent("fix-luminous-block-ambient-occlusion", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        try {
            stream = Files.newOutputStream(configFile, new OpenOption[0]);
            try {
                properties.store((OutputStream)stream, "Indium properties file");
            }
            finally {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("[Indium] Could not store property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
        }
    }
}

