/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.biome.BiomeRetriever;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1275;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BaseProcessingPredicate
implements ProcessingPredicate {
    protected Set<class_2960> matchTilesSet;
    protected EnumSet<class_2350> faces;
    protected Predicate<class_1959> biomePredicate;
    protected IntPredicate heightPredicate;
    protected Predicate<String> blockEntityNamePredicate;

    public BaseProcessingPredicate(Set<class_2960> matchTilesSet, EnumSet<class_2350> faces, Predicate<class_1959> biomePredicate, IntPredicate heightPredicate, Predicate<String> blockEntityNamePredicate) {
        this.matchTilesSet = matchTilesSet;
        this.faces = faces;
        this.biomePredicate = biomePredicate;
        this.heightPredicate = heightPredicate;
        this.blockEntityNamePredicate = blockEntityNamePredicate;
    }

    @Override
    public boolean shouldProcessQuad(QuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, ProcessingDataProvider dataProvider) {
        String blockEntityName;
        class_1959 biome;
        if (this.matchTilesSet != null && !this.matchTilesSet.contains(sprite.method_4598())) {
            return false;
        }
        if (this.heightPredicate != null && !this.heightPredicate.test(pos.method_10264())) {
            return false;
        }
        if (this.faces != null) {
            class_2350 face = quad.lightFace();
            if (state.method_28498((class_2769)class_2741.field_12496)) {
                class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
                if (axis == class_2350.class_2351.field_11048) {
                    face = face.method_35833(class_2350.class_2351.field_11051);
                } else if (axis == class_2350.class_2351.field_11051) {
                    face = face.method_35834(class_2350.class_2351.field_11048);
                }
            }
            if (!this.faces.contains(face)) {
                return false;
            }
        }
        if (!(this.biomePredicate == null || (biome = dataProvider.getData(ProcessingDataKeys.BIOME_CACHE_KEY).get(blockView, pos)) != null && this.biomePredicate.test(biome))) {
            return false;
        }
        return this.blockEntityNamePredicate == null || (blockEntityName = dataProvider.getData(ProcessingDataKeys.BLOCK_ENTITY_NAME_CACHE_KEY).get(blockView, pos)) != null && this.blockEntityNamePredicate.test(blockEntityName);
    }

    public static BaseProcessingPredicate fromProperties(BaseCTMProperties properties) {
        return new BaseProcessingPredicate(properties.getMatchTilesSet(), properties.getFaces(), properties.getBiomePredicate(), properties.getHeightPredicate(), properties.getBlockEntityNamePredicate());
    }

    public static class BiomeCache {
        protected class_1959 biome;
        protected boolean invalid = true;

        @Nullable
        public class_1959 get(class_1920 blockView, class_2338 pos) {
            if (this.invalid) {
                this.biome = BiomeRetriever.getBiome(blockView, pos);
                this.invalid = false;
            }
            return this.biome;
        }

        public void reset() {
            this.invalid = true;
        }
    }

    public static class BlockEntityNameCache {
        protected String blockEntityName;
        protected boolean invalid = true;

        @Nullable
        public String get(class_1920 blockView, class_2338 pos) {
            if (this.invalid) {
                class_1275 nameable;
                class_2586 blockEntity = blockView.method_8321(pos);
                this.blockEntityName = blockEntity instanceof class_1275 ? ((nameable = (class_1275)blockEntity).method_16914() ? nameable.method_5797().method_10851() : null) : null;
                this.invalid = false;
            }
            return this.blockEntityName;
        }

        public void reset() {
            this.invalid = true;
        }
    }
}

