/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.properties.section.OverlayPropertiesSection;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SimpleOverlayQuadProcessor
extends SimpleQuadProcessor {
    protected int tintIndex;
    protected class_2680 tintBlock;
    protected RenderMaterial material;

    public SimpleOverlayQuadProcessor(SpriteProvider spriteProvider, ProcessingPredicate processingPredicate, int tintIndex, class_2680 tintBlock, BlendMode layer) {
        super(spriteProvider, processingPredicate);
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.getMaterialFinder().blendMode(0, layer).find();
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        class_1058 newSprite;
        if (this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, state, pos, context) && !TextureUtil.isMissingSprite(newSprite = this.spriteProvider.getSprite((QuadView)quad, sprite, blockView, state, pos, randomSupplier, context))) {
            OverlayRenderer renderer = context.getData(ProcessingDataKeys.SIMPLE_OVERLAY_RENDERER_POOL_KEY).getRenderer();
            renderer.prepare(quad.lightFace(), newSprite, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
            context.addEmitterConsumer(renderer);
        }
        return QuadProcessor.ProcessingResult.CONTINUE;
    }

    public static class OverlayRendererPool {
        protected final List<OverlayRenderer> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayRenderer getRenderer() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayRenderer());
            }
            OverlayRenderer renderer = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return renderer;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class OverlayRenderer
    implements Consumer<QuadEmitter> {
        protected class_2350 face;
        protected class_1058 sprite;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            QuadUtil.emitOverlayQuad(emitter, this.face, this.sprite, this.color, this.material);
        }

        public void prepare(class_2350 face, class_1058 sprite, int color, RenderMaterial material) {
            this.face = face;
            this.sprite = sprite;
            this.color = color;
            this.material = material;
        }
    }

    public static class Factory<T extends BaseCTMProperties>
    extends SimpleQuadProcessor.Factory<T> {
        public Factory(SpriteProvider.Factory<? super T> spriteProviderFactory) {
            super(spriteProviderFactory);
        }

        @Override
        public QuadProcessor createProcessor(T properties, class_1058[] sprites) {
            OverlayPropertiesSection overlaySection = ((OverlayPropertiesSection.Provider)properties).getOverlayPropertiesSection();
            return new SimpleOverlayQuadProcessor(this.spriteProviderFactory.createSpriteProvider(sprites, properties), OverlayProcessingPredicate.fromProperties(properties), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public boolean supportsNullSprites(T properties) {
            return false;
        }
    }
}

