/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import me.pepperbell.continuity.client.util.DirectionMaps;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class CTMSpriteProvider
implements SpriteProvider {
    public static final int[] SPRITE_INDEX_MAP = new int[]{0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 16, 18, 16, 18, 6, 46, 6, 21, 16, 18, 16, 18, 28, 9, 28, 22, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 37, 40, 37, 40, 30, 8, 30, 34, 37, 40, 37, 40, 25, 23, 25, 45, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 16, 42, 16, 42, 6, 20, 6, 10, 16, 42, 16, 42, 28, 35, 28, 44, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 37, 38, 37, 38, 30, 11, 30, 32, 37, 38, 37, 38, 25, 33, 25, 26};
    protected class_1058[] sprites;
    protected ConnectionPredicate connectionPredicate;
    protected boolean innerSeams;
    protected boolean useTextureOrientation;

    public CTMSpriteProvider(class_1058[] sprites, ConnectionPredicate connectionPredicate, boolean innerSeams, boolean useTextureOrientation) {
        this.sprites = sprites;
        this.connectionPredicate = connectionPredicate;
        this.innerSeams = innerSeams;
        this.useTextureOrientation = useTextureOrientation;
    }

    @Override
    public class_1058 getSprite(QuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, ProcessingDataProvider dataProvider) {
        class_2350[] directions = this.useTextureOrientation ? DirectionMaps.getDirections(quad) : DirectionMaps.getMap(quad.lightFace())[0];
        class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        int connections = CTMSpriteProvider.getConnections(this.connectionPredicate, this.innerSeams, directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        return this.sprites[SPRITE_INDEX_MAP[connections]];
    }

    public static int getConnections(ConnectionPredicate connectionPredicate, boolean innerSeams, class_2350[] directions, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        int i;
        mutablePos.method_10101((class_2382)pos);
        int connections = 0;
        for (i = 0; i < 4; ++i) {
            mutablePos.method_10098(directions[i]);
            if (connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                if (innerSeams) {
                    mutablePos.method_10098(face);
                    if (!connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                        connections |= 1 << i * 2;
                    }
                } else {
                    connections |= 1 << i * 2;
                }
            }
            mutablePos.method_10101((class_2382)pos);
        }
        for (i = 0; i < 4; ++i) {
            int index1 = i;
            int index2 = (i + 1) % 4;
            if ((connections >> index1 * 2 & 1) != 1 || (connections >> index2 * 2 & 1) != 1) continue;
            mutablePos.method_10098(directions[index1]).method_10098(directions[index2]);
            if (connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                if (innerSeams) {
                    mutablePos.method_10098(face);
                    if (!connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                        connections |= 1 << i * 2 + 1;
                    }
                } else {
                    connections |= 1 << i * 2 + 1;
                }
            }
            mutablePos.method_10101((class_2382)pos);
        }
        return connections;
    }

    public static class Factory
    implements SpriteProvider.Factory<StandardConnectingCTMProperties> {
        protected boolean useTextureOrientation;

        public Factory(boolean useTextureOrientation) {
            this.useTextureOrientation = useTextureOrientation;
        }

        @Override
        public SpriteProvider createSpriteProvider(class_1058[] sprites, StandardConnectingCTMProperties properties) {
            return new CTMSpriteProvider(sprites, properties.getConnectionPredicate(), properties.getInnerSeams(), this.useTextureOrientation);
        }

        @Override
        public int getTextureAmount(StandardConnectingCTMProperties properties) {
            return 47;
        }
    }
}

