/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.hash.Hashing;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.util.InvalidIdentifierHandler;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.PropertiesParsingHelper;
import me.pepperbell.continuity.client.util.ResourceRedirectHelper;
import me.pepperbell.continuity.client.util.TextureUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class BaseCTMProperties
implements CTMProperties {
    public static final class_2960 SPECIAL_SKIP_ID = ContinuityClient.asId("special/skip");
    public static final class_2960 SPECIAL_DEFAULT_ID = ContinuityClient.asId("special/default");
    public static final class_4730 SPECIAL_SKIP_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_SKIP_ID);
    public static final class_4730 SPECIAL_DEFAULT_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_DEFAULT_ID);
    protected Properties properties;
    protected class_2960 id;
    protected String packName;
    protected int packPriority;
    protected String method;
    protected Set<class_2960> matchTilesSet;
    protected Predicate<class_2680> matchBlocksPredicate;
    protected int weight = 0;
    protected List<class_2960> tiles;
    protected EnumSet<class_2350> faces;
    protected Predicate<class_1959> biomePredicate;
    protected IntPredicate heightPredicate;
    protected Predicate<String> blockEntityNamePredicate;
    protected boolean valid = true;
    protected Set<class_4730> textureDependencies;
    protected List<class_4730> spriteIds;

    public BaseCTMProperties(Properties properties, class_2960 id, String packName, int packPriority, String method) {
        this.properties = properties;
        this.id = id;
        this.packName = packName;
        this.packPriority = packPriority;
        this.method = method;
    }

    @Override
    public boolean affectsTextures() {
        return this.matchTilesSet != null;
    }

    @Override
    public boolean affectsTexture(class_2960 id) {
        if (this.matchTilesSet != null) {
            return this.matchTilesSet.contains(id);
        }
        return false;
    }

    @Override
    public boolean affectsBlockStates() {
        return this.matchBlocksPredicate != null;
    }

    @Override
    public boolean affectsBlockState(class_2680 state) {
        if (this.matchBlocksPredicate != null) {
            return this.matchBlocksPredicate.test(state);
        }
        return false;
    }

    public Set<class_4730> getTextureDependencies() {
        if (this.textureDependencies == null) {
            this.resolveTiles();
        }
        return this.textureDependencies;
    }

    @Override
    public int compareTo(@NotNull CTMProperties o) {
        int c;
        BaseCTMProperties o1;
        if (o instanceof BaseCTMProperties) {
            o1 = (BaseCTMProperties)o;
            c = MathUtil.signum(this.weight - o1.weight);
            if (c != 0) {
                return c;
            }
        }
        if (this.affectsTextures() && !o.affectsTextures()) {
            return 1;
        }
        if (!this.affectsTextures() && o.affectsTextures()) {
            return -1;
        }
        if (o instanceof BaseCTMProperties) {
            o1 = (BaseCTMProperties)o;
            c = MathUtil.signum(this.packPriority - o1.packPriority);
            if (c != 0) {
                return c;
            }
            return o1.getId().method_12833(this.getId());
        }
        return 0;
    }

    public void init() {
        this.parseMatchTiles();
        this.parseMatchBlocks();
        this.detectMatches();
        this.validateMatches();
        this.parseWeight();
        this.parseTiles();
        this.validateTiles();
        this.parseFaces();
        this.parseBiomes();
        this.parseHeights();
        this.parseName();
        this.parseResourceCondition();
    }

    protected void parseMatchTiles() {
        this.matchTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "matchTiles", this.id, this.packName);
    }

    protected void parseMatchBlocks() {
        this.matchBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "matchBlocks", this.id, this.packName);
    }

    protected void detectMatches() {
        String prefix;
        String baseName = FilenameUtils.getBaseName((String)this.id.method_12832());
        if (this.matchBlocksPredicate == null && baseName.startsWith(prefix = "block_")) {
            try {
                class_2960 id = new class_2960(baseName.substring(prefix.length()));
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(id);
                if (block != class_2246.field_10124) {
                    this.matchBlocksPredicate = state -> state.method_26204() == block;
                }
            }
            catch (class_151 class_1512) {
                // empty catch block
            }
        }
    }

    protected void validateMatches() {
        if (this.matchTilesSet == null && this.matchBlocksPredicate == null) {
            ContinuityClient.LOGGER.error("No tile or block matches provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseWeight() {
        String weightStr = this.properties.getProperty("weight");
        if (weightStr != null) {
            weightStr = weightStr.trim();
            try {
                this.weight = Integer.parseInt(weightStr);
            }
            catch (NumberFormatException e) {
                ContinuityClient.LOGGER.warn("Invalid 'weight' value '" + weightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            }
        }
    }

    protected void parseTiles() {
        String[] tileStrs;
        String tilesStr = this.properties.getProperty("tiles");
        if (tilesStr != null && (tileStrs = (tilesStr = tilesStr.trim()).split("[ ,]")).length != 0) {
            String basePath = FilenameUtils.getPath((String)this.id.method_12832());
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            InvalidIdentifierHandler.enableInvalidPaths();
            for (int i = 0; i < tileStrs.length; ++i) {
                Object path;
                String namespace;
                String tileStr = tileStrs[i];
                if (tileStr.isEmpty()) continue;
                if (tileStr.endsWith("<skip>") || tileStr.endsWith("<skip>.png")) {
                    listBuilder.add((Object)SPECIAL_SKIP_ID);
                    continue;
                }
                if (tileStr.endsWith("<default>") || tileStr.endsWith("<default>.png")) {
                    listBuilder.add((Object)SPECIAL_DEFAULT_ID);
                    continue;
                }
                if (tileStr.contains("-")) {
                    String[] tileStrRange = tileStr.split("-");
                    if (tileStrRange.length != 2) continue;
                    try {
                        int min = Integer.parseInt(tileStrRange[0]);
                        int max = Integer.parseInt(tileStrRange[1]);
                        if (min <= max) {
                            for (int t = min; t <= max; ++t) {
                                listBuilder.add((Object)new class_2960(this.id.method_12836(), basePath + t + ".png"));
                            }
                            continue;
                        }
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                    ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                    continue;
                }
                String[] parts = tileStr.split(":", 2);
                if (parts.length == 0) continue;
                if (parts.length > 1) {
                    namespace = parts[0];
                    path = parts[1];
                } else {
                    namespace = this.id.method_12836();
                    path = parts[0];
                }
                if (!((String)path).endsWith(".png")) {
                    path = (String)path + ".png";
                }
                if (((String)path).startsWith("./")) {
                    path = basePath + ((String)path).substring(2);
                } else if (((String)path).startsWith("~/")) {
                    path = "optifine/" + ((String)path).substring(2);
                } else if (((String)path).startsWith("/")) {
                    path = "optifine/" + ((String)path).substring(1);
                } else if (!((String)path).startsWith("textures/") && !((String)path).startsWith("optifine/")) {
                    path = basePath + (String)path;
                }
                listBuilder.add((Object)new class_2960(namespace, (String)path));
            }
            InvalidIdentifierHandler.disableInvalidPaths();
            ImmutableList list = listBuilder.build();
            if (!list.isEmpty()) {
                this.tiles = list;
            }
        }
    }

    protected void validateTiles() {
        if (this.tiles == null) {
            ContinuityClient.LOGGER.error("No tiles provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseFaces() {
        String[] faceStrs;
        String facesStr = this.properties.getProperty("faces");
        if (facesStr != null && (faceStrs = (facesStr = facesStr.trim()).split("[ ,]")).length != 0) {
            for (int i = 0; i < faceStrs.length; ++i) {
                String faceStr = faceStrs[i];
                if (faceStr.isEmpty()) continue;
                if ((faceStr = faceStr.toUpperCase(Locale.ROOT)).equals("BOTTOM")) {
                    faceStr = "DOWN";
                } else if (faceStr.equals("TOP")) {
                    faceStr = "UP";
                }
                try {
                    class_2350 direction = class_2350.valueOf((String)faceStr);
                    if (this.faces == null) {
                        this.faces = EnumSet.noneOf(class_2350.class);
                    }
                    this.faces.add(direction);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (faceStr.equals("SIDES")) {
                        if (this.faces == null) {
                            this.faces = EnumSet.noneOf(class_2350.class);
                        }
                        Iterators.addAll(this.faces, (Iterator)class_2350.class_2353.field_11062.iterator());
                        continue;
                    }
                    if (faceStr.equals("ALL")) {
                        this.faces = null;
                        return;
                    }
                    ContinuityClient.LOGGER.warn("Unknown 'faces' element '" + faceStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                }
            }
        }
    }

    protected void parseBiomes() {
        String biomesStr = this.properties.getProperty("biomes");
        if (biomesStr != null) {
            String[] biomeStrs;
            biomesStr = biomesStr.trim();
            boolean negate = false;
            if (biomesStr.charAt(0) == '!') {
                negate = true;
                biomesStr = biomesStr.substring(1);
            }
            if ((biomeStrs = biomesStr.split(" ")).length != 0) {
                ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                for (int i = 0; i < biomeStrs.length; ++i) {
                    String biomeStr = biomeStrs[i];
                    if (biomeStr.isEmpty()) continue;
                    try {
                        class_2960 biomeId = new class_2960(biomeStr.toLowerCase(Locale.ROOT));
                        setBuilder.add((Object)BiomeHolderManager.getOrCreateHolder(biomeId));
                        continue;
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid 'biomes' element '" + biomeStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'", (Throwable)e);
                    }
                }
                ImmutableSet set = setBuilder.build();
                if (!set.isEmpty()) {
                    this.biomePredicate = biome -> {
                        for (BiomeHolder holder : set) {
                            if (holder.getBiome() != biome) continue;
                            return true;
                        }
                        return false;
                    };
                    if (negate) {
                        this.biomePredicate = this.biomePredicate.negate();
                    }
                }
            }
        }
    }

    protected void parseHeights() {
        String[] heightStrs;
        String heightsStr = this.properties.getProperty("heights");
        if (heightsStr != null && (heightStrs = (heightsStr = heightsStr.trim()).split("[ ,]")).length != 0) {
            ImmutableList.Builder predicateListBuilder = ImmutableList.builder();
            for (int i = 0; i < heightStrs.length; ++i) {
                String heightStr = heightStrs[i];
                if (heightStr.isEmpty()) continue;
                String[] parts = heightStr.split("-");
                int length = parts.length;
                try {
                    if (length == 2) {
                        int max;
                        int min = Integer.parseInt(parts[0]);
                        if (min < (max = Integer.parseInt(parts[1]))) {
                            predicateListBuilder.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateListBuilder.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateListBuilder.add(y -> y == min);
                        continue;
                    }
                    if (length == 1) {
                        int height = Integer.parseInt(parts[0]);
                        predicateListBuilder.add(y -> y == height);
                        continue;
                    }
                }
                catch (NumberFormatException height) {
                    // empty catch block
                }
                ContinuityClient.LOGGER.warn("Invalid 'heights' element '" + heightStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            ImmutableList predicateList = predicateListBuilder.build();
            if (!predicateList.isEmpty()) {
                int amount = predicateList.size();
                this.heightPredicate = y -> {
                    for (int i = 0; i < amount; ++i) {
                        if (((IntPredicate)predicateList.get(i)).test(y)) continue;
                        return false;
                    }
                    return true;
                };
            }
        }
        if (this.heightPredicate == null) {
            boolean hasMaxHeight;
            String minHeightStr = this.properties.getProperty("minHeight");
            String maxHeightStr = this.properties.getProperty("maxHeight");
            boolean hasMinHeight = minHeightStr != null;
            boolean bl = hasMaxHeight = maxHeightStr != null;
            if (hasMinHeight || hasMaxHeight) {
                int min = 0;
                int max = 0;
                if (hasMinHeight) {
                    minHeightStr = minHeightStr.trim();
                    try {
                        min = Integer.parseInt(minHeightStr);
                    }
                    catch (NumberFormatException e) {
                        hasMinHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'minHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                if (hasMaxHeight) {
                    maxHeightStr = maxHeightStr.trim();
                    try {
                        max = Integer.parseInt(maxHeightStr);
                    }
                    catch (NumberFormatException e) {
                        hasMaxHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'maxHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                int finalMin = min;
                int finalMax = max;
                if (hasMinHeight && hasMaxHeight) {
                    this.heightPredicate = finalMin < finalMax ? y -> y >= finalMin && y <= finalMax : (finalMin > finalMax ? y -> y >= finalMax && y <= finalMin : y -> y == finalMin);
                } else if (hasMinHeight) {
                    this.heightPredicate = y -> y >= finalMin;
                } else if (hasMaxHeight) {
                    this.heightPredicate = y -> y <= finalMax;
                }
            }
        }
    }

    protected void parseName() {
        String nameStr = this.properties.getProperty("name");
        if (nameStr != null) {
            nameStr = nameStr.trim();
            nameStr = StringEscapeUtils.escapeJava((String)nameStr);
            boolean isPattern = false;
            boolean caseInsensitive = false;
            if (nameStr.startsWith("regex:")) {
                nameStr = nameStr.substring(6);
            } else if (nameStr.startsWith("iregex:")) {
                nameStr = nameStr.substring(7);
                caseInsensitive = true;
            } else if (nameStr.startsWith("pattern:")) {
                nameStr = nameStr.substring(8);
                isPattern = true;
            } else if (nameStr.startsWith("ipattern:")) {
                nameStr = nameStr.substring(9);
                isPattern = true;
                caseInsensitive = true;
            } else {
                this.blockEntityNamePredicate = nameStr::equals;
                return;
            }
            String patternStr = nameStr;
            if (isPattern) {
                patternStr = Pattern.quote(patternStr);
                patternStr = patternStr.replace("?", "\\E.\\Q");
                patternStr = patternStr.replace("*", "\\E.*\\Q");
            }
            Pattern pattern = Pattern.compile(patternStr, caseInsensitive ? 2 : 0);
            this.blockEntityNamePredicate = blockEntityName -> pattern.matcher((CharSequence)blockEntityName).matches();
        }
    }

    protected void parseResourceCondition() {
        String[] conditionStrs;
        String conditionsStr = this.properties.getProperty("resourceCondition");
        if (conditionsStr != null && (conditionStrs = (conditionsStr = conditionsStr.trim()).split("\\|")).length != 0) {
            Object[] packs = (class_3262[])class_310.method_1551().method_1478().method_29213().toArray(class_3262[]::new);
            ArrayUtils.reverse((Object[])packs);
            class_3268 defaultPack = class_310.method_1551().method_1516().method_4633();
            InvalidIdentifierHandler.enableInvalidPaths();
            block0: for (int i = 0; i < conditionStrs.length; ++i) {
                Predicate<class_3262> predicate;
                String[] parts;
                String conditionStr = conditionStrs[i];
                if (conditionStr.isEmpty() || (parts = conditionStr.split("@", 2)).length == 0) continue;
                class_2960 resourceId = new class_2960(parts[0]);
                String packStr = parts.length > 1 ? parts[1] : null;
                if (packStr == null || packStr.equals("default")) {
                    predicate = pack -> pack == defaultPack;
                } else if (packStr.equals("programmer_art")) {
                    predicate = pack -> pack.method_14409().equals("Programmer Art");
                } else {
                    ContinuityClient.LOGGER.warn("Invalid pack '" + packStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                    continue;
                }
                for (Object pack2 : packs) {
                    if (!pack2.method_14411(class_3264.field_14188, resourceId)) continue;
                    if (predicate.test((class_3262)pack2)) continue block0;
                    this.valid = false;
                    break block0;
                }
            }
            InvalidIdentifierHandler.disableInvalidPaths();
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void resolveTiles() {
        this.textureDependencies = new ObjectOpenHashSet();
        this.spriteIds = new ObjectArrayList();
        class_3300 resourceManager = class_310.method_1551().method_1478();
        for (class_2960 tile : this.tiles) {
            class_4730 spriteId;
            if (tile.equals((Object)SPECIAL_SKIP_ID)) {
                spriteId = SPECIAL_SKIP_SPRITE_ID;
            } else if (tile.equals((Object)SPECIAL_DEFAULT_ID)) {
                spriteId = SPECIAL_DEFAULT_SPRITE_ID;
            } else {
                String namespace = tile.method_12836();
                String path = tile.method_12832();
                if (path.startsWith("textures/")) {
                    if ((path = path.substring(9)).endsWith(".png")) {
                        path = path.substring(0, path.length() - 4);
                    }
                } else {
                    path = BaseCTMProperties.getRedirectPath(path);
                    class_2960 redirectId = new class_2960(namespace, "textures/" + path + ".png");
                    ResourceRedirectHelper.addRedirect(resourceManager, redirectId, tile);
                }
                spriteId = TextureUtil.toSpriteId(new class_2960(namespace, path));
                this.textureDependencies.add(spriteId);
            }
            this.spriteIds.add(spriteId);
        }
    }

    public static String getRedirectPath(String path) {
        return "continuity_reserved/" + Hashing.md5().hashString((CharSequence)path, StandardCharsets.UTF_8).toString().toLowerCase(Locale.ROOT);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getMethod() {
        return this.method;
    }

    public Set<class_2960> getMatchTilesSet() {
        return this.matchTilesSet;
    }

    public Predicate<class_2680> getMatchBlocksPredicate() {
        return this.matchBlocksPredicate;
    }

    public int getWeight() {
        return this.weight;
    }

    public EnumSet<class_2350> getFaces() {
        return this.faces;
    }

    public Predicate<class_1959> getBiomePredicate() {
        return this.biomePredicate;
    }

    public IntPredicate getHeightPredicate() {
        return this.heightPredicate;
    }

    public Predicate<String> getBlockEntityNamePredicate() {
        return this.blockEntityNamePredicate;
    }

    public List<class_4730> getSpriteIds() {
        if (this.spriteIds == null) {
            this.resolveTiles();
        }
        return this.spriteIds;
    }

    public static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory) {
        return (properties, id, packName, packPriority, method) -> {
            BaseCTMProperties ctmProperties = (BaseCTMProperties)factory.createProperties(properties, id, packName, packPriority, method);
            if (ctmProperties == null) {
                return null;
            }
            ctmProperties.init();
            if (ctmProperties.isValid()) {
                return ctmProperties;
            }
            return null;
        };
    }
}

