/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.shader.GlShader;
import net.coderbot.iris.gl.shader.ProgramCreator;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import org.jetbrains.annotations.Nullable;

public class ProgramBuilder
extends ProgramUniforms.Builder
implements SamplerHolder,
ImageHolder {
    private static final ShaderConstants EMPTY_CONSTANTS = ShaderConstants.builder().build();
    public static final ShaderConstants MACRO_CONSTANTS;
    private final int program;
    private final ProgramSamplers.Builder samplers;
    private final ProgramImages.Builder images;

    private ProgramBuilder(String string, int n, ImmutableSet<Integer> immutableSet) {
        super(string, n);
        this.program = n;
        this.samplers = ProgramSamplers.builder(n, immutableSet);
        this.images = ProgramImages.builder(n);
    }

    public void bindAttributeLocation(int n, String string) {
        IrisRenderSystem.bindAttributeLocation(this.program, n, string);
    }

    public static ProgramBuilder begin(String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, ImmutableSet<Integer> immutableSet) {
        RenderSystem.assertOnRenderThread();
        GlShader glShader = ProgramBuilder.buildShader(ShaderType.VERTEX, string + ".vsh", string2);
        GlShader glShader2 = string3 != null ? ProgramBuilder.buildShader(ShaderType.GEOMETRY, string + ".gsh", string3) : null;
        GlShader glShader3 = ProgramBuilder.buildShader(ShaderType.FRAGMENT, string + ".fsh", string4);
        int n = glShader2 != null ? ProgramCreator.create(string, glShader, glShader2, glShader3) : ProgramCreator.create(string, glShader, glShader3);
        glShader.destroy();
        if (glShader2 != null) {
            glShader2.destroy();
        }
        glShader3.destroy();
        return new ProgramBuilder(string, n, immutableSet);
    }

    public Program build() {
        return new Program(this.program, super.buildUniforms(), this.samplers.build(), this.images.build());
    }

    private static GlShader buildShader(ShaderType shaderType, String string, @Nullable String string2) {
        try {
            return new GlShader(shaderType, string, string2, EMPTY_CONSTANTS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Failed to compile " + shaderType + " shader for program " + string, runtimeException);
        }
    }

    @Override
    public void addExternalSampler(int n, String ... stringArray) {
        this.samplers.addExternalSampler(n, stringArray);
    }

    @Override
    public boolean hasSampler(String string) {
        return this.samplers.hasSampler(string);
    }

    @Override
    public boolean addDefaultSampler(IntSupplier intSupplier, String ... stringArray) {
        return this.samplers.addDefaultSampler(intSupplier, stringArray);
    }

    @Override
    public boolean addDynamicSampler(IntSupplier intSupplier, String ... stringArray) {
        return this.samplers.addDynamicSampler(intSupplier, stringArray);
    }

    @Override
    public boolean hasImage(String string) {
        return this.images.hasImage(string);
    }

    @Override
    public void addTextureImage(IntSupplier intSupplier, InternalTextureFormat internalTextureFormat, String string) {
        this.images.addTextureImage(intSupplier, internalTextureFormat, string);
    }

    static {
        try {
            MACRO_CONSTANTS = ShaderConstants.builder().define(StandardMacros.getOsString()).define("MC_VERSION", StandardMacros.getMcVersion()).define("MC_GL_VERSION", StandardMacros.getGlVersion(7938)).define("MC_GLSL_VERSION", StandardMacros.getGlVersion(35724)).define(StandardMacros.getRenderer()).define(StandardMacros.getVendor()).define("MC_RENDER_QUALITY", "1.0").define("MC_SHADOW_QUALITY", "1.0").define("MC_HAND_DEPTH", Float.toString(0.125f)).defineAll(StandardMacros.getIrisDefines()).defineAll(StandardMacros.getGlExtensions()).defineAll(StandardMacros.getRenderStages()).build();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize StandardMacros!", exception);
        }
    }
}

