/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import java.util.Optional;
import net.coderbot.iris.gl.GlVersion;

public enum PixelFormat {
    RED(6403, GlVersion.GL_11),
    RG(33319, GlVersion.GL_30),
    RGB(6407, GlVersion.GL_11),
    BGR(32992, GlVersion.GL_12),
    RGBA(6408, GlVersion.GL_11),
    BGRA(32993, GlVersion.GL_12),
    RED_INTEGER(36244, GlVersion.GL_30),
    RG_INTEGER(33320, GlVersion.GL_30),
    RGB_INTEGER(36248, GlVersion.GL_30),
    BGR_INTEGER(36250, GlVersion.GL_30),
    RGBA_INTEGER(36249, GlVersion.GL_30),
    BGRA_INTEGER(36251, GlVersion.GL_30);

    private final int glFormat;
    private final GlVersion minimumGlVersion;

    private PixelFormat(int n2, GlVersion glVersion) {
        this.glFormat = n2;
        this.minimumGlVersion = glVersion;
    }

    public static Optional<PixelFormat> fromString(String string) {
        try {
            return Optional.of(PixelFormat.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public int getGlFormat() {
        return this.glFormat;
    }

    public GlVersion getMinimumGlVersion() {
        return this.minimumGlVersion;
    }
}

