/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

public class AttributeShaderTransformer {
    public static StringTransformations patch(StringTransformations stringTransformations, ShaderType shaderType, boolean bl) {
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform sampler2D iris_overlay;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 entityColor;");
            if (stringTransformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            stringTransformations.replaceExact("main", "irisMain");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in ivec2 iris_UV1;\n");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\tvec4 overlayColor = texelFetch(iris_overlay, iris_UV1, 0);\n\tentityColor = vec4(overlayColor.rgb, 1.0 - overlayColor.a);\n\n    irisMain();\n}");
        } else if (shaderType == ShaderType.GEOMETRY) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            stringTransformations.replaceExact("entityColor", "entityColor[0]");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 entityColorGS;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 entityColor[];");
            if (stringTransformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            stringTransformations.replaceExact("main", "irisMain");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\t entityColorGS = entityColor[0];\n    irisMain();\n}");
        } else if (shaderType == ShaderType.FRAGMENT) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "in vec4 entityColor;");
            if (bl) {
                stringTransformations.replaceExact("entityColor", "entityColorGS");
            }
        }
        return stringTransformations;
    }
}

