/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;

public class CenterDepthSampler {
    private final SmoothedFloat centerDepthSmooth;
    private final GlFramebuffer depthBufferHolder;
    private final RenderTargets renderTargets;
    private boolean hasFirstSample;
    private boolean everRetrieved;

    public CenterDepthSampler(RenderTargets renderTargets, FrameUpdateNotifier frameUpdateNotifier) {
        this.centerDepthSmooth = new SmoothedFloat(1.0f, 1.0f, this::sampleCenterDepth, frameUpdateNotifier);
        this.depthBufferHolder = renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.renderTargets = renderTargets;
    }

    private float sampleCenterDepth() {
        if (this.hasFirstSample && !this.everRetrieved) {
            return 0.0f;
        }
        this.hasFirstSample = true;
        this.depthBufferHolder.bind();
        float[] fArray = new float[1];
        IrisRenderSystem.readPixels(this.renderTargets.getCurrentWidth() / 2, this.renderTargets.getCurrentHeight() / 2, 1, 1, 6402, 5126, fArray);
        return fArray[0];
    }

    public float getCenterDepthSmoothSample() {
        this.everRetrieved = true;
        return this.centerDepthSmooth.getAsFloat();
    }
}

