/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.minecraft.class_276;

public class RenderTargets {
    private final RenderTarget[] targets;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final DepthTexture noHand;
    private final List<GlFramebuffer> ownedFramebuffers;
    private int cachedWidth;
    private int cachedHeight;
    private boolean fullClearRequired;
    private boolean destroyed = false;

    public RenderTargets(class_276 class_2762, PackRenderTargetDirectives packRenderTargetDirectives) {
        this(class_2762.field_1482, class_2762.field_1481, packRenderTargetDirectives.getRenderTargetSettings());
    }

    public RenderTargets(int n, int n2, Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map) {
        this.targets = new RenderTarget[map.size()];
        map.forEach((n3, renderTargetSettings) -> {
            this.targets[n3.intValue()] = RenderTarget.builder().setDimensions(n, n2).setInternalFormat(renderTargetSettings.getInternalFormat()).setPixelFormat(renderTargetSettings.getInternalFormat().getPixelFormat()).build();
        });
        this.depthTexture = new DepthTexture(n, n2);
        this.noTranslucents = new DepthTexture(n, n2);
        this.noHand = new DepthTexture(n, n2);
        this.cachedWidth = n;
        this.cachedHeight = n2;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
    }

    public void destroy() {
        this.destroyed = true;
        for (GlFramebuffer glFramebuffer : this.ownedFramebuffers) {
            glFramebuffer.destroy();
        }
        for (RenderTarget renderTarget : this.targets) {
            renderTarget.destroy();
        }
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
        this.noHand.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int n) {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.targets[n];
    }

    public DepthTexture getDepthTexture() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.noTranslucents;
    }

    public DepthTexture getDepthTextureNoHand() {
        return this.noHand;
    }

    public void resizeIfNeeded(int n, int n2) {
        if (n == this.cachedWidth && n2 == this.cachedHeight) {
            return;
        }
        this.cachedWidth = n;
        this.cachedHeight = n2;
        for (RenderTarget renderTarget : this.targets) {
            renderTarget.resize(n, n2);
        }
        this.depthTexture.resize(n, n2);
        this.noTranslucents.resize(n, n2);
        this.noHand.resize(n, n2);
        this.fullClearRequired = true;
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] nArray) {
        return this.createFullFramebuffer(false, nArray);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] nArray) {
        return this.createFullFramebuffer(true, nArray);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> immutableSet, int[] nArray) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int n : nArray) {
            if (immutableSet.contains((Object)n)) continue;
            builder.add((Object)n);
        }
        return builder.build();
    }

    public GlFramebuffer createGbufferFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        ImmutableSet<Integer> immutableSet2 = this.invert(immutableSet, nArray);
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet2, nArray);
        glFramebuffer.addDepthAttachment(this.getDepthTexture().getTextureId());
        return glFramebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean bl, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        ImmutableSet<Integer> immutableSet = ImmutableSet.of();
        if (!bl) {
            immutableSet = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), nArray);
        }
        return this.createColorFramebufferWithDepth(immutableSet, nArray);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> immutableSet, int[] nArray) {
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet, nArray);
        glFramebuffer.addDepthAttachment(this.getDepthTexture().getTextureId());
        return glFramebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = i;
            if (nArray[i] >= this.getRenderTargetCount()) {
                throw new IllegalStateException("Render target with index " + nArray[i] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget renderTarget = this.get(nArray[i]);
            int n = immutableSet.contains((Object)nArray[i]) ? renderTarget.getMainTexture() : renderTarget.getAltTexture();
            glFramebuffer.addColorAttachment(i, n);
        }
        glFramebuffer.drawBuffers(nArray2);
        glFramebuffer.readBuffer(0);
        if (!glFramebuffer.isComplete()) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return glFramebuffer;
    }

    public int getCurrentWidth() {
        return this.cachedWidth;
    }

    public int getCurrentHeight() {
        return this.cachedHeight;
    }
}

