/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;

public class IrisImages {
    public static void addRenderTargetImages(ImageHolder imageHolder, Supplier<ImmutableSet<Integer>> supplier, RenderTargets renderTargets) {
        for (int i = 0; i < renderTargets.getRenderTargetCount(); ++i) {
            int n = i;
            IntSupplier intSupplier = () -> {
                ImmutableSet immutableSet = (ImmutableSet)supplier.get();
                RenderTarget renderTarget = renderTargets.get(n);
                if (immutableSet.contains((Object)n)) {
                    return renderTarget.getAltTexture();
                }
                return renderTarget.getMainTexture();
            };
            InternalTextureFormat internalTextureFormat = renderTargets.get(i).getInternalFormat();
            String string = "colorimg" + i;
            imageHolder.addTextureImage(intSupplier, internalTextureFormat, string);
        }
    }

    public static boolean hasShadowImages(ImageHolder imageHolder) {
        if (imageHolder == null) {
            return false;
        }
        return imageHolder.hasImage("shadowcolorimg0") || imageHolder.hasImage("shadowcolorimg1");
    }

    public static boolean hasRenderTargetImages(ImageHolder imageHolder, RenderTargets renderTargets) {
        for (int i = 0; i < renderTargets.getRenderTargetCount(); ++i) {
            if (imageHolder == null || !imageHolder.hasImage("colorimg" + i)) continue;
            return true;
        }
        return false;
    }

    public static void addShadowColorImages(ImageHolder imageHolder, ShadowMapRenderer shadowMapRenderer) {
        IrisImages.addShadowColorImages(imageHolder, shadowMapRenderer.getRenderTargets());
    }

    public static void addShadowColorImages(ImageHolder imageHolder, ShadowRenderTargets shadowRenderTargets) {
        if (imageHolder == null) {
            return;
        }
        for (int i = 0; i < shadowRenderTargets.getNumColorTextures(); ++i) {
            int n = i;
            IntSupplier intSupplier = () -> shadowRenderTargets.getColorTextureId(n);
            InternalTextureFormat internalTextureFormat = shadowRenderTargets.getColorTextureFormat(n);
            imageHolder.addTextureImage(intSupplier, internalTextureFormat, "shadowcolorimg" + i);
        }
    }
}

