/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.CommentDirective;
import net.coderbot.iris.shaderpack.CommentDirectiveParser;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DispatchingDirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderProperties;
import org.jetbrains.annotations.Nullable;

public class ProgramDirectives {
    private static final ImmutableList<String> LEGACY_RENDER_TARGETS = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS;
    private final int[] drawBuffers;
    private final float viewportScale;
    @Nullable
    private final AlphaTest alphaTestOverride;
    @Nullable
    private final BlendModeOverride blendModeOverride;
    private final ImmutableSet<Integer> mipmappedBuffers;
    private final ImmutableMap<Integer, Boolean> explicitFlips;

    ProgramDirectives(ProgramSource programSource, ShaderProperties shaderProperties, Set<Integer> set, @Nullable BlendModeOverride blendModeOverride) {
        Object object;
        Optional<CommentDirective> optional = ProgramDirectives.findDrawbuffersDirective(programSource.getFragmentSource());
        Optional<CommentDirective> optional2 = ProgramDirectives.findRendertargetsDirective(programSource.getFragmentSource());
        Optional<CommentDirective> optional3 = ProgramDirectives.getAppliedDirective(optional, optional2);
        this.drawBuffers = optional3.map(commentDirective -> {
            if (commentDirective.getType() == CommentDirective.Type.DRAWBUFFERS) {
                return ProgramDirectives.parseDigits(commentDirective.getDirective().toCharArray());
            }
            if (commentDirective.getType() == CommentDirective.Type.RENDERTARGETS) {
                return ProgramDirectives.parseDigitList(commentDirective.getDirective());
            }
            throw new IllegalStateException("Unhandled comment directive type!");
        }).orElse(new int[]{0});
        if (shaderProperties != null) {
            this.viewportScale = shaderProperties.getViewportScaleOverrides().getOrDefault((Object)programSource.getName(), 1.0f);
            this.alphaTestOverride = (AlphaTest)shaderProperties.getAlphaTestOverrides().get((Object)programSource.getName());
            object = (BlendModeOverride)shaderProperties.getBlendModeOverrides().get((Object)programSource.getName());
            this.blendModeOverride = object != null ? object : blendModeOverride;
            this.explicitFlips = programSource.getParent().getPackDirectives().getExplicitFlips(programSource.getName());
        } else {
            this.viewportScale = 1.0f;
            this.alphaTestOverride = null;
            this.blendModeOverride = blendModeOverride;
            this.explicitFlips = ImmutableMap.of();
        }
        object = new HashSet();
        DispatchingDirectiveHolder dispatchingDirectiveHolder = new DispatchingDirectiveHolder();
        set.forEach(n -> {
            BooleanConsumer booleanConsumer = bl -> {
                if (bl) {
                    object.add(n);
                } else {
                    object.remove(n);
                }
            };
            dispatchingDirectiveHolder.acceptConstBooleanDirective("colortex" + n + "MipmapEnabled", booleanConsumer);
            if (n < LEGACY_RENDER_TARGETS.size()) {
                dispatchingDirectiveHolder.acceptConstBooleanDirective((String)LEGACY_RENDER_TARGETS.get(n.intValue()) + "MipmapEnabled", booleanConsumer);
            }
        });
        programSource.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(list -> {
            for (ConstDirectiveParser.ConstDirective constDirective : list) {
                dispatchingDirectiveHolder.processDirective(constDirective);
            }
        });
        this.mipmappedBuffers = ImmutableSet.copyOf((Collection)object);
    }

    private static Optional<CommentDirective> findDrawbuffersDirective(Optional<String> optional) {
        return optional.flatMap(string -> CommentDirectiveParser.findDirective(string, CommentDirective.Type.DRAWBUFFERS));
    }

    private static Optional<CommentDirective> findRendertargetsDirective(Optional<String> optional) {
        return optional.flatMap(string -> CommentDirectiveParser.findDirective(string, CommentDirective.Type.RENDERTARGETS));
    }

    private static int[] parseDigits(char[] cArray) {
        int[] nArray = new int[cArray.length];
        int n = 0;
        for (char c : cArray) {
            nArray[n++] = Character.digit(c, 10);
        }
        return nArray;
    }

    private static int[] parseDigitList(String string) {
        return Arrays.stream(string.split(",")).mapToInt(Integer::parseInt).toArray();
    }

    private static Optional<CommentDirective> getAppliedDirective(Optional<CommentDirective> optional, Optional<CommentDirective> optional2) {
        if (optional.isPresent() && optional2.isPresent()) {
            if (optional.get().getLocation() > optional2.get().getLocation()) {
                return optional;
            }
            return optional2;
        }
        if (optional.isPresent()) {
            return optional;
        }
        if (optional2.isPresent()) {
            return optional2;
        }
        return Optional.empty();
    }

    public int[] getDrawBuffers() {
        return this.drawBuffers;
    }

    public float getViewportScale() {
        return this.viewportScale;
    }

    public Optional<AlphaTest> getAlphaTestOverride() {
        return Optional.ofNullable(this.alphaTestOverride);
    }

    @Nullable
    public BlendModeOverride getBlendModeOverride() {
        return this.blendModeOverride;
    }

    public ImmutableSet<Integer> getMipmappedBuffers() {
        return this.mipmappedBuffers;
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips() {
        return this.explicitFlips;
    }
}

