/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class ShaderProperties {
    private boolean enableClouds = true;
    private OptionalBoolean oldHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean dynamicHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean oldLighting = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTerrain = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean underwaterOverlay = OptionalBoolean.DEFAULT;
    private OptionalBoolean sun = OptionalBoolean.DEFAULT;
    private OptionalBoolean moon = OptionalBoolean.DEFAULT;
    private OptionalBoolean vignette = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceSolid = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutout = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutoutMipped = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean rainDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean beaconBeamDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateAo = OptionalBoolean.DEFAULT;
    private OptionalBoolean frustumCulling = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowCulling = OptionalBoolean.DEFAULT;
    private OptionalBoolean particlesBeforeDeferred = OptionalBoolean.DEFAULT;
    private List<String> sliderOptions = new ArrayList<String>();
    private final Map<String, List<String>> profiles = new LinkedHashMap<String, List<String>>();
    private List<String> mainScreenOptions = new ArrayList<String>();
    private final Map<String, List<String>> subScreenOptions = new HashMap<String, List<String>>();
    private Integer mainScreenColumnCount = null;
    private final Map<String, Integer> subScreenColumnCount = new HashMap<String, Integer>();
    private final Object2ObjectMap<String, AlphaTest> alphaTestOverrides = new Object2ObjectOpenHashMap();
    private final Object2FloatMap<String> viewportScaleOverrides = new Object2FloatOpenHashMap();
    private final Object2ObjectMap<String, BlendModeOverride> blendModeOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<TextureStage, Object2ObjectMap<String, String>> customTextures = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private String noiseTexturePath = null;

    private ShaderProperties() {
    }

    public ShaderProperties(String string, ShaderPackOptions shaderPackOptions) {
        String string2 = PropertiesPreprocessor.preprocessSource(string, shaderPackOptions);
        OrderBackedProperties orderBackedProperties = new OrderBackedProperties();
        OrderBackedProperties orderBackedProperties2 = new OrderBackedProperties();
        try {
            orderBackedProperties.load(new StringReader(string2));
            orderBackedProperties2.load(new StringReader(string));
        }
        catch (IOException iOException) {
            Iris.logger.error("Error loading shaders.properties!", iOException);
        }
        ((Properties)orderBackedProperties).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            String string = (String)object;
            String string5 = (String)object2;
            if ("texture.noise".equals(string)) {
                this.noiseTexturePath = string5;
                return;
            }
            if ("clouds".equals(string) && string5.equals("off")) {
                this.enableClouds = false;
            }
            ShaderProperties.handleBooleanDirective(string, string5, "oldHandLight", optionalBoolean -> {
                this.oldHandLight = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "dynamicHandLight", optionalBoolean -> {
                this.dynamicHandLight = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "oldLighting", optionalBoolean -> {
                this.oldLighting = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowTerrain", optionalBoolean -> {
                this.shadowTerrain = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowTranslucent", optionalBoolean -> {
                this.shadowTranslucent = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowEntities", optionalBoolean -> {
                this.shadowEntities = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowBlockEntities", optionalBoolean -> {
                this.shadowBlockEntities = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "underwaterOverlay", optionalBoolean -> {
                this.underwaterOverlay = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "sun", optionalBoolean -> {
                this.sun = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "moon", optionalBoolean -> {
                this.moon = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "vignette", optionalBoolean -> {
                this.vignette = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.solid", optionalBoolean -> {
                this.backFaceSolid = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.cutout", optionalBoolean -> {
                this.backFaceCutout = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.cutoutMipped", optionalBoolean -> {
                this.backFaceCutoutMipped = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.translucent", optionalBoolean -> {
                this.backFaceTranslucent = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "rain.depth", optionalBoolean -> {
                this.rainDepth = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "beacon.beam.depth", optionalBoolean -> {
                this.beaconBeamDepth = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "separateAo", optionalBoolean -> {
                this.separateAo = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "frustum.culling", optionalBoolean -> {
                this.frustumCulling = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadow.culling", optionalBoolean -> {
                this.shadowCulling = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "particles.before.deferred", optionalBoolean -> {
                this.particlesBeforeDeferred = optionalBoolean;
            });
            ShaderProperties.handlePassDirective("scale.", string, string5, string2 -> {
                float f;
                try {
                    f = Float.parseFloat(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    Iris.logger.error("Unable to parse scale directive for " + string2 + ": " + string5, numberFormatException);
                    return;
                }
                this.viewportScaleOverrides.put(string2, f);
            });
            ShaderProperties.handlePassDirective("alphaTest.", string, string5, string2 -> {
                float f;
                if ("off".equals(string5)) {
                    this.alphaTestOverrides.put(string2, (Object)AlphaTest.ALWAYS);
                    return;
                }
                String[] stringArray = string5.split(" ");
                if (stringArray.length > 2) {
                    Iris.logger.warn("Weird alpha test directive for " + string2 + " contains more parts than we expected: " + string5);
                } else if (stringArray.length < 2) {
                    Iris.logger.error("Invalid alpha test directive for " + string2 + ": " + string5);
                    return;
                }
                Optional<AlphaTestFunction> optional = AlphaTestFunction.fromString(stringArray[0]);
                if (!optional.isPresent()) {
                    Iris.logger.error("Unable to parse alpha test directive for " + string2 + ", unknown alpha test function " + stringArray[0] + ": " + string5);
                    return;
                }
                try {
                    f = Float.parseFloat(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    Iris.logger.error("Unable to parse alpha test directive for " + string2 + ": " + string5, numberFormatException);
                    return;
                }
                this.alphaTestOverrides.put(string2, (Object)new AlphaTest(optional.get(), f));
            });
            ShaderProperties.handlePassDirective("blend.", string, string5, string3 -> {
                if (string3.contains(".")) {
                    Iris.logger.warn("Per-buffer pass blending directives are not supported, ignoring blend directive for " + string);
                    return;
                }
                if ("off".equals(string5)) {
                    this.blendModeOverrides.put(string3, (Object)BlendModeOverride.OFF);
                    return;
                }
                String[] stringArray = string5.split(" ");
                int[] nArray = new int[4];
                int n = 0;
                for (String string4 : stringArray) {
                    nArray[n] = BlendModeFunction.fromString(string4).get().getGlId();
                    ++n;
                }
                this.blendModeOverrides.put(string3, (Object)new BlendModeOverride(new BlendMode(nArray[0], nArray[1], nArray[2], nArray[3])));
            });
            ShaderProperties.handleTwoArgDirective("texture.", string, string5, (string3, string4) -> {
                String[] stringArray = string5.split(" ");
                if (stringArray.length > 1) {
                    Iris.logger.warn("Custom texture directive for stage " + string3 + ", sampler " + string4 + " contains more parts than we expected: " + string5);
                    return;
                }
                Optional<TextureStage> optional = TextureStage.parse(string3);
                if (!optional.isPresent()) {
                    Iris.logger.warn("Unknown texture stage \"" + string3 + "\", ignoring custom texture directive for " + string);
                    return;
                }
                TextureStage textureStage = optional.get();
                Object2ObjectMap object2ObjectMap = (Object2ObjectMap)this.customTextures.getOrDefault((Object)textureStage, (Object)new Object2ObjectOpenHashMap());
                object2ObjectMap.put(string4, (Object)string5);
                this.customTextures.put((Object)textureStage, (Object)object2ObjectMap);
            });
            ShaderProperties.handleTwoArgDirective("flip.", string, string5, (string3, string4) -> ShaderProperties.handleBooleanValue(string, string5, bl -> ((Object2BooleanMap)this.explicitFlips.computeIfAbsent(string3, object -> new Object2BooleanOpenHashMap())).put(string4, bl)));
        }));
        ((Properties)orderBackedProperties2).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            String string = (String)object;
            String string2 = (String)object2;
            ShaderProperties.handleWhitespacedListDirective(string, string2, "sliders", list -> {
                this.sliderOptions = list;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("profile.", string, string2, this.profiles::put);
            ShaderProperties.handleWhitespacedListDirective(string, string2, "screen", list -> {
                this.mainScreenOptions = list;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("screen.", string, string2, this.subScreenOptions::put);
            ShaderProperties.handleIntDirective(string, string2, "screen.columns", n -> {
                this.mainScreenColumnCount = n;
            });
            ShaderProperties.handleAffixedIntDirective("screen.", ".columns", string, string2, this.subScreenColumnCount::put);
        }));
    }

    private static void handleBooleanValue(String string, String string2, BooleanConsumer booleanConsumer) {
        if ("true".equals(string2)) {
            booleanConsumer.accept(true);
        } else if ("false".equals(string2)) {
            booleanConsumer.accept(false);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + string + " in shaders.properties: got " + string2 + ", but expected either true or false");
        }
    }

    private static void handleBooleanDirective(String string, String string2, String string3, Consumer<OptionalBoolean> consumer) {
        if (!string3.equals(string)) {
            return;
        }
        if ("true".equals(string2)) {
            consumer.accept(OptionalBoolean.TRUE);
        } else if ("false".equals(string2)) {
            consumer.accept(OptionalBoolean.FALSE);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + string + " in shaders.properties: got " + string2 + ", but expected either true or false");
        }
    }

    private static void handleIntDirective(String string, String string2, String string3, Consumer<Integer> consumer) {
        if (!string3.equals(string)) {
            return;
        }
        try {
            int n = Integer.parseInt(string2);
            consumer.accept(n);
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.warn("Unexpected value for integer key " + string + " in shaders.properties: got " + string2 + ", but expected an integer");
        }
    }

    private static void handleAffixedIntDirective(String string, String string2, String string3, String string4, BiConsumer<String, Integer> biConsumer) {
        if (string3.startsWith(string) && string3.endsWith(string2)) {
            int n = string.length();
            int n2 = string3.length() - string2.length();
            if (n2 <= n) {
                return;
            }
            String string5 = string3.substring(n, n2);
            try {
                int n3 = Integer.parseInt(string4);
                biConsumer.accept(string5, n3);
            }
            catch (NumberFormatException numberFormatException) {
                Iris.logger.warn("Unexpected value for integer key " + string3 + " in shaders.properties: got " + string4 + ", but expected an integer");
            }
        }
    }

    private static void handlePassDirective(String string, String string2, String string3, Consumer<String> consumer) {
        if (string2.startsWith(string)) {
            String string4 = string2.substring(string.length());
            consumer.accept(string4);
        }
    }

    private static void handleWhitespacedListDirective(String string, String string2, String string3, Consumer<List<String>> consumer) {
        if (!string3.equals(string)) {
            return;
        }
        String[] stringArray = string2.split(" +");
        consumer.accept(Arrays.asList(stringArray));
    }

    private static void handlePrefixedWhitespacedListDirective(String string, String string2, String string3, BiConsumer<String, List<String>> biConsumer) {
        if (string2.startsWith(string)) {
            String string4 = string2.substring(string.length());
            String[] stringArray = string3.split(" +");
            biConsumer.accept(string4, Arrays.asList(stringArray));
        }
    }

    private static void handleTwoArgDirective(String string, String string2, String string3, BiConsumer<String, String> biConsumer) {
        if (string2.startsWith(string)) {
            int n = string2.indexOf(".", string.length());
            String string4 = string2.substring(string.length(), n);
            String string5 = string2.substring(n + 1);
            biConsumer.accept(string4, string5);
        }
    }

    public static ShaderProperties empty() {
        return new ShaderProperties();
    }

    public boolean areCloudsEnabled() {
        return this.enableClouds;
    }

    public OptionalBoolean getOldHandLight() {
        return this.oldHandLight;
    }

    public OptionalBoolean getDynamicHandLight() {
        return this.dynamicHandLight;
    }

    public OptionalBoolean getOldLighting() {
        return this.oldLighting;
    }

    public OptionalBoolean getShadowTerrain() {
        return this.shadowTerrain;
    }

    public OptionalBoolean getShadowTranslucent() {
        return this.shadowTranslucent;
    }

    public OptionalBoolean getShadowEntities() {
        return this.shadowEntities;
    }

    public OptionalBoolean getShadowBlockEntities() {
        return this.shadowBlockEntities;
    }

    public OptionalBoolean getUnderwaterOverlay() {
        return this.underwaterOverlay;
    }

    public OptionalBoolean getSun() {
        return this.sun;
    }

    public OptionalBoolean getMoon() {
        return this.moon;
    }

    public OptionalBoolean getVignette() {
        return this.vignette;
    }

    public OptionalBoolean getBackFaceSolid() {
        return this.backFaceSolid;
    }

    public OptionalBoolean getBackFaceCutout() {
        return this.backFaceCutout;
    }

    public OptionalBoolean getBackFaceCutoutMipped() {
        return this.backFaceCutoutMipped;
    }

    public OptionalBoolean getBackFaceTranslucent() {
        return this.backFaceTranslucent;
    }

    public OptionalBoolean getRainDepth() {
        return this.rainDepth;
    }

    public OptionalBoolean getBeaconBeamDepth() {
        return this.beaconBeamDepth;
    }

    public OptionalBoolean getSeparateAo() {
        return this.separateAo;
    }

    public OptionalBoolean getFrustumCulling() {
        return this.frustumCulling;
    }

    public OptionalBoolean getShadowCulling() {
        return this.shadowCulling;
    }

    public Object2ObjectMap<String, AlphaTest> getAlphaTestOverrides() {
        return this.alphaTestOverrides;
    }

    public OptionalBoolean getParticlesBeforeDeferred() {
        return this.particlesBeforeDeferred;
    }

    public Object2FloatMap<String> getViewportScaleOverrides() {
        return this.viewportScaleOverrides;
    }

    public Object2ObjectMap<String, BlendModeOverride> getBlendModeOverrides() {
        return this.blendModeOverrides;
    }

    public Object2ObjectMap<TextureStage, Object2ObjectMap<String, String>> getCustomTextures() {
        return this.customTextures;
    }

    public Optional<String> getNoiseTexturePath() {
        return Optional.ofNullable(this.noiseTexturePath);
    }

    public List<String> getSliderOptions() {
        return this.sliderOptions;
    }

    public Map<String, List<String>> getProfiles() {
        return this.profiles;
    }

    public List<String> getMainScreenOptions() {
        return this.mainScreenOptions;
    }

    public Map<String, List<String>> getSubScreenOptions() {
        return this.subScreenOptions;
    }

    public Optional<Integer> getMainScreenColumnCount() {
        return Optional.ofNullable(this.mainScreenColumnCount);
    }

    public Map<String, Integer> getSubScreenColumnCount() {
        return this.subScreenColumnCount;
    }

    public Object2ObjectMap<String, Object2BooleanMap<String>> getExplicitFlips() {
        return this.explicitFlips;
    }
}

