/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import net.coderbot.iris.shaderpack.preprocessor.GlslCollectingListener;
import org.anarres.cpp.Feature;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

public class JcppProcessor {
    public static String glslPreprocessSource(String object) {
        if (((String)object).contains("#warning IRIS_JCPP_GLSL_VERSION") || ((String)object).contains("#warning IRIS_JCPP_GLSL_EXTENSION")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        object = ((String)object).replace("#version", "#warning IRIS_JCPP_GLSL_VERSION");
        object = ((String)object).replace("#extension", "#warning IRIS_JCPP_GLSL_EXTENSION");
        GlslCollectingListener glslCollectingListener = new GlslCollectingListener();
        Preprocessor preprocessor = new Preprocessor();
        preprocessor.setListener((PreprocessorListener)glslCollectingListener);
        preprocessor.addInput((Source)new StringLexerSource((String)object, true));
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token;
            while ((token = preprocessor.token()) != null && token.getType() != 265) {
                stringBuilder.append(token.getText());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("GLSL source pre-processing failed", exception);
        }
        stringBuilder.append("\n");
        object = glslCollectingListener.collectLines() + stringBuilder;
        return object;
    }
}

