/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.mixin.DimensionTypeAccessor;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.vendored.joml.Math;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class HardcodedCustomUniforms {
    private static final class_310 client = class_310.method_1551();

    public static void addHardcodedCustomUniforms(UniformHolder uniformHolder, FrameUpdateNotifier frameUpdateNotifier) {
        CameraUniforms.CameraPositionTracker cameraPositionTracker = new CameraUniforms.CameraPositionTracker(frameUpdateNotifier);
        SmoothedFloat smoothedFloat = new SmoothedFloat(6.0f, 12.0f, HardcodedCustomUniforms::getEyeInCave, frameUpdateNotifier);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeAngle", HardcodedCustomUniforms::getTimeAngle);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeBrightness", HardcodedCustomUniforms::getTimeBrightness);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "moonBrightness", HardcodedCustomUniforms::getMoonBrightness);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowFade", HardcodedCustomUniforms::getShadowFade);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainStrengthS", HardcodedCustomUniforms.rainStrengthS(frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "blindFactor", HardcodedCustomUniforms::getBlindFactor);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isDry", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 0.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isRainy", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 1.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isSnowy", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 2.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isEyeInCave", CommonUniforms.isEyeInWater() == 0 ? smoothedFloat : () -> 0.0f);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "velocity", () -> HardcodedCustomUniforms.getVelocity(cameraPositionTracker));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "starter", HardcodedCustomUniforms.getStarter(cameraPositionTracker, frameUpdateNotifier));
    }

    private static float getEyeInCave() {
        if (client.method_1560().method_23320() < 5.0) {
            return 1.0f - HardcodedCustomUniforms.getEyeSkyBrightness() / 240.0f;
        }
        return 0.0f;
    }

    private static float getEyeSkyBrightness() {
        if (HardcodedCustomUniforms.client.field_1719 == null || HardcodedCustomUniforms.client.field_1687 == null) {
            return 0.0f;
        }
        class_243 class_2432 = HardcodedCustomUniforms.client.field_1719.method_19538();
        class_243 class_2433 = new class_243(class_2432.field_1352, HardcodedCustomUniforms.client.field_1719.method_23320(), class_2432.field_1350);
        class_2338 class_23382 = new class_2338(class_2433);
        int n = HardcodedCustomUniforms.client.field_1687.method_8314(class_1944.field_9284, class_23382);
        return n * 16;
    }

    private static float getVelocity(CameraUniforms.CameraPositionTracker cameraPositionTracker) {
        float f = (float)(cameraPositionTracker.getCurrentCameraPosition().x - cameraPositionTracker.getPreviousCameraPosition().x);
        float f2 = (float)(cameraPositionTracker.getCurrentCameraPosition().y - cameraPositionTracker.getPreviousCameraPosition().y);
        float f3 = (float)(cameraPositionTracker.getCurrentCameraPosition().z - cameraPositionTracker.getPreviousCameraPosition().z);
        return Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private static SmoothedFloat getStarter(CameraUniforms.CameraPositionTracker cameraPositionTracker, FrameUpdateNotifier frameUpdateNotifier) {
        return new SmoothedFloat(20.0f, 20.0f, new SmoothedFloat(0.0f, 3.1536E7f, () -> HardcodedCustomUniforms.getMoving(cameraPositionTracker), frameUpdateNotifier), frameUpdateNotifier);
    }

    private static float getMoving(CameraUniforms.CameraPositionTracker cameraPositionTracker) {
        float f = (float)(cameraPositionTracker.getCurrentCameraPosition().x - cameraPositionTracker.getPreviousCameraPosition().x);
        float f2 = (float)(cameraPositionTracker.getCurrentCameraPosition().y - cameraPositionTracker.getPreviousCameraPosition().y);
        float f3 = (float)(cameraPositionTracker.getCurrentCameraPosition().z - cameraPositionTracker.getPreviousCameraPosition().z);
        float f4 = Math.abs(f) + Math.abs(f2) + Math.abs(f3);
        return f4 > 0.0f && f4 < 1.0f ? 1.0f : 0.0f;
    }

    private static float getTimeAngle() {
        return (float)HardcodedCustomUniforms.getWorldDayTime() / 24000.0f;
    }

    private static int getWorldDayTime() {
        class_638 class_6382 = class_310.method_1551().field_1687;
        long l = class_6382.method_8532();
        long l2 = ((DimensionTypeAccessor)class_6382.method_8597()).getFixedTime().orElse(l % 24000L);
        return (int)l2;
    }

    private static float getTimeBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * 2.0), 0.0);
    }

    private static float getMoonBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * -2.0), 0.0);
    }

    private static float getShadowFade() {
        return (float)Math.clamp(0.0, 1.0, 1.0 - (java.lang.Math.abs(java.lang.Math.abs((double)CelestialUniforms.getSunAngle() - 0.5) - 0.25) - 0.23) * 100.0);
    }

    private static SmoothedFloat rainStrengthS(FrameUpdateNotifier frameUpdateNotifier) {
        return new SmoothedFloat(15.0f, 15.0f, CommonUniforms::getRainStrength, frameUpdateNotifier);
    }

    private static float getRawPrecipitation() {
        if (class_310.method_1551().field_1687 == null) {
            return 0.0f;
        }
        class_1959.class_1963 class_19632 = ((class_1959)class_310.method_1551().field_1687.method_23753(class_310.method_1551().method_1560().method_24515()).comp_349()).method_8694();
        switch (class_19632) {
            case field_9382: {
                return 1.0f;
            }
            case field_9383: {
                return 2.0f;
            }
        }
        return 0.0f;
    }

    private static float getBlindFactor() {
        float f = (float)Math.clamp(0.0, 1.0, (double)CommonUniforms.getBlindness() * 2.0 - 1.0);
        return f * f;
    }

    private static float frac(float f) {
        return java.lang.Math.abs(f % 1.0f);
    }
}

