/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinServerWorld;
import fi.dy.masa.minihud.mixin.IMixinWorldRenderer;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.IServerEntityManager;
import fi.dy.masa.minihud.util.MiscUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.minecraft.class_1132;
import net.minecraft.class_1159;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_4587;
import net.minecraft.class_640;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final class_310 mc;
    private final DataStorage data;
    private final Date date;
    private final Map<class_1923, CompletableFuture<class_2818>> chunkFutures = new HashMap<class_1923, CompletableFuture<class_2818>>();
    private int fps;
    private int fpsCounter;
    private long fpsUpdateTime = System.currentTimeMillis();
    private long infoUpdateTime;
    private Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    @Nullable
    private class_2818 cachedClientChunk;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();

    public RenderHandler() {
        this.mc = class_310.method_1551();
        this.data = DataStorage.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public static void fixDebugRendererState() {
        if (Configs.Generic.FIX_VANILLA_DEBUG_RENDERERS.getBooleanValue()) {
            // empty if block
        }
    }

    public void onRenderGameOverlayPost(class_4587 matrixStack) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            this.resetCachedChunks();
            return;
        }
        if (!(this.mc.field_1690.field_1866 || this.mc.field_1724 == null || this.mc.field_1690.field_1842 || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !this.mc.field_1724.method_5715() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime;
            if (InfoToggle.FPS.getBooleanValue()) {
                this.updateFps();
            }
            if ((currentTime = System.currentTimeMillis()) - this.infoUpdateTime >= 50L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.lines, (class_4587)matrixStack);
        }
    }

    public void onRenderTooltipLast(class_1799 stack, int x, int y) {
        if (stack.method_7909() instanceof class_1806) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue()) {
                RenderUtils.renderMapPreview((class_1799)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue());
            }
        } else if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue()) {
            boolean render;
            boolean bl = render = !Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown();
            if (render) {
                RenderUtils.renderShulkerBoxPreview((class_1799)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
        }
    }

    public void onRenderWorldLast(class_4587 matrixStack, class_1159 projMatrix) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.field_1687 != null && this.mc.field_1724 != null && !this.mc.field_1690.field_1842) {
            OverlayRenderer.renderOverlays(matrixStack, projMatrix, this.mc);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    private void updateFps() {
        ++this.fpsCounter;
        long time = System.currentTimeMillis();
        if (time >= this.fpsUpdateTime + 1000L) {
            this.fpsUpdateTime = time;
            this.fps = this.fpsCounter;
            this.fpsCounter = 0;
        }
    }

    public void updateData(class_310 mc) {
        if (mc.field_1687 != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        if (this.chunkFutures.size() >= 4) {
            this.resetCachedChunks();
        }
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void addLine(String text) {
        this.lineWrappers.add(new StringHolder(text));
    }

    private void addLine(InfoToggle type) {
        class_310 mc = this.mc;
        class_1297 entity = mc.method_1560();
        class_1937 world = entity.method_5770();
        double y = entity.method_23318();
        class_2338 pos = new class_2338(entity.method_23317(), y, entity.method_23321());
        class_1923 chunkPos = new class_1923(pos);
        boolean isChunkLoaded = mc.field_1687.method_22340(pos);
        if (!isChunkLoaded) {
            return;
        }
        if (type == InfoToggle.FPS) {
            this.addLine(String.format("%d fps", this.fps));
        } else if (type == InfoToggle.MEMORY_USAGE) {
            long memMax = Runtime.getRuntime().maxMemory();
            long memTotal = Runtime.getRuntime().totalMemory();
            long memFree = Runtime.getRuntime().freeMemory();
            long memUsed = memTotal - memFree;
            this.addLine(String.format("Mem: % 2d%% %03d/%03dMB | Allocated: % 2d%% %03dMB", memUsed * 100L / memMax, MiscUtils.bytesToMb(memUsed), MiscUtils.bytesToMb(memMax), memTotal * 100L / memMax, MiscUtils.bytesToMb(memTotal)));
        } else if (type == InfoToggle.TIME_REAL) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.DATE_FORMAT_REAL.getStringValue());
                this.date.setTime(System.currentTimeMillis());
                this.addLine(sdf.format(this.date));
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_WORLD) {
            long current = world.method_8532();
            long total = world.method_8510();
            this.addLine(String.format("World time: %5d - total: %d", current, total));
        } else if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            try {
                long timeDay = world.method_8532();
                long day = (int)(timeDay / 24000L);
                int dayTicks = (int)(timeDay % 24000L);
                int hour = (dayTicks / 1000 + 6) % 24;
                int min = (int)((double)dayTicks / 16.666666) % 60;
                int sec = (int)((double)dayTicks / 0.277777) % 60;
                String str = Configs.Generic.DATE_FORMAT_MINECRAFT.getStringValue();
                str = str.replace("{DAY}", String.format("%d", day));
                str = str.replace("{DAY_1}", String.format("%d", day + 1L));
                str = str.replace("{HOUR}", String.format("%02d", hour));
                str = str.replace("{MIN}", String.format("%02d", min));
                str = str.replace("{SEC}", String.format("%02d", sec));
                this.addLine(str);
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_DAY_MODULO) {
            int mod = Configs.Generic.TIME_DAY_DIVISOR.getIntegerValue();
            long current = world.method_8532() % (long)mod;
            this.addLine(String.format("Day time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.TIME_TOTAL_MODULO) {
            int mod = Configs.Generic.TIME_TOTAL_DIVISOR.getIntegerValue();
            long current = world.method_8510() % (long)mod;
            this.addLine(String.format("Total time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.SERVER_TPS) {
            if (mc.method_1496() && mc.method_1576().method_3780() % 10 == 0) {
                this.data.updateIntegratedServerTPS();
            }
            if (this.data.hasTPSData()) {
                String preTps;
                double tps = this.data.getServerTPS();
                double mspt = this.data.getServerMSPT();
                String rst = GuiBase.TXT_RST;
                String string = preTps = tps >= 20.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                if (this.data.isCarpetServer() || mc.method_1542()) {
                    String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
                    this.addLine(String.format("Server TPS: %s%.1f%s MSPT: %s%.1f%s", preTps, tps, rst, preMspt, mspt, rst));
                } else {
                    String preMspt = mspt <= 51.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    this.addLine(String.format("Server TPS: %s%.1f%s (MSPT [est]: %s%.1f%s)", preTps, tps, rst, preMspt, mspt, rst));
                }
            } else {
                this.addLine("Server TPS: <no valid data>");
            }
        } else if (type == InfoToggle.PING) {
            class_640 info = mc.field_1724.field_3944.method_2871(mc.field_1724.method_5667());
            if (info != null) {
                this.addLine("Ping: " + info.method_2959() + " ms");
            }
        } else if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES) || this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED) || this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
            double x = entity.method_23317();
            double z = entity.method_23321();
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append("broken coordinate format string!");
                    }
                } else {
                    str.append(String.format("XYZ: %.2f / %.4f / %.2f", x, y, z));
                }
                pre = " / ";
            }
            if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.method_27983() == class_1937.field_25180 || world.method_27983() == class_1937.field_25179)) {
                boolean isNether = world.method_27983() == class_1937.field_25180;
                double scale = isNether ? 8.0 : 0.125;
                x *= scale;
                z *= scale;
                str.append(pre);
                if (isNether) {
                    str.append("Overworld: ");
                } else {
                    str.append("Nether: ");
                }
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append("broken coordinate format string!");
                    }
                } else {
                    str.append(String.format("XYZ: %.2f / %.4f / %.2f", x, y, z));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                String dimName = world.method_27983().method_29177().toString();
                str.append(pre).append("dim: ").append(dimName);
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
            this.addedTypes.add(InfoToggle.DIMENSION);
        } else if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS) || this.addedTypes.contains((Object)InfoToggle.CHUNK_POS) || this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                str.append(String.format("Block: %d, %d, %d", pos.method_10263(), pos.method_10264(), pos.method_10260()));
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(String.format("Sub-Chunk: %d, %d, %d", chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(String.format("Region: r.%d.%d", pos.method_10263() >> 9, pos.method_10260() >> 9));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.BLOCK_POS);
            this.addedTypes.add(InfoToggle.CHUNK_POS);
            this.addedTypes.add(InfoToggle.REGION_FILE);
        } else if (type == InfoToggle.BLOCK_IN_CHUNK) {
            this.addLine(String.format("Block: %d, %d, %d within Sub-Chunk: %d, %d, %d", pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180));
        } else if (type == InfoToggle.BLOCK_BREAK_SPEED) {
            this.addLine(String.format("BBS: %.2f", DataStorage.getInstance().getBlockBreakingSpeed()));
        } else if (type == InfoToggle.SPRINTING && mc.field_1724.method_5624()) {
            this.addLine("\u00a76Sprinting");
        } else if (type == InfoToggle.DISTANCE) {
            class_243 ref = DataStorage.getInstance().getDistanceReferencePoint();
            double dist = Math.sqrt(ref.method_1028(entity.method_23317(), entity.method_23318(), entity.method_23321()));
            this.addLine(String.format("Distance: %.2f (x: %.2f y: %.2f z: %.2f) [to x: %.2f y: %.2f z: %.2f]", dist, entity.method_23317() - ref.field_1352, entity.method_23318() - ref.field_1351, entity.method_23321() - ref.field_1350, ref.field_1352, ref.field_1351, ref.field_1350));
        } else if (type == InfoToggle.FACING) {
            class_2350 facing = entity.method_5735();
            String str = "Invalid";
            switch (facing) {
                case field_11043: {
                    str = "Negative Z";
                    break;
                }
                case field_11035: {
                    str = "Positive Z";
                    break;
                }
                case field_11039: {
                    str = "Negative X";
                    break;
                }
                case field_11034: {
                    str = "Positive X";
                    break;
                }
            }
            this.addLine(String.format("Facing: %s (%s)", facing, str));
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            class_2818 clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.method_12223()) {
                class_3568 lightingProvider = world.method_8398().method_12130();
                this.addLine(String.format("Client Light: %d (block: %d, sky: %d)", lightingProvider.method_22363(pos, 0), lightingProvider.method_15562(class_1944.field_9282).method_15543(pos), lightingProvider.method_15562(class_1944.field_9284).method_15543(pos)));
                class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                class_2818 serverChunk = this.getChunk(chunkPos);
                if (serverChunk != null && serverChunk != clientChunk) {
                    lightingProvider = bestWorld.method_8398().method_12130();
                    int total = lightingProvider.method_22363(pos, 0);
                    int block = lightingProvider.method_15562(class_1944.field_9282).method_15543(pos);
                    int sky = lightingProvider.method_15562(class_1944.field_9284).method_15543(pos);
                    this.addLine(String.format("Server Light: %d (block: %d, sky: %d)", total, block, sky));
                }
            }
        } else if (type == InfoToggle.BEE_COUNT) {
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            class_2586 be = this.getTargetedBlockEntity(bestWorld, mc);
            if (be instanceof class_4482) {
                this.addLine("Bees: " + GuiBase.TXT_AQUA + ((class_4482)be).method_23903());
            }
        } else if (type == InfoToggle.FURNACE_XP) {
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            class_2586 be = this.getTargetedBlockEntity(bestWorld, mc);
            if (be instanceof class_2609) {
                class_2609 furnace = (class_2609)be;
                this.addLine("Furnace XP: " + GuiBase.TXT_AQUA + MiscUtils.getFurnaceXpAmount(furnace));
            }
        } else if (type == InfoToggle.HONEY_LEVEL) {
            class_2680 state = this.getTargetedBlock(mc);
            if (state != null && state.method_26204() instanceof class_4481) {
                this.addLine("Honey: " + GuiBase.TXT_AQUA + class_4482.method_23902((class_2680)state));
            }
        } else if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP) {
            if (this.addedTypes.contains((Object)InfoToggle.HORSE_SPEED) || this.addedTypes.contains((Object)InfoToggle.HORSE_JUMP)) {
                return;
            }
            class_1297 vehicle = this.mc.field_1724.method_5854();
            if (!(vehicle instanceof class_1496)) {
                return;
            }
            class_1496 horse = (class_1496)vehicle;
            if (horse.method_6725()) {
                if (InfoToggle.HORSE_SPEED.getBooleanValue()) {
                    float speed = horse.method_6029();
                    this.addLine(String.format("Horse Speed: %.3f m/s", Float.valueOf(speed *= 42.163f)));
                }
                if (InfoToggle.HORSE_JUMP.getBooleanValue()) {
                    double jump = horse.method_6771();
                    double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
                    this.addLine(String.format("Horse Jump: %.3f m", calculatedJumpHeight));
                }
                this.addedTypes.add(InfoToggle.HORSE_SPEED);
                this.addedTypes.add(InfoToggle.HORSE_JUMP);
            }
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW) || this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH) || this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                str.append(String.format("yaw: %.1f", Float.valueOf(class_3532.method_15393((float)entity.method_36454()))));
                pre = " / ";
            }
            if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                str.append(pre).append(String.format("pitch: %.1f", Float.valueOf(class_3532.method_15393((float)entity.method_36455()))));
                pre = " / ";
            }
            if (InfoToggle.SPEED.getBooleanValue()) {
                double dx = entity.method_23317() - entity.field_6038;
                double dy = entity.method_23318() - entity.field_5971;
                double dz = entity.method_23321() - entity.field_5989;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                str.append(pre).append(String.format("speed: %.3f m/s", dist * 20.0));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.ROTATION_YAW);
            this.addedTypes.add(InfoToggle.ROTATION_PITCH);
            this.addedTypes.add(InfoToggle.SPEED);
        } else if (type == InfoToggle.SPEED_HV) {
            double dx = entity.method_23317() - entity.field_6038;
            double dy = entity.method_23318() - entity.field_5971;
            double dz = entity.method_23321() - entity.field_5989;
            this.addLine(String.format("speed: xz: %.3f y: %.3f m/s", Math.sqrt(dx * dx + dz * dz) * 20.0, dy * 20.0));
        } else if (type == InfoToggle.SPEED_AXIS) {
            double dx = entity.method_23317() - entity.field_6038;
            double dy = entity.method_23318() - entity.field_5971;
            double dz = entity.method_23321() - entity.field_5989;
            this.addLine(String.format("speed: x: %.3f y: %.3f z: %.3f m/s", dx * 20.0, dy * 20.0, dz * 20.0));
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            this.addLine(String.format("C: %d", ((IMixinWorldRenderer)mc.field_1769).getRenderedChunksInvoker()));
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            this.addLine(mc.field_1769.method_3289());
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            this.addLine("TODO");
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            String chunksClient = mc.field_1687.method_31419();
            class_1937 worldServer = WorldUtils.getBestWorld((class_310)mc);
            if (worldServer != null && worldServer != mc.field_1687) {
                int chunksServer = ((class_3215)worldServer.method_8398()).method_14151();
                int chunksServerTot = ((class_3215)worldServer.method_8398()).method_17301();
                this.addLine(String.format("Server: %d / %d - Client: %s", chunksServer, chunksServerTot, chunksClient));
            } else {
                this.addLine(chunksClient);
            }
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            this.addLine(String.format("P: %s", mc.field_1713.method_3052()));
        } else if (type == InfoToggle.DIFFICULTY) {
            long chunkInhabitedTime = 0L;
            float moonPhaseFactor = 0.0f;
            class_2818 serverChunk = this.getChunk(chunkPos);
            if (serverChunk != null) {
                moonPhaseFactor = mc.field_1687.method_30272();
                chunkInhabitedTime = serverChunk.method_12033();
            }
            class_1266 diff = new class_1266(mc.field_1687.method_8407(), mc.field_1687.method_8532(), chunkInhabitedTime, moonPhaseFactor);
            this.addLine(String.format("Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(diff.method_5457()), Float.valueOf(diff.method_5458()), mc.field_1687.method_8532() / 24000L));
        } else if (type == InfoToggle.BIOME) {
            class_2818 clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.method_12223()) {
                class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
                class_2960 id = mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
                this.addLine("Biome: " + StringUtils.translate((String)("biome." + id.toString().replace(":", ".")), (Object[])new Object[0]));
            }
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            class_2818 clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.method_12223()) {
                class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
                class_2960 rl = mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
                String name = rl != null ? rl.toString() : "?";
                this.addLine("Biome reg name: " + name);
            }
        } else if (type == InfoToggle.ENTITIES) {
            String ent = mc.field_1769.method_3272();
            int p = ent.indexOf(",");
            if (p != -1) {
                ent = ent.substring(0, p);
            }
            this.addLine(ent);
        } else if (type == InfoToggle.TILE_ENTITIES) {
            this.addLine("Client world TE - L: ?, T: ? - TODO 1.17");
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            class_1937 serverWorld;
            int countClient = mc.field_1687.method_18120();
            if (mc.method_1496() && (serverWorld = WorldUtils.getBestWorld((class_310)mc)) instanceof class_3218) {
                IServerEntityManager manager = (IServerEntityManager)((IMixinServerWorld)serverWorld).minihud_getEntityManager();
                int indexSize = manager.getIndexSize();
                this.addLine(String.format("Entities - Client: %d - Server: %d", countClient, indexSize));
                return;
            }
            this.addLine(String.format("Entities - Client: %d", countClient));
        } else if (type == InfoToggle.SLIME_CHUNK) {
            Object result;
            if (!MiscUtils.isOverworld(world)) {
                return;
            }
            if (this.data.isWorldSeedKnown(world)) {
                long seed = this.data.getWorldSeed(world);
                result = MiscUtils.canSlimeSpawnAt(pos.method_10263(), pos.method_10260(), seed) ? GuiBase.TXT_GREEN + "YES" + GuiBase.TXT_RST : GuiBase.TXT_RED + "NO" + GuiBase.TXT_RST;
            } else {
                result = "<world seed not known>";
            }
            this.addLine("Slime chunk: " + (String)result);
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1331) {
                class_1297 lookedEntity = ((class_3966)mc.field_1765).method_17782();
                if (lookedEntity instanceof class_1309) {
                    class_1309 living = (class_1309)lookedEntity;
                    this.addLine(String.format("Entity: %s - HP: %.1f / %.1f", living.method_5477().getString(), Float.valueOf(living.method_6032()), Float.valueOf(living.method_6063())));
                } else {
                    this.addLine(String.format("Entity: %s", lookedEntity.method_5477().getString()));
                }
            }
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            class_1297 lookedEntity;
            class_2960 regName;
            if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1331 && (regName = class_1299.method_5890((class_1299)(lookedEntity = ((class_3966)mc.field_1765).method_17782()).method_5864())) != null) {
                this.addLine(String.format("Entity reg name: %s", regName.toString()));
            }
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK) || this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK_CHUNK)) {
                return;
            }
            if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
                class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if (InfoToggle.LOOKING_AT_BLOCK.getBooleanValue()) {
                    str.append(String.format("Looking at block: %d, %d, %d", lookPos.method_10263(), lookPos.method_10264(), lookPos.method_10260()));
                    pre = " // ";
                }
                if (InfoToggle.LOOKING_AT_BLOCK_CHUNK.getBooleanValue()) {
                    str.append(pre).append(String.format("Block: %d, %d, %d in Sub-Chunk: %d, %d, %d", lookPos.method_10263() & 0xF, lookPos.method_10264() & 0xF, lookPos.method_10260() & 0xF, lookPos.method_10263() >> 4, lookPos.method_10264() >> 4, lookPos.method_10260() >> 4));
                }
                this.addLine(str.toString());
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK);
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK_CHUNK);
            }
        } else if (type == InfoToggle.BLOCK_PROPS) {
            this.getBlockProperties(mc);
        }
    }

    @Nullable
    private class_2586 getTargetedBlockEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_2818 chunk = this.getChunk(new class_1923(posLooking));
            return chunk != null ? chunk.method_8321(posLooking) : null;
        }
        return null;
    }

    @Nullable
    private class_2680 getTargetedBlock(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            return mc.field_1687.method_8320(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_2680 state = mc.field_1687.method_8320(posLooking);
            class_2960 rl = class_2378.field_11146.method_10221((Object)state.method_26204());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((class_2680)state)) {
                this.addLine(line);
            }
        }
    }

    @Nullable
    private class_2818 getChunk(class_1923 chunkPos) {
        CompletableFuture<class_2818> future = this.chunkFutures.get(chunkPos);
        if (future == null) {
            future = this.setupChunkFuture(chunkPos);
        }
        return future.getNow(null);
    }

    private CompletableFuture<class_2818> setupChunkFuture(class_1923 chunkPos) {
        class_3218 world;
        class_1132 server = this.mc.method_1576();
        CompletionStage<Object> future = null;
        if (server != null && (world = server.method_3847(this.mc.field_1687.method_27983())) != null) {
            future = world.method_14178().method_17299(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false).thenApply(either -> (class_2818)either.map(chunk -> (class_2818)chunk, unloaded -> null));
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(this.getClientChunk(chunkPos));
        }
        this.chunkFutures.put(chunkPos, (CompletableFuture<class_2818>)future);
        return future;
    }

    private class_2818 getClientChunk(class_1923 chunkPos) {
        if (this.cachedClientChunk == null || !this.cachedClientChunk.method_12004().equals((Object)chunkPos)) {
            this.cachedClientChunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        }
        return this.cachedClientChunk;
    }

    private void resetCachedChunks() {
        this.chunkFutures.clear();
        this.cachedClientChunk = null;
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

