/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.BlockGridMode;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_310;

public class OverlayRendererBlockGrid
extends OverlayRendererBase {
    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_BLOCK_GRID.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.lastUpdatePos == null) {
            return true;
        }
        return Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > 8.0 || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > 8.0 || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > 8.0;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        Color4f color = Configs.Colors.BLOCK_GRID_OVERLAY_COLOR.getColor();
        int radius = Configs.Generic.BLOCK_GRID_OVERLAY_RADIUS.getIntegerValue();
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.method_1328(renderLines.getGlMode(), class_290.field_1576);
        BlockGridMode mode = (BlockGridMode)Configs.Generic.BLOCK_GRID_OVERLAY_MODE.getOptionListValue();
        switch (mode) {
            case ALL: {
                this.renderLinesAll(cameraPos, this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case NON_AIR: {
                this.renderLinesNonAir(cameraPos, entity.method_5770(), this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case ADJACENT: {
                this.renderLinesAdjacentToNonAir(cameraPos, entity.method_5770(), this.lastUpdatePos, radius, color, BUFFER_1);
            }
        }
        BUFFER_1.method_1326();
        renderLines.uploadData(BUFFER_1);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(class_293.class_5596.field_29344);
    }

    protected void renderLinesAll(class_243 cameraPos, class_2338 center, int radius, Color4f color, class_287 buffer) {
        double y;
        double x;
        double startX = (double)(center.method_10263() - radius) - cameraPos.field_1352;
        double startY = (double)(center.method_10264() - radius) - cameraPos.field_1351;
        double startZ = (double)(center.method_10260() - radius) - cameraPos.field_1350;
        double endX = (double)(center.method_10263() + radius) - cameraPos.field_1352;
        double endY = (double)(center.method_10264() + radius) - cameraPos.field_1351;
        double endZ = (double)(center.method_10260() + radius) - cameraPos.field_1350;
        for (x = startX; x <= endX; x += 1.0) {
            for (y = startY; y <= endY; y += 1.0) {
                buffer.method_22912(x, y, startZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, endZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
        for (x = startX; x <= endX; x += 1.0) {
            for (double z = startZ; z <= endZ; z += 1.0) {
                buffer.method_22912(x, startY, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, endY, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
        for (double z = startZ; z <= endZ; z += 1.0) {
            for (y = startY; y <= endY; y += 1.0) {
                buffer.method_22912(startX, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(endX, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }

    protected void renderLinesNonAir(class_243 cameraPos, class_1937 world, class_2338 center, int radius, Color4f color, class_287 buffer) {
        int startX = center.method_10263() - radius;
        int startY = center.method_10264() - radius;
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = center.method_10264() + radius;
        int endZ = center.method_10260() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        class_2818 chunk = world.method_8497(lastCX, lastCZ);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.method_8497(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                for (int y = startY; y <= endY && y <= chunk.method_12005(class_2902.class_2903.field_13202, x, z); ++y) {
                    posMutable.method_10103(x, y, z);
                    if (chunk.method_8320((class_2338)posMutable).method_26215()) continue;
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                }
            }
        }
    }

    protected void renderLinesAdjacentToNonAir(class_243 cameraPos, class_1937 world, class_2338 center, int radius, Color4f color, class_287 buffer) {
        int startX = center.method_10263() - radius;
        int startY = center.method_10264() - radius;
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = center.method_10264() + radius;
        int endZ = center.method_10260() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        class_2818 chunk = world.method_8497(lastCX, lastCZ);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        class_2338.class_2339 posMutable2 = new class_2338.class_2339();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.method_8497(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                block2: for (int y = startY; y <= endY; ++y) {
                    posMutable.method_10103(x, y, z);
                    if (!chunk.method_8320((class_2338)posMutable).method_26215()) continue;
                    for (class_2350 side : PositionUtils.VERTICAL_DIRECTIONS) {
                        posMutable2.method_10103(posMutable.method_10263() + side.method_10148(), posMutable.method_10264() + side.method_10164(), posMutable.method_10260() + side.method_10165());
                        if (chunk.method_8320((class_2338)posMutable2).method_26215()) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                        break;
                    }
                    for (class_2350 side : PositionUtils.HORIZONTAL_DIRECTIONS) {
                        posMutable2.method_10103(posMutable.method_10263() + side.method_10148(), posMutable.method_10264() + side.method_10164(), posMutable.method_10260() + side.method_10165());
                        if (world.method_22347((class_2338)posMutable2)) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                        continue block2;
                    }
                }
            }
        }
    }
}

