/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected boolean resourcesAllocated;
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(OverlayRendererBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererBiomeBorders.INSTANCE);
        this.addRenderer(new OverlayRendererBlockGrid());
        this.addRenderer(OverlayRendererConduitRange.INSTANCE);
        this.addRenderer(OverlayRendererLightLevel.INSTANCE);
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED));
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER));
        this.addRenderer(new OverlayRendererRegion());
        this.addRenderer(new OverlayRendererSlimeChunks());
        this.addRenderer(new OverlayRendererSpawnableColumnHeights());
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL));
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER));
        this.addRenderer(OverlayRendererStructures.INSTANCE);
    }

    public void addRenderer(OverlayRendererBase renderer) {
        if (this.resourcesAllocated) {
            renderer.allocateGlResources();
        }
        this.renderers.add(renderer);
    }

    public void removeRenderer(OverlayRendererBase renderer) {
        this.renderers.remove(renderer);
        if (this.resourcesAllocated) {
            renderer.deleteGlResources();
        }
    }

    public void render(class_1297 entity, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        this.update(cameraPos, entity, mc);
        this.draw(cameraPos, matrixStack, projMatrix, mc);
    }

    protected void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        mc.method_16011().method_15400(() -> "RenderContainer#update()");
        this.allocateResourcesIfNeeded();
        this.countActive = 0;
        for (OverlayRendererBase renderer : this.renderers) {
            mc.method_16011().method_15400(() -> renderer.getClass().getName());
            if (renderer.shouldRender(mc)) {
                if (renderer.needsUpdate(entity, mc)) {
                    renderer.lastUpdatePos = PositionUtils.getEntityBlockPos((class_1297)entity);
                    renderer.setUpdatePosition(cameraPos);
                    renderer.update(cameraPos, entity, mc);
                }
                ++this.countActive;
            }
            mc.method_16011().method_15407();
        }
        mc.method_16011().method_15407();
    }

    protected void draw(class_243 cameraPos, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        if (this.resourcesAllocated && this.countActive > 0) {
            mc.method_16011().method_15400(() -> "RenderContainer#draw()");
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (IOverlayRenderer iOverlayRenderer : this.renderers) {
                mc.method_16011().method_15400(() -> renderer.getClass().getName());
                if (iOverlayRenderer.shouldRender(mc)) {
                    class_243 updatePos = iOverlayRenderer.getUpdatePosition();
                    matrixStack.method_22903();
                    matrixStack.method_22904(updatePos.field_1352 - cameraPos.field_1352, updatePos.field_1351 - cameraPos.field_1351, updatePos.field_1350 - cameraPos.field_1350);
                    iOverlayRenderer.draw(matrixStack, projMatrix);
                    matrixStack.method_22909();
                }
                mc.method_16011().method_15407();
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            mc.method_16011().method_15407();
        }
    }

    protected void allocateResourcesIfNeeded() {
        if (!this.resourcesAllocated) {
            this.deleteGlResources();
            this.allocateGlResources();
        }
    }

    protected void allocateGlResources() {
        if (!this.resourcesAllocated) {
            for (OverlayRendererBase renderer : this.renderers) {
                renderer.allocateGlResources();
            }
            this.resourcesAllocated = true;
        }
    }

    protected void deleteGlResources() {
        if (this.resourcesAllocated) {
            for (OverlayRendererBase renderer : this.renderers) {
                renderer.deleteGlResources();
            }
            this.resourcesAllocated = false;
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

