/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class ShapeSphereBlocky
extends ShapeCircleBase {
    public ShapeSphereBlocky() {
        this(ShapeType.SPHERE_BLOCKY, Configs.Colors.SHAPE_SPHERE_BLOCKY.getColor(), 16.0);
    }

    public ShapeSphereBlocky(ShapeType type, Color4f color, double radius) {
        super(type, color, radius);
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        this.renderSphereShape(cameraPos);
        this.needsUpdate = false;
    }

    protected SphereUtils.RingPositionTest getPositionTest() {
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, this.getEffectiveCenter(), this.getSquaredRadius(), class_2350.field_11034);
    }

    protected double getTotalRadius() {
        return this.getRadius();
    }

    protected void renderSphereShape(class_243 cameraPos) {
        SphereUtils.RingPositionTest test = this.getPositionTest();
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<class_2338.class_2339> positionConsumer = this.getPositionCollector(positions);
        class_2338 centerPos = this.getCenterBlock();
        double expand = 0.0;
        SphereUtils.collectSpherePositions(positionConsumer, test, centerPos, (int)this.getTotalRadius());
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        if (this.getCombineQuads()) {
            List<SideQuad> quads = SphereUtils.buildSphereShellToQuads(positions, this.mainAxis.method_10166(), test, this.renderType, this.layerRange);
            RenderUtils.renderQuads(quads, this.color, expand, cameraPos, BUFFER_1);
        } else {
            RenderUtils.renderCircleBlockPositions(positions, PositionUtils.ALL_DIRECTIONS, test, this.renderType, this.layerRange, this.color, expand, cameraPos, BUFFER_1);
        }
        BUFFER_1.method_1326();
        renderQuads.uploadData(BUFFER_1);
    }
}

