/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.network.ClientPacketChannelHandler;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.network.StructurePacketHandlerCarpet;
import fi.dy.masa.minihud.network.StructurePacketHandlerServux;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.renderer.worker.ChunkTask;
import fi.dy.masa.minihud.renderer.worker.ThreadWorker;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_5312;
import net.minecraft.class_5321;

public class DataStorage {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MiniHUD Worker Thread %d").setDaemon(true).build();
    private static final Pattern PATTERN_CARPET_TPS = Pattern.compile("TPS: (?<tps>[0-9]+[\\.,][0-9]) MSPT: (?<mspt>[0-9]+[\\.,][0-9])");
    public static final DataStorage INSTANCE = new DataStorage();
    public static final int CARPET_ID_BOUNDINGBOX_MARKERS = 3;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS_START = 7;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS = 8;
    private boolean worldSeedValid;
    private boolean serverTPSValid;
    private boolean hasSyncedTime;
    private boolean carpetServer;
    private boolean servuxServer;
    private boolean worldSpawnValid;
    private boolean hasStructureDataFromServer;
    private boolean structureRendererNeedsUpdate;
    private boolean structuresNeedUpdating;
    private boolean shouldRegisterStructureChannel;
    private int structureDataTimeout = 600;
    private long worldSeed;
    private long lastServerTick;
    private long lastServerTimeUpdate;
    private class_2338 lastStructureUpdatePos;
    private double serverTPS;
    private double serverMSPT;
    private class_2338 worldSpawn = class_2338.field_10980;
    private class_243 distanceReferencePoint = class_243.field_1353;
    private final int[] blockBreakCounter = new int[100];
    private final ArrayListMultimap<StructureType, StructureData> structures = ArrayListMultimap.create();
    private final class_310 mc = class_310.method_1551();
    private final PriorityBlockingQueue<ChunkTask> taskQueue = Queues.newPriorityBlockingQueue();
    private final Thread workerThread;
    private final ThreadWorker worker = new ThreadWorker();

    private DataStorage() {
        this.workerThread = THREAD_FACTORY.newThread(this.worker);
        this.workerThread.start();
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("DataStorage#reset() - log-out", new Object[0]);
        } else {
            MiniHUD.printDebug("DataStorage#reset() - dimension change or log-in", new Object[0]);
        }
        this.serverTPSValid = false;
        this.hasSyncedTime = false;
        this.carpetServer = false;
        this.worldSpawnValid = false;
        this.structuresNeedUpdating = true;
        this.hasStructureDataFromServer = false;
        this.structureRendererNeedsUpdate = true;
        this.lastStructureUpdatePos = null;
        this.structures.clear();
        this.worldSpawn = class_2338.field_10980;
        this.clearTasks();
        StructurePacketHandlerCarpet.INSTANCE.reset();
        StructurePacketHandlerServux.INSTANCE.reset();
        ShapeManager.INSTANCE.clear();
        OverlayRendererBeaconRange.INSTANCE.clear();
        OverlayRendererConduitRange.INSTANCE.clear();
        OverlayRendererBiomeBorders.INSTANCE.clear();
        OverlayRendererLightLevel.reset();
        if (isLogout || !Configs.Generic.DONT_RESET_SEED_ON_DIMENSION_CHANGE.getBooleanValue()) {
            this.worldSeedValid = false;
            this.worldSeed = 0L;
        }
        if (isLogout) {
            this.servuxServer = false;
            this.structureDataTimeout = 600;
        }
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }

    public ChunkTask getNextTask() throws InterruptedException {
        return this.taskQueue.take();
    }

    public void addTask(Runnable task, class_1923 pos, class_2382 playerPos) {
        if (this.taskQueue.size() < 64000) {
            this.taskQueue.offer(new ChunkTask(task, pos, playerPos));
        }
    }

    public void setIsServuxServer() {
        MiniHUD.printDebug("DataStorage#setIsServuxServer()", new Object[0]);
        this.servuxServer = true;
        ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
    }

    public void onWorldJoin() {
        MiniHUD.printDebug("DataStorage#onWorldJoin()", new Object[0]);
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
        OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
        if (!this.mc.method_1496() && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            this.shouldRegisterStructureChannel = true;
        }
    }

    public void setWorldSeed(long seed) {
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(class_2338 spawn) {
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setWorldSpawnIfUnknown(class_2338 spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
        }
    }

    public boolean isWorldSeedKnown(class_1937 world) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.method_1496()) {
            class_1132 server = this.mc.method_1576();
            class_3218 worldTmp = server.method_3847(world.method_27983());
            return worldTmp != null;
        }
        return false;
    }

    public boolean hasStoredWorldSeed() {
        return this.worldSeedValid;
    }

    public long getWorldSeed(class_1937 world) {
        class_1132 server;
        class_3218 worldTmp;
        if (!this.worldSeedValid && this.mc.method_1496() && (worldTmp = (server = this.mc.method_1576()).method_3847(world.method_27983())) != null) {
            this.setWorldSeed(worldTmp.method_8412());
        }
        return this.worldSeed;
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public class_2338 getWorldSpawn() {
        return this.worldSpawn;
    }

    public boolean hasTPSData() {
        return this.serverTPSValid;
    }

    public boolean isCarpetServer() {
        return this.carpetServer;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getServerMSPT() {
        return this.serverMSPT;
    }

    public boolean structureRendererNeedsUpdate() {
        return this.structureRendererNeedsUpdate;
    }

    public void setStructuresNeedUpdating() {
        this.structuresNeedUpdating = true;
    }

    public void setStructureRendererNeedsUpdate() {
        this.structureRendererNeedsUpdate = true;
    }

    public class_243 getDistanceReferencePoint() {
        return this.distanceReferencePoint;
    }

    public void setDistanceReferencePoint(class_243 pos) {
        this.distanceReferencePoint = pos;
        String str = String.format("x: %.2f, y: %.2f, z: %.2f", pos.field_1352, pos.field_1351, pos.field_1350);
        InfoUtils.printActionbarMessage((String)"minihud.message.distance_reference_point_set", (Object[])new Object[]{str});
    }

    public void markChunkForHeightmapCheck(int chunkX, int chunkZ) {
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity != null) {
            class_243 pos = entity.method_19538();
            if (Math.abs(pos.field_1352 - (double)(chunkX << 4) - 8.0) <= 48.0 || Math.abs(pos.field_1350 - (double)(chunkZ << 4) - 8.0) <= 48.0) {
                OverlayRendererSpawnableColumnHeights.markChunkChanged(chunkX, chunkZ);
                OverlayRendererLightLevel.setNeedsUpdate();
            }
        }
    }

    public void onClientTickPre(class_310 mc) {
        if (mc.field_1687 != null) {
            int tick = (int)(mc.field_1687.method_8510() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[tick] = 0;
        }
    }

    public void onPlayerBlockBreak(class_310 mc) {
        if (mc.field_1687 != null) {
            int tick;
            int n = tick = (int)(mc.field_1687.method_8510() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[n] = this.blockBreakCounter[n] + 1;
        }
    }

    public double getBlockBreakingSpeed() {
        return MiscUtils.intAverage(this.blockBreakCounter) * 20.0;
    }

    public boolean onSendChatMessage(class_1657 player, String message) {
        String[] parts = message.split(" ");
        if (parts[0].equals("minihud-seed") || parts[0].equals("/minihud-seed")) {
            if (parts.length == 2) {
                try {
                    this.setWorldSeed(Long.parseLong(parts[1]));
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (NumberFormatException e) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_seed", (Object[])new Object[0]);
                }
            } else if (parts.length == 1) {
                if (this.worldSeedValid) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_is", (Object[])new Object[]{this.worldSeed});
                } else {
                    InfoUtils.printActionbarMessage((String)"minihud.message.no_seed", (Object[])new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public void onChatMessage(class_2561 message) {
        if (message instanceof class_2588) {
            class_2588 text = (class_2588)message;
            if ("commands.seed.success".equals(text.method_11022())) {
                try {
                    String str = text.getString();
                    int i1 = str.indexOf("[");
                    int i2 = str.indexOf("]");
                    if (i1 != -1 && i2 != -1) {
                        this.setWorldSeed(Long.parseLong(str.substring(i1 + 1, i2)));
                        MiniHUD.logger.info("Received world seed from the vanilla /seed command: {}", (Object)this.worldSeed);
                        InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                    }
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.method_11023()[0], (Object)e);
                }
            } else if ("jed.commands.seed.success".equals(text.method_11022())) {
                try {
                    this.setWorldSeed(Long.parseLong(text.method_11023()[1].toString()));
                    MiniHUD.logger.info("Received world seed from the JED '/jed seed' command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.method_11023()[1], (Object)e);
                }
            } else if ("commands.setworldspawn.success".equals(text.method_11022()) && text.method_11023().length == 3) {
                try {
                    Object[] o = text.method_11023();
                    int x = Integer.parseInt(o[0].toString());
                    int y = Integer.parseInt(o[1].toString());
                    int z = Integer.parseInt(o[2].toString());
                    this.setWorldSpawn(new class_2338(x, y, z));
                    String spawnStr = String.format("x: %d, y: %d, z: %d", this.worldSpawn.method_10263(), this.worldSpawn.method_10264(), this.worldSpawn.method_10260());
                    MiniHUD.logger.info("Received world spawn from the vanilla /setworldspawn command: {}", (Object)spawnStr);
                    InfoUtils.printActionbarMessage((String)"minihud.message.spawn_set", (Object[])new Object[]{spawnStr});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world spawn point from '{}'", (Object)text.method_11023(), (Object)e);
                }
            }
        }
    }

    public void onServerTimeUpdate(long totalWorldTime) {
        if (!this.carpetServer && !this.mc.method_1542()) {
            long elapsedTicks;
            long currentTime = System.nanoTime();
            if (this.hasSyncedTime && (elapsedTicks = totalWorldTime - this.lastServerTick) > 0L) {
                this.serverMSPT = (double)(currentTime - this.lastServerTimeUpdate) / (double)elapsedTicks / 1000000.0;
                this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
                this.serverTPSValid = true;
            }
            this.lastServerTick = totalWorldTime;
            this.lastServerTimeUpdate = currentTime;
            this.hasSyncedTime = true;
        }
    }

    public void updateIntegratedServerTPS() {
        if (this.mc != null && this.mc.field_1724 != null && this.mc.method_1576() != null) {
            this.serverMSPT = class_3532.method_15373((long[])this.mc.method_1576().field_4573) / 1000000.0;
            this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            this.serverTPSValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureData() {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                if (values.isEmpty()) continue;
                copy.putAll((Object)type, (Iterable)values);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    public void updateStructureData() {
        long currentTime;
        if (this.mc != null && this.mc.field_1687 != null && this.mc.field_1724 != null && (currentTime = this.mc.field_1687.method_8510()) % 20L == 0L) {
            if (this.mc.method_1496()) {
                class_2338 playerPos;
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue() && this.structuresNeedUpdating(playerPos = PositionUtils.getEntityBlockPos((class_1297)this.mc.field_1724), 32)) {
                    this.updateStructureDataFromIntegratedServer(playerPos);
                }
            } else if (this.hasStructureDataFromServer) {
                this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            } else if (this.shouldRegisterStructureChannel && this.mc.method_1562() != null) {
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                    MiniHUD.printDebug("DataStorage#updateStructureData(): Unregister channels", new Object[0]);
                    ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
                    ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerServux.INSTANCE);
                    this.registerStructureChannel();
                }
                this.shouldRegisterStructureChannel = false;
            }
        }
    }

    public void registerStructureChannel() {
        MiniHUD.printDebug("DataStorage#registerStructureChannel(): Servux", new Object[0]);
        ClientPacketChannelHandler.getInstance().registerClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerServux.INSTANCE);
        if (!this.servuxServer) {
            MiniHUD.printDebug("DataStorage#registerStructureChannel(): Carpet", new Object[0]);
            ClientPacketChannelHandler.getInstance().registerClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
        }
    }

    private boolean structuresNeedUpdating(class_2338 playerPos, int hysteresis) {
        return this.structuresNeedUpdating || this.lastStructureUpdatePos == null || Math.abs(playerPos.method_10263() - this.lastStructureUpdatePos.method_10263()) >= hysteresis || Math.abs(playerPos.method_10264() - this.lastStructureUpdatePos.method_10264()) >= hysteresis || Math.abs(playerPos.method_10260() - this.lastStructureUpdatePos.method_10260()) >= hysteresis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureDataFromIntegratedServer(class_2338 playerPos) {
        class_2874 dimId = this.mc.field_1724.method_5770().method_8597();
        class_5321 worldId = this.mc.field_1724.method_5770().method_27983();
        class_3218 world = this.mc.method_1576().method_3847(worldId);
        if (world != null) {
            class_1132 server = this.mc.method_1576();
            int maxChunkRange = this.mc.field_1690.field_1870 + 2;
            server.method_18858((Runnable)new class_3738(server.method_3780(), () -> {
                ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
                synchronized (arrayListMultimap) {
                    this.addStructureDataFromGenerator(world, dimId, playerPos, maxChunkRange);
                }
            }));
        } else {
            ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
            synchronized (arrayListMultimap) {
                this.structures.clear();
            }
        }
        this.lastStructureUpdatePos = playerPos;
        this.structuresNeedUpdating = false;
    }

    public void addOrUpdateStructuresFromServer(class_2499 structures, int timeout, boolean isServux) {
        MiniHUD.printDebug("DataStorage#addOrUpdateStructuresFromServer(): start", new Object[0]);
        if (this.servuxServer && !isServux) {
            return;
        }
        if (structures.method_10601() == 10) {
            MiniHUD.printDebug("DataStorage#addOrUpdateStructuresFromServer(): count: " + structures.size(), new Object[0]);
            this.structureDataTimeout = timeout + 200;
            long currentTime = this.mc.field_1687.method_8510();
            int count = structures.size();
            this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            for (int i = 0; i < count; ++i) {
                class_2487 tag = structures.method_10602(i);
                StructureData data = StructureData.fromStructureStartTag(tag, currentTime);
                if (data == null) continue;
                if (this.structures.containsEntry((Object)data.getStructureType(), (Object)data)) {
                    this.structures.remove((Object)data.getStructureType(), (Object)data);
                }
                this.structures.put((Object)data.getStructureType(), (Object)data);
            }
            this.structureRendererNeedsUpdate = true;
            this.hasStructureDataFromServer = true;
        }
    }

    private void removeExpiredStructures(long currentTime, int timeout) {
        long maxAge = timeout;
        this.structures.values().removeIf(data -> currentTime > data.getRefreshTime() + maxAge);
    }

    private void addStructureDataFromGenerator(class_3218 world, class_2874 dimId, class_2338 playerPos, int maxChunkRange) {
        this.structures.clear();
        ArrayList<StructureType> enabledTypes = new ArrayList<StructureType>();
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled() || !type.existsInDimension(dimId)) continue;
            enabledTypes.add(type);
        }
        if (!enabledTypes.isEmpty()) {
            class_2378 registry = world.method_30349().method_30530(class_2378.field_25915);
            int minCX = (playerPos.method_10263() >> 4) - maxChunkRange;
            int minCZ = (playerPos.method_10260() >> 4) - maxChunkRange;
            int maxCX = (playerPos.method_10263() >> 4) + maxChunkRange;
            int maxCZ = (playerPos.method_10260() >> 4) + maxChunkRange;
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    class_2791 chunk = world.method_8402(cx, cz, class_2806.field_12803, false);
                    if (chunk == null) continue;
                    for (StructureType type : enabledTypes) {
                        class_3449 start;
                        class_5312 feature = (class_5312)registry.method_10223(type.getFeatureId());
                        if (feature == null || (start = chunk.method_12181(feature)) == null || !start.method_16657() || !MiscUtils.isStructureWithinRange(start.method_14969(), playerPos, maxChunkRange << 4)) continue;
                        this.structures.put((Object)type, (Object)StructureData.fromStructureStart(type, start));
                    }
                }
            }
        }
        this.structureRendererNeedsUpdate = true;
    }

    public void handleCarpetServerTPSData(class_2561 textComponent) {
        if (!textComponent.getString().isEmpty()) {
            String[] lines;
            String text = class_124.method_539((String)textComponent.getString());
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_TPS.matcher(line);
                if (!matcher.matches()) continue;
                try {
                    this.serverTPS = Double.parseDouble(matcher.group("tps"));
                    this.serverMSPT = Double.parseDouble(matcher.group("mspt"));
                    this.serverTPSValid = true;
                    this.carpetServer = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("distance_pos", (JsonElement)JsonUtils.vec3dToJson((class_243)this.distanceReferencePoint));
        if (this.worldSeedValid) {
            obj.add("seed", (JsonElement)new JsonPrimitive((Number)this.worldSeed));
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        class_243 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"distance_pos");
        this.distanceReferencePoint = pos != null ? pos : class_243.field_1353;
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            this.worldSeed = JsonUtils.getLong((JsonObject)obj, (String)"seed");
            this.worldSeedValid = true;
        }
    }
}

