/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.util.StructureType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

public class StructureData {
    private final StructureType type;
    private final IntBoundingBox mainBox;
    private final ImmutableList<IntBoundingBox> componentBoxes;
    private long refreshTime;

    private StructureData(StructureType type, ImmutableList<IntBoundingBox> componentBoxes, long refreshTime) {
        this(type, componentBoxes);
        this.refreshTime = refreshTime;
    }

    private StructureData(StructureType type, ImmutableList<IntBoundingBox> componentBoxes) {
        this.type = type;
        this.mainBox = StructureData.encompass(componentBoxes);
        this.componentBoxes = componentBoxes;
    }

    public StructureType getStructureType() {
        return this.type;
    }

    public IntBoundingBox getBoundingBox() {
        return this.mainBox;
    }

    public ImmutableList<IntBoundingBox> getComponents() {
        return this.componentBoxes;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public static StructureData fromStructureStart(StructureType type, class_3449 structure) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List components = structure.method_14963();
        for (class_3443 component : components) {
            builder.add((Object)IntBoundingBox.fromVanillaBox((class_3341)component.method_14935()));
        }
        return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build());
    }

    @Nullable
    public static StructureData fromStructureStartTag(class_2487 tag, long currentTime) {
        if (tag.method_10573("id", 8) && tag.method_10573("Children", 9)) {
            StructureType type = StructureType.byStructureId(tag.method_10558("id"));
            ImmutableList.Builder builder = ImmutableList.builder();
            class_2499 pieces = tag.method_10554("Children", 10);
            int count = pieces.size();
            for (int i = 0; i < count; ++i) {
                class_2487 pieceTag = pieces.method_10602(i);
                builder.add((Object)IntBoundingBox.fromArray((int[])pieceTag.method_10561("BB")));
            }
            return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build(), currentTime);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentBoxes == null ? 0 : this.componentBoxes.hashCode());
        result = 31 * result + (this.mainBox == null ? 0 : this.mainBox.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureData other = (StructureData)obj;
        if (this.componentBoxes == null ? other.componentBoxes != null : !this.componentBoxes.equals(other.componentBoxes)) {
            return false;
        }
        if (this.mainBox == null ? other.mainBox != null : !this.mainBox.equals((Object)other.mainBox)) {
            return false;
        }
        return this.type == other.type;
    }

    public static IntBoundingBox encompass(Iterable<IntBoundingBox> boxes) {
        Iterator<IntBoundingBox> iterator = boxes.iterator();
        if (iterator.hasNext()) {
            IntBoundingBox box = iterator.next();
            int minX = box.minX;
            int minY = box.minY;
            int minZ = box.minZ;
            int maxX = box.maxX;
            int maxY = box.maxY;
            int maxZ = box.maxZ;
            while (iterator.hasNext()) {
                box = iterator.next();
                minX = Math.min(minX, box.minX);
                minY = Math.min(minY, box.minY);
                minZ = Math.min(minZ, box.minZ);
                maxX = Math.max(maxX, box.maxX);
                maxY = Math.max(maxY, box.maxY);
                maxZ = Math.max(maxZ, box.maxZ);
            }
            return new IntBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }
}

