/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_465;

public class AutoCraftingEvaluator {
    public static AutoCraftingResult evaluateAutoCrafting(boolean actuallyCrafting, boolean stackedCrafting, Display display, Supplier<Collection<class_2960>> idsSupplier) {
        class_465<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        AutoCraftingResult result = new AutoCraftingResult();
        ArrayList<Object> errorTooltip = new ArrayList<Object>();
        result.tooltipRenderer = (pos, sink) -> {
            Collection locations;
            ArrayList<class_2561> str = new ArrayList<class_2561>(errorTooltip);
            if (class_310.method_1551().field_1690.field_1827 && idsSupplier != null && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
                str.add((class_2561)new class_2585(" "));
                for (class_2960 location : locations) {
                    String t = class_1074.method_4662((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                    if (t.startsWith("\n")) {
                        t = t.substring("\n".length());
                    }
                    str.add((class_2561)new class_2585(t).method_27692(class_124.field_1080));
                }
            }
            sink.accept(Tooltip.create(pos, str));
        };
        if (containerScreen == null) {
            errorTooltip.add(new class_2588("error.rei.not.supported.move.items").method_27692(class_124.field_1061));
            return result;
        }
        ArrayList<TransferHandler.Result> errors = new ArrayList<TransferHandler.Result>();
        TransferHandler.Context context = TransferHandler.Context.create(actuallyCrafting, stackedCrafting, containerScreen, display);
        for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
            try {
                TransferHandler.Result transferResult = transferHandler.handle(context);
                if (transferResult.isBlocking() && actuallyCrafting) {
                    if (!transferResult.isReturningToScreen()) break;
                    class_310.method_1551().method_1507(containerScreen);
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    break;
                }
                if (!transferResult.isApplicable()) continue;
                result.hasApplicable = true;
                result.tint = transferResult.getColor();
                TransferHandlerRenderer transferHandlerRenderer = transferResult.getRenderer(transferHandler, context);
                if (transferHandlerRenderer != null) {
                    result.renderer = transferHandlerRenderer;
                }
                if (transferResult.getTooltipRenderer() != null) {
                    BiConsumer<Point, TransferHandler.Result.TooltipSink> tooltipRenderer = transferResult.getTooltipRenderer();
                    result.tooltipRenderer = (point, tooltipConsumer) -> tooltipRenderer.accept((Point)point, tooltipConsumer::accept);
                }
                if (transferResult.isSuccessful()) {
                    errors.clear();
                    result.successful = true;
                    result.successfulHandler = transferHandler;
                    break;
                }
                errors.add(transferResult);
                if (!transferResult.isBlocking()) continue;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!result.hasApplicable) {
            errorTooltip.clear();
            errorTooltip.add(new class_2588("error.rei.not.supported.move.items").method_27692(class_124.field_1061));
            return result;
        }
        if (errors.isEmpty()) {
            errorTooltip.clear();
            errorTooltip.add(new class_2588("text.auto_craft.move_items"));
        } else {
            errorTooltip.clear();
            ArrayList<class_2561> tooltipsFilled = new ArrayList<class_2561>();
            for (TransferHandler.Result error : errors) {
                error.fillTooltip(tooltipsFilled);
            }
            if (errors.size() == 1) {
                for (class_2561 tooltipFilled : tooltipsFilled) {
                    colored = tooltipFilled.method_27661().method_27692(class_124.field_1061);
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(tooltipFilled.getString()))) continue;
                    errorTooltip.add(colored);
                }
            } else {
                errorTooltip.add(new class_2588("error.rei.multi.errors").method_27692(class_124.field_1061));
                for (class_2561 tooltipFilled : tooltipsFilled) {
                    colored = new class_2585("- ").method_27692(class_124.field_1061).method_10852((class_2561)tooltipFilled.method_27661().method_27692(class_124.field_1061));
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(colored.getString()))) continue;
                    errorTooltip.add(colored);
                }
            }
        }
        return result;
    }

    public static class AutoCraftingResult {
        public int tint = 0;
        public boolean successful = false;
        public TransferHandler successfulHandler;
        public boolean hasApplicable = false;
        public TransferHandlerRenderer renderer;
        public BiConsumer<Point, Consumer<Tooltip>> tooltipRenderer;
    }
}

