/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.config.ClientData;
import su.plo.voice.client.config.MicrophoneIconPosition;
import su.plo.voice.client.config.entries.BooleanConfigEntry;
import su.plo.voice.client.config.entries.ConfigEntry;
import su.plo.voice.client.config.entries.DoubleConfigEntry;
import su.plo.voice.client.config.entries.IntegerConfigEntry;
import su.plo.voice.client.config.entries.StringConfigEntry;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.gui.tabs.KeyBindingsTabWidget;
import su.plo.voice.client.gui.tabs.TabWidget;

public class ClientConfig {
    private static Gson gson;
    private final HashMap<String, ServerConfig> servers = new HashMap();
    private final HashMap<UUID, Double> playerVolumes = new HashMap();
    public BooleanConfigEntry whitelist = new BooleanConfigEntry();
    public DoubleConfigEntry voiceVolume = new DoubleConfigEntry(0.0, 2.0);
    public DoubleConfigEntry priorityVolume = new DoubleConfigEntry(0.0, 2.0);
    public BooleanConfigEntry occlusion = new BooleanConfigEntry();
    public BooleanConfigEntry speakerMuted = new BooleanConfigEntry();
    public IntegerConfigEntry showIcons = new IntegerConfigEntry(0, 2);
    public MicrophoneIconPositionConfigEntry micIconPosition = new MicrophoneIconPositionConfigEntry();
    public BooleanConfigEntry voiceActivation = new BooleanConfigEntry();
    public DoubleConfigEntry voiceActivationThreshold = new DoubleConfigEntry(-60.0, 0.0);
    public DoubleConfigEntry microphoneAmplification = new DoubleConfigEntry(0.0, 2.0);
    public StringConfigEntry microphone = new StringConfigEntry();
    public StringConfigEntry speaker = new StringConfigEntry();
    public BooleanConfigEntry rnNoise = new BooleanConfigEntry();
    public BooleanConfigEntry microphoneMuted = new BooleanConfigEntry();
    public BooleanConfigEntry javaxCapture = new BooleanConfigEntry();
    public BooleanConfigEntry hrtf = new BooleanConfigEntry();
    public BooleanConfigEntry directionalSources = new BooleanConfigEntry();
    public IntegerConfigEntry directionalSourcesAngle = new IntegerConfigEntry(100, 360);
    public BooleanConfigEntry compressor = new BooleanConfigEntry();
    public IntegerConfigEntry compressorThreshold = new IntegerConfigEntry(-60, 0);
    public IntegerConfigEntry limiterThreshold = new IntegerConfigEntry(-60, 0);
    public BooleanConfigEntry visualizeDistance = new BooleanConfigEntry();
    public ConfigKeyBindings keyBindings = new ConfigKeyBindings();
    public BooleanConfigEntry showPriorityVolume = new BooleanConfigEntry();
    public BooleanConfigEntry micReverb = new BooleanConfigEntry();
    public DoubleConfigEntry micReverbVolume = new DoubleConfigEntry(0.0, 2.0);
    private transient HashSet<UUID> muted = new HashSet();
    private transient HashSet<UUID> whitelisted = new HashSet();

    public static ClientConfig read() {
        ClientConfig config = null;
        File configFile = new File("config/PlasmoVoice/config.json");
        if (configFile.exists()) {
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(configFile));
                config = (ClientConfig)gson.fromJson(reader, ClientConfig.class);
            }
            catch (FileNotFoundException reader) {
            }
            catch (JsonSyntaxException e) {
                configFile.delete();
            }
        }
        if (config == null) {
            config = new ClientConfig();
        }
        config.setupDefaults();
        ClientData data = ClientData.read();
        if (data.mutedClients != null) {
            config.muted = data.mutedClients;
        }
        if (data.whitelisted != null) {
            config.whitelisted = data.whitelisted;
        }
        return config;
    }

    public void save() {
        new Thread(() -> {
            File configDir = new File("config/PlasmoVoice");
            configDir.mkdirs();
            try (FileWriter w = new FileWriter("config/PlasmoVoice/config.json");){
                w.write(gson.toJson((Object)this));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        new ClientData(this.muted, this.whitelisted).save();
    }

    public ServerConfig getCurrentServerConfig() {
        return this.servers.get(VoiceClient.getServerConfig().getIp());
    }

    protected void setupDefaults() {
        this.occlusion.setDefault(false);
        this.micReverb.setDefault(true);
        this.micReverbVolume.setDefault(1.0, 0.0, 2.0);
        this.showIcons.setDefault(0, 0, 2);
        this.micIconPosition.setDefault(MicrophoneIconPosition.BOTTOM_CENTER);
        this.voiceActivation.setDefault(false);
        this.voiceActivationThreshold.setDefault(-30.0, -60.0, 0.0);
        this.voiceVolume.setDefault(1.0, 0.0, 2.0);
        this.priorityVolume.setDefault(1.0, 0.0, 2.0);
        this.microphoneAmplification.setDefault(1.0, 0.0, 2.0);
        this.whitelist.setDefault(false);
        this.hrtf.setDefault(false);
        this.microphoneMuted.setDefault(false);
        this.javaxCapture.setDefault(false);
        this.speakerMuted.setDefault(false);
        this.rnNoise.setDefault(false);
        this.directionalSources.setDefault(false);
        this.directionalSourcesAngle.setDefault(145, 100, 360);
        this.visualizeDistance.setDefault(true);
        this.showPriorityVolume.setDefault(true);
        this.compressor.setDefault(true);
        this.compressorThreshold.setDefault(-10, -60, 0);
        this.limiterThreshold.setDefault(-6, -60, 0);
        this.keyBindings.setupDefaults();
    }

    public boolean isMuted(UUID uuid) {
        if (((Boolean)this.whitelist.get()).booleanValue()) {
            return !this.whitelisted.contains(uuid);
        }
        return this.muted.contains(uuid);
    }

    public void mute(UUID uuid) {
        if (((Boolean)this.whitelist.get()).booleanValue()) {
            this.whitelisted.remove(uuid);
        } else {
            this.muted.add(uuid);
        }
        this.save();
    }

    public void unmute(UUID uuid) {
        if (((Boolean)this.whitelist.get()).booleanValue()) {
            this.whitelisted.add(uuid);
        } else {
            this.muted.remove(uuid);
        }
        this.save();
    }

    public double getPlayerVolume(UUID uuid, boolean priority) {
        DoubleConfigEntry entry = (Boolean)this.showPriorityVolume.get() != false && priority ? this.priorityVolume : this.voiceVolume;
        return (Double)entry.get() * this.playerVolumes.getOrDefault(uuid, 1.0);
    }

    public HashMap<String, ServerConfig> getServers() {
        return this.servers;
    }

    public HashMap<UUID, Double> getPlayerVolumes() {
        return this.playerVolumes;
    }

    public HashSet<UUID> getMuted() {
        return this.muted;
    }

    public HashSet<UUID> getWhitelisted() {
        return this.whitelisted;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(BooleanConfigEntry.class, (Object)new BooleanConfigEntry());
        builder.registerTypeAdapter(IntegerConfigEntry.class, (Object)new IntegerConfigEntry(0, 0));
        builder.registerTypeAdapter(MicrophoneIconPositionConfigEntry.class, (Object)new MicrophoneIconPositionConfigEntry());
        builder.registerTypeAdapter(DoubleConfigEntry.class, (Object)new DoubleConfigEntry(0.0, 0.0));
        builder.registerTypeAdapter(StringConfigEntry.class, (Object)new StringConfigEntry());
        builder.registerTypeAdapter(KeyBindingConfigEntry.class, (Object)new KeyBindingConfigEntry());
        gson = builder.create();
    }

    public static class MicrophoneIconPositionConfigEntry
    extends ConfigEntry<MicrophoneIconPosition>
    implements JsonDeserializer<MicrophoneIconPositionConfigEntry>,
    JsonSerializer<MicrophoneIconPositionConfigEntry> {
        public MicrophoneIconPositionConfigEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MicrophoneIconPositionConfigEntry entry = new MicrophoneIconPositionConfigEntry();
            try {
                entry.set(MicrophoneIconPosition.valueOf(json.getAsString()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return entry;
        }

        public JsonElement serialize(MicrophoneIconPositionConfigEntry src, Type typeOfSrc, JsonSerializationContext context) {
            return src.get() == null ? null : new JsonPrimitive(((MicrophoneIconPosition)((Object)src.get())).toString());
        }
    }

    public static class ConfigKeyBindings {
        private static final class_310 client = class_310.method_1551();
        public transient List<String> categories = new ArrayList<String>();
        public transient Map<String, List<KeyBindingConfigEntry>> categoryEntries = new HashMap<String, List<KeyBindingConfigEntry>>();
        public transient Set<KeyBindingConfigEntry> registeredKeyBinds = new ConcurrentSet();
        public KeyBindingConfigEntry pushToTalk = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry priorityPushToTalk = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry muteMicrophone = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry muteChat = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry action = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry increaseDistance = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry decreaseDistance = new KeyBindingConfigEntry();
        public KeyBindingConfigEntry occlusion = new KeyBindingConfigEntry();
        public transient Set<class_3675.class_306> pressed = new ConcurrentSet();

        public void setupDefaults() {
            this.pushToTalk.setDefault(this, new KeyBinding("key.plasmo_voice.ptt", (List<class_3675.class_306>)ImmutableList.of((Object)class_3675.class_307.field_1668.method_1447(342))), "gui.plasmo_voice.general", true);
            this.priorityPushToTalk.setDefault(this, new KeyBinding("key.plasmo_voice.priority_ptt", (List<class_3675.class_306>)ImmutableList.of()), "gui.plasmo_voice.general", true);
            this.muteMicrophone.setDefault(this, new KeyBinding("key.plasmo_voice.mute", (List<class_3675.class_306>)ImmutableList.of((Object)class_3675.class_307.field_1668.method_1447(77))), "gui.plasmo_voice.general", false);
            this.muteChat.setDefault(this, new KeyBinding("key.plasmo_voice.mute_chat", (List<class_3675.class_306>)ImmutableList.of()), "gui.plasmo_voice.general", false);
            this.action.setDefault(this, new KeyBinding("key.plasmo_voice.action", (List<class_3675.class_306>)ImmutableList.of((Object)class_3675.class_307.field_1672.method_1447(1))), "gui.plasmo_voice.general", false);
            this.increaseDistance.setDefault(this, new KeyBinding("key.plasmo_voice.distance.increase", (List<class_3675.class_306>)ImmutableList.of()), "key.plasmo_voice.distance", false);
            this.decreaseDistance.setDefault(this, new KeyBinding("key.plasmo_voice.distance.decrease", (List<class_3675.class_306>)ImmutableList.of()), "key.plasmo_voice.distance", false);
            this.occlusion.setDefault(this, new KeyBinding("key.plasmo_voice.occlusion.toggle", (List<class_3675.class_306>)ImmutableList.of()), "key.plasmo_voice.occlusion", false);
        }

        private boolean isKeyBindOpened() {
            VoiceSettingsScreen screen;
            TabWidget tabWidget;
            class_437 class_4372 = ConfigKeyBindings.client.field_1755;
            if (class_4372 instanceof VoiceSettingsScreen && (tabWidget = (screen = (VoiceSettingsScreen)class_4372).getActiveTab()) instanceof KeyBindingsTabWidget) {
                KeyBindingsTabWidget tabWidget2 = (KeyBindingsTabWidget)tabWidget;
                return tabWidget2.getFocusedBinding() != null;
            }
            return false;
        }

        public void resetKeys() {
            this.pressed.clear();
            for (KeyBindingConfigEntry entry : this.registeredKeyBinds) {
                ((KeyBinding)entry.get()).reset();
            }
        }

        public void onKeyDown(class_3675.class_306 key) {
            if (this.isKeyBindOpened()) {
                return;
            }
            this.pressed.add(key);
            for (KeyBindingConfigEntry entry : this.registeredKeyBinds) {
                if (!entry.anyContext && ConfigKeyBindings.client.field_1755 != null && !ConfigKeyBindings.client.field_1755.field_22792) continue;
                ((KeyBinding)entry.get()).onKeyDown(key);
            }
        }

        public void onKeyUp(class_3675.class_306 key) {
            if (this.isKeyBindOpened()) {
                return;
            }
            this.pressed.removeIf(k -> k.method_1442().equals((Object)key.method_1442()) && k.method_1444() == key.method_1444());
            for (KeyBindingConfigEntry entry : this.registeredKeyBinds) {
                if (!entry.anyContext && ConfigKeyBindings.client.field_1755 != null && !ConfigKeyBindings.client.field_1755.field_22792) continue;
                ((KeyBinding)entry.get()).onKeyUp(key);
            }
        }
    }

    public static class ServerConfig {
        public IntegerConfigEntry distance = new IntegerConfigEntry(0, Short.MAX_VALUE);
        public IntegerConfigEntry priorityDistance = new IntegerConfigEntry(0, Short.MAX_VALUE);
    }

    public static class KeyBindingConfigEntry
    extends ConfigEntry<KeyBinding>
    implements JsonDeserializer<KeyBindingConfigEntry>,
    JsonSerializer<KeyBindingConfigEntry> {
        private boolean anyContext;

        @Override
        public void reset() {
            this.value = new KeyBinding(((KeyBinding)this.defaultValue).getTranslation().method_11022(), (List<class_3675.class_306>)ImmutableList.copyOf(((KeyBinding)this.defaultValue).getKeys()));
        }

        public void setDefault(ConfigKeyBindings keyBindings, KeyBinding value, String category, boolean anyContext) {
            List list;
            this.anyContext = anyContext;
            this.defaultValue = value;
            if (this.value == null) {
                this.value = new KeyBinding(value.getTranslation().method_11022(), (List<class_3675.class_306>)ImmutableList.copyOf(value.getKeys()));
            } else {
                ((KeyBinding)this.value).setTranslation(value.getTranslation());
            }
            if (!keyBindings.categories.contains(category)) {
                keyBindings.categories.add(category);
            }
            if (!(list = (List)keyBindings.categoryEntries.getOrDefault(category, new ArrayList())).contains(this)) {
                list.add(this);
            }
            keyBindings.categoryEntries.put(category, list);
            keyBindings.registeredKeyBinds.add(this);
        }

        @Override
        public boolean isDefault() {
            if (((KeyBinding)this.getDefault()).getKeys().size() != ((KeyBinding)this.get()).getKeys().size()) {
                return false;
            }
            for (int i = 0; i < ((KeyBinding)this.getDefault()).getKeys().size(); ++i) {
                if (((KeyBinding)this.getDefault()).getKeys().get(i).equals((Object)((KeyBinding)this.get()).getKeys().get(i))) continue;
                return false;
            }
            return true;
        }

        public KeyBindingConfigEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            KeyBindingConfigEntry entry = new KeyBindingConfigEntry();
            try {
                ArrayList<class_3675.class_306> keys = new ArrayList<class_3675.class_306>();
                for (JsonElement element : json.getAsJsonArray()) {
                    JsonObject obj = element.getAsJsonObject();
                    keys.add(class_3675.class_307.valueOf((String)obj.get("type").getAsString()).method_1447(obj.get("code").getAsInt()));
                }
                entry.set(new KeyBinding(null, keys));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return entry;
        }

        public JsonElement serialize(KeyBindingConfigEntry src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.get() == null) {
                return null;
            }
            JsonArray keyBindings = new JsonArray();
            for (class_3675.class_306 key : ((KeyBinding)src.get()).getKeys()) {
                JsonObject obj = new JsonObject();
                obj.add("type", (JsonElement)new JsonPrimitive(key.method_1442().name()));
                obj.add("code", (JsonElement)new JsonPrimitive((Number)key.method_1444()));
                keyBindings.add((JsonElement)obj);
            }
            return keyBindings;
        }

        public boolean isAnyContext() {
            return this.anyContext;
        }
    }

    public static class KeyBinding {
        private class_2588 translation;
        private List<class_3675.class_306> keys;
        private boolean pressed;
        private KeyBindingPress onPress;

        public KeyBinding(String translation, List<class_3675.class_306> keys) {
            this.translation = new class_2588(translation);
            this.keys = keys;
        }

        public void reset() {
            this.pressed = false;
        }

        public void onKeyDown(class_3675.class_306 key) {
            if (this.keys.size() > 0 && VoiceClient.getClientConfig().keyBindings.pressed.containsAll(this.keys)) {
                this.pressed = true;
                if (this.onPress != null) {
                    this.onPress.onPress(1);
                }
            }
        }

        public void onKeyUp(class_3675.class_306 key) {
            if (this.pressed && this.keys.size() > 0 && !VoiceClient.getClientConfig().keyBindings.pressed.containsAll(this.keys)) {
                this.pressed = false;
                if (this.onPress != null) {
                    this.onPress.onPress(0);
                }
            }
        }

        public class_2588 getTranslation() {
            return this.translation;
        }

        public void setTranslation(class_2588 translation) {
            this.translation = translation;
        }

        public List<class_3675.class_306> getKeys() {
            return this.keys;
        }

        public void setKeys(List<class_3675.class_306> keys) {
            this.keys = keys;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setOnPress(KeyBindingPress onPress) {
            this.onPress = onPress;
        }

        public static interface KeyBindingPress {
            public void onPress(int var1);
        }
    }
}

