/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.tabs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1077;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_757;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.gui.tabs.TabWidget;

public class AboutTabWidget
extends TabWidget {
    private static final List<Translator> esTranslator = ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("01d40b00-d596-4555-a6ea-86ee31e26d33"), "luni3359"), "GitHub", "https://github.com/luni3359"));
    private static final Map<String, List<Translator>> translators = ImmutableMap.builder().put((Object)"ja_jp", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("a2c18c8f-538d-4ea1-bdee-464dd9df3c52"), "sya_ri"), "GitHub", "https://github.com/sya-ri"))).put((Object)"it_it", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("717a29b8-7476-4d29-ba64-b9c157b9bf83"), "Yriokiri"), "GitHub", "https://github.com/Yriokiri"))).put((Object)"nl_nl", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("db7dce6f-3f20-4c35-b8ca-83b51658ac92"), "EEstar"), "GitHub", "https://github.com/emielderckx"))).put((Object)"uk_ua", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("b149c762-6da3-41b4-8db7-0e87330fb9aa"), "_ProSplash_"), "GitHub", "https://github.com/Yuraplonka"))).put((Object)"fr_fr", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("1bbe13ee-a3c9-4490-a9bc-ee8cb64ccb2b"), "JeyPeytey"), "Instagram", "https://instagram.com/jeremy_giardina"))).put((Object)"es_ar", esTranslator).put((Object)"es_cl", esTranslator).put((Object)"es_ec", esTranslator).put((Object)"es_es", esTranslator).put((Object)"es_mx", esTranslator).put((Object)"es_uy", esTranslator).put((Object)"es_ve", esTranslator).put((Object)"ko_kr", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("48a50be9-085c-46f5-b5f3-e5d0ba7fd415"), "Null_D"), "GitHub", "https://github.com/NullD4201"))).put((Object)"pt_br", (Object)ImmutableList.of((Object)new Translator(new GameProfile(UUID.fromString("dcfcfdbe-62fc-4895-aab3-04cd83e09d4a"), "AliMakya"), "Twitch", "https://www.twitch.tv/alimakya"))).build();
    private final VoiceSettingsScreen parent;

    public AboutTabWidget(class_310 client, VoiceSettingsScreen parent) {
        super(client, parent);
        class_2588 links;
        this.parent = parent;
        class_2477 language = class_2477.method_10517();
        class_2588 madeBy = new class_2588("gui.plasmo_voice.about.made_by", new Object[]{"Plasmo Voice"});
        if (!language.method_4679(madeBy.method_11022()).contains("%s")) {
            madeBy = new class_2585("Plasmo Voice is made by");
        }
        this.method_25321((class_350.class_351)new TabWidget.CategoryEntry(this, (class_2561)madeBy, 24));
        this.method_25321((class_350.class_351)new DeveloperEntry("KPidS", (class_2561)new class_2588("gui.plasmo_voice.about.huix"), "Twitch", "https://twitch.tv/kpids"));
        this.method_25321((class_350.class_351)new DeveloperEntry("Apehum", (class_2561)new class_2588("gui.plasmo_voice.about.programming"), "Twitch", "https://twitch.tv/apehum"));
        this.method_25321((class_350.class_351)new DeveloperEntry("Venterok", (class_2561)new class_2588("gui.plasmo_voice.about.artist"), "Twitter", "https://twitter.com/venterrok"));
        class_1077 languageInfo = client.method_1526().method_4669();
        List<Translator> langTranslators = translators.get(languageInfo.getCode());
        if (langTranslators != null) {
            for (Translator translator : langTranslators) {
                DeveloperEntry.loadTranslatorSkin(translator);
                this.method_25321((class_350.class_351)new DeveloperEntry(translator.getProfile().getName(), (class_2561)new class_2588("gui.plasmo_voice.about.translator", new Object[]{languageInfo.getName()}), translator.getLink(), translator.getLinkUrl()));
            }
        }
        if (!language.method_4679((links = new class_2588("gui.plasmo_voice.about.links", new Object[]{"Plasmo Voice"})).method_11022()).contains("%s")) {
            links = new class_2585("Plasmo Voice on");
        }
        this.method_25321((class_350.class_351)new TabWidget.CategoryEntry(this, (class_2561)links));
        this.method_25321((class_350.class_351)new ListEntry((List<class_339>)ImmutableList.of((Object)new class_4185(0, 0, 0, 20, (class_2561)new class_2585("Github"), button -> this.openLink("https://github.com/plasmoapp/plasmo-voice"), (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)new class_2585("https://github.com/plasmoapp/plasmo-voice")))), (Object)new class_4185(0, 0, 0, 20, (class_2561)new class_2585("Discord"), button -> this.openLink("https://discord.com/invite/uueEqzwCJJ"), (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)new class_2585("https://discord.com/invite/uueEqzwCJJ")))))));
        this.method_25321((class_350.class_351)new ListEntry((List<class_339>)ImmutableList.of((Object)new class_4185(0, 0, 0, 20, (class_2561)new class_2585("Modrinth"), button -> this.openLink("https://modrinth.com/mod/plasmo-voice"), (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)new class_2585("https://modrinth.com/mod/plasmo-voice")))), (Object)new class_4185(0, 0, 0, 20, (class_2561)new class_2585("Spigot"), button -> this.openLink("https://www.spigotmc.org/resources/plasmo-voice-server.91064/"), (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)new class_2585("https://www.spigotmc.org/resources/plasmo-voice-server.91064/")))))));
        this.method_25321((class_350.class_351)new TextEntry((class_2561)new class_2588("gui.plasmo_voice.about.copyright")));
    }

    protected void openLink(String linkUrl) {
        this.field_22740.method_1507((class_437)new class_407(ok -> this.confirmLink(ok, linkUrl), linkUrl, true));
    }

    private void confirmLink(boolean ok, String linkUrl) {
        if (ok) {
            class_156.method_668().method_670(linkUrl);
        }
        this.field_22740.method_1507((class_437)this.parent);
    }

    public class DeveloperEntry
    extends TabWidget.Entry {
        private static final class_2960 steveSkin = new class_2960("textures/entity/steve.png");
        public static Map<String, class_2960> skins = new HashMap<String, class_2960>();
        private final class_2585 nick;
        private final class_2561 role;
        private final class_4185 link;

        public static void loadTranslatorSkin(Translator translator) {
            if (!skins.containsKey(translator.getProfile().getName())) {
                RenderSystem.recordRenderCall(() -> DeveloperEntry.loadSkin(translator.getProfile(), null));
            }
        }

        public static void loadSkins() {
            RenderSystem.recordRenderCall(() -> {
                DeveloperEntry.loadSkin(new GameProfile(UUID.fromString("8f552657-df1d-42cd-89c6-c176e195f703"), "Apehum"), "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");
                DeveloperEntry.loadSkin(new GameProfile(UUID.fromString("2714d55f-ffef-4655-a93e-d8ca13230e76"), "KPidS"), "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAHGUlEQVR4Xu1aMYsdVRgdmzQWtqkkEtKYgJAiSiCBBYOSEEgnSLBRkzRRhBTaCbEU1EaxsRPrkESESNhOZFEUlQ0hW+g27q+YvHOZM54597szb2bfi+PiwuHe+93vfvc7534zb97Oq155/umqD1fPH69vvPZSwutnnk3gGHM678Ccx5sK35/2uq574XEcmcEBEh+/e6ndnICNAvxy/8v6wQ9f13uP7td//XY79WFblQCl/THnhB0ey5EZHDzhD998ud0cfZ4wiJK4AjbMebyxGNrfCTs8niMzOJiAnwCSwBxO28kTmPN4YzG0vxN2eDxHZnBgE2ymZYg+E4hOX6vA443F0P5O2OHxHJnBoSXIMtQSdNIOjzcWQ/s7YYfHc2QGBxPQO7v2130JAKX93W8KMoNDN4/AT4CI/CpugoTv6/NTkU5Yy0w34dwQdI2Wp875TcyJ6FpPUvNjH637aSyfj/ZvBWBw3mw0cSfrUD/GUBGUmN/EYMN1Gu1Pu8blXhwzvl7zY/dvN9E7K5y4WMmipB/++E2CCqBrlAQT1vi8ifk8+0yUNvqTiAqh66funypAF+uYi5U4r3E+6UUJ6NjnhuZdANp4uuzrHGMsE9/nOwJoFTA4iKYdq6r9zEcff5iDDxWPNvD49CvN+/4kDMDO/sLe3hh1DfeI4jM/3T+7zrjxz99/kdo/f73Vubvrgw/msJa+TIAJMUHGd7I+r/sr8SGoEES0vx4A9+8sxkfX7u930hitlz1OHuAYc74GVaEkFCqAktSWiTnJIWgMja029HV/jNuPQZwiyChAhte/f87DpvOKn+593gET8JNp5jMyTxJV9elHCX//cSfh0PW3asXFCxfqK1feTkC/av48EOHrFc+8/042Jg7f/IDIYirohzV6IO63LAYFeOPy5VYA9D2Ag4SwltUREXbQZ0gA9dfKdL9lsRYBlDwvF40pp52JMCTAE68AvwQ8gCM6HUBjlk4f8HgOFWAlFeCEmeDZU6dbRPNRC0TJoRpgw5zH4noSe+6Tm20MjadVo/MU0f2caAlJUd0ICaA9d3YjFEA35lomoXE2NzcTeTw3bG1tZUnqGo3hdicGMEfOe/6jBGAwBj/+1Wed03cBIhKeIMbb29tJBJDf3d3trHEBdL3OR8TQR46aj7aYg48TLaFiMG6AduP0maII3IhJaaL0oQB7e3uJPAWgnwpAwkrQfRhTxyocW7U70RJSBVA5bvzqxrlMhD4BokRcACevpGDjyUVicC+3MR5z5x6jBIg2uHT+YiYARdDkdVNNigKA+M7OzlIC6KVIQpEA7qtQPydaQvuxxWRAPKoArwQVgwnoHAQAeVZBaZ0SUTH6BNBqYd7sUzwnWkLnY5AkS+QBFYzruDn7FADktQJ4uSlprtFTjQSgv9pUUI2FsRMtoRoiPAQXgG10CaiPrykRdKK+hvv7GidaQoXPewjAVsWIhKEP/T1hgpeACqBEfI2LoGQdtFMAjcc5J1pCdeLIkfqFo0frk8eO1egD6MPGsYP+aD1ZtpEA6sPkHVoFGPNrt7eAPmrziZM+TrSE6u7tW/V3395NQH/sWInpqZC4fgy6WA7OaXWQWNRG4JwTLSH7MgS4Ux8WiXYA2yLx6DtGx29BMqHxbeHx1419CwAoeYCko7GL9W9jJQI4lHyfbQ74XwC/BgHcgNRpbPK+vmSbA9obEVpcl4unsCzZAy1AQ7i9K+NZ2p0OtAALwqkCIAQEwHO4OwFjRIjIRrY5IBGHABCiqYLanYAxAkS+kW0O6Fz7Tb92J2JZEpFfZJsDEvnmzp/IL77gZE6KZYhEPpFtDkiJEYtve/h6nDkpIBJ82fo8ENkj2xww+wchCq2i6zdJ9HVMP49TwuwFUGJONuqz9TglzF6AZm0Cn1X6QD+PUcJ/VgAdR32PUcLKBWBJElNerh5uSl3/0eF+q8LaBRj7eh1rIAJA8mP+xTUWsxPgwFXAKi6BtVbAoX/+D5A9CMHmCxxKVv99fuLFUx0hFCxxHxMUgHDbmM/5IfQKUPpmqIgEwDsDCKBvezAfkVEBOK+vwXwNY3oeU9ErQPS/AUckAMH3dCqEElG7CuVvitWHr/M9j6nIyE+tACePt0Y8SSat5GFj6wJoVQA65rznMRW9AiAhX+CIBOAbZiVMAZS8VgQJ6jiqAIrkeUxFRl4FwIa+wOHkKQB+Y1AiFJFXEXTeLx+OPY+pSBVQEgAY2qwkAH9joKXrp8yqcAF4WUQC8P7geUxFRt4FAFjmhBJy8ioC+33rXRAXxQWin+c4Fft+EHLiJUSv2gE/fRVpmbGvVZuK6TFoX7kA/vsC/S2Bt4BXhLYRIqIlm1aVz1GEin8qwBj4bwf6fm/A3xzo7w+i19vR7wHQ6m8DPA/HU+9dWwr7FsB/LzB27AJQhKjVvufhYIUO/T0G5hPQF6sFz0sAAAAASUVORK5CYII=");
                DeveloperEntry.loadSkin(new GameProfile(UUID.fromString("cfb727e7-efcc-4596-8c2b-9c6e38c8eea4"), "Venterok"), "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");
            });
        }

        private static void loadSkin(GameProfile profile, String fallback) {
            Map textures;
            if (skins.containsKey(profile.getName())) {
                return;
            }
            if (fallback != null) {
                class_2960 fallbackIdentifier = new class_2960("plasmo_voice", "skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)profile.getName().toLowerCase()).toString());
                try {
                    class_310.method_1551().method_1531().method_4616(fallbackIdentifier, (class_1044)new class_1043(class_1011.method_15990((String)fallback)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                skins.put(profile.getName(), fallbackIdentifier);
            }
            if ((textures = class_310.method_1551().method_1582().method_4654(profile)) == null || textures.isEmpty()) {
                class_310.method_1551().method_1582().method_4652(profile, (type, identifier, texture) -> {
                    if (type.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                        skins.put(profile.getName(), identifier);
                    }
                }, false);
            } else {
                String hash = Hashing.sha1().hashUnencodedChars((CharSequence)((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getHash()).toString();
                class_2960 identifier2 = new class_2960("skins/" + hash);
                skins.put(profile.getName(), identifier2);
            }
        }

        public DeveloperEntry(String nick, class_2561 role, String link, String linkUrl) {
            super(44);
            this.nick = new class_2585(nick);
            this.role = role;
            this.link = link != null ? new class_4185(0, 0, 56, 20, (class_2561)new class_2585(link), button -> AboutTabWidget.this.openLink(linkUrl), (button, matrices, mouseX, mouseY) -> AboutTabWidget.this.setTooltip((List<class_2561>)ImmutableList.of((Object)new class_2585(linkUrl)))) : null;
        }

        public void renderBackground(int y, int x, int entryWidth, int entryHeight) {
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22735);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22912((double)x, (double)(y + entryHeight), 0.0).method_22913(0.0f, (float)entryHeight / 32.0f + 0.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22912((double)(x + entryWidth), (double)(y + entryHeight), 0.0).method_22913((float)entryWidth / 32.0f, (float)entryHeight / 32.0f + 0.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22912((double)(x + entryWidth), (double)y, 0.0).method_22913((float)entryWidth / 32.0f, 0.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22912((double)x, (double)y, 0.0).method_22913(0.0f, 0.0f).method_1336(40, 40, 40, 255).method_1344();
            tessellator.method_1350();
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderBackground(y, x, entryWidth, entryHeight);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)skins.getOrDefault(this.nick.method_10851(), steveSkin));
            class_332.method_25293((class_4587)matrices, (int)(x + 4), (int)(y + 4), (int)32, (int)32, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)matrices, (int)(x + 4), (int)(y + 4), (int)32, (int)32, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            ((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772.method_30881(matrices, (class_2561)this.nick, (float)(x + 40), (float)(y + 11), 0xFFFFFF);
            ((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772.method_30881(matrices, this.role, (float)(x + 40), (float)(y + 21), -5592406);
            if (this.link != null) {
                this.link.field_22760 = x + entryWidth - 62;
                this.link.field_22761 = y + 10;
                this.link.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.link);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.link);
        }
    }

    static class Translator {
        private GameProfile profile;
        private String link;
        private String linkUrl;

        public GameProfile getProfile() {
            return this.profile;
        }

        public String getLink() {
            return this.link;
        }

        public String getLinkUrl() {
            return this.linkUrl;
        }

        public void setProfile(GameProfile profile) {
            this.profile = profile;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public void setLinkUrl(String linkUrl) {
            this.linkUrl = linkUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Translator)) {
                return false;
            }
            Translator other = (Translator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GameProfile this$profile = this.getProfile();
            GameProfile other$profile = other.getProfile();
            if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
                return false;
            }
            String this$link = this.getLink();
            String other$link = other.getLink();
            if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
                return false;
            }
            String this$linkUrl = this.getLinkUrl();
            String other$linkUrl = other.getLinkUrl();
            return !(this$linkUrl == null ? other$linkUrl != null : !this$linkUrl.equals(other$linkUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Translator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GameProfile $profile = this.getProfile();
            result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
            String $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            String $linkUrl = this.getLinkUrl();
            result = result * 59 + ($linkUrl == null ? 43 : $linkUrl.hashCode());
            return result;
        }

        public String toString() {
            return "AboutTabWidget.Translator(profile=" + this.getProfile() + ", link=" + this.getLink() + ", linkUrl=" + this.getLinkUrl() + ")";
        }

        public Translator(GameProfile profile, String link, String linkUrl) {
            this.profile = profile;
            this.link = link;
            this.linkUrl = linkUrl;
        }
    }

    static class ListEntry
    extends TabWidget.Entry {
        private final List<class_339> list;

        public ListEntry(List<class_339> list) {
            super(24);
            this.list = list;
        }

        public List<? extends class_364> method_25396() {
            return this.list;
        }

        public List<? extends class_6379> method_37025() {
            return this.list;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int gap = 4;
            int elementWidth = entryWidth / this.list.size() - (this.list.size() - 1) * (gap / 2);
            if (elementWidth % 2 == 1) {
                gap = (entryWidth - ++elementWidth * this.list.size()) / (this.list.size() - 1);
            }
            int elementX = x;
            for (class_339 element : this.list) {
                element.field_22760 = elementX;
                element.field_22761 = y;
                element.method_25358(elementWidth);
                element.method_25394(matrices, mouseX, mouseY, tickDelta);
                elementX += elementWidth + gap;
            }
        }
    }

    class TextEntry
    extends TabWidget.Entry {
        final class_2561 text;

        public TextEntry(class_2561 text) {
            super(28);
            this.text = text;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            List lines = ((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772.method_1728((class_5348)this.text, entryWidth);
            Objects.requireNonNull(((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772);
            int lineHeight = 9;
            int n = lines.size();
            Objects.requireNonNull(((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772);
            this.setHeight(n * 9 + 8);
            int elementY = y + 16;
            for (class_5481 orderedText : lines) {
                ((AboutTabWidget)AboutTabWidget.this).field_22740.field_1772.method_27517(matrices, orderedText, (float)x, (float)(elementY - lineHeight - 1), -8355712);
                elementY += lineHeight;
            }
        }

        public boolean method_25407(boolean lookForwards) {
            return false;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }
}

