/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.socket;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import net.minecraft.class_310;
import net.minecraft.class_437;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.VoiceNotAvailableScreen;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.socket.SocketClientAuth;
import su.plo.voice.client.socket.SocketClientPing;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.udp.PacketUDP;

public class SocketClientUDP
extends Thread {
    private static final class_310 client = class_310.method_1551();
    private final InetAddress addr = InetAddress.getByName(VoiceClient.getServerConfig().getIp());
    public final int port = VoiceClient.getServerConfig().getPort();
    private final DatagramSocket socket = new DatagramSocket();
    public boolean authorized;
    private final SocketClientAuth auth;
    private final SocketClientUDPQueue clientQueue;
    public final SocketClientPing ping;
    public long keepAlive;

    public SocketClientUDP() throws IOException {
        this.socket.setTrafficClass(4);
        this.keepAlive = System.currentTimeMillis();
        this.auth = new SocketClientAuth(this);
        this.auth.start();
        this.clientQueue = new SocketClientUDPQueue(this);
        this.clientQueue.start();
        this.ping = new SocketClientPing(this);
        this.ping.start();
    }

    public void checkTimeout() {
        VoiceNotAvailableScreen screen;
        class_437 class_4372;
        if (System.currentTimeMillis() - this.keepAlive > 7000L) {
            this.ping.timedOut = true;
            class_4372 = SocketClientUDP.client.field_1755;
            if (class_4372 instanceof VoiceNotAvailableScreen) {
                screen = (VoiceNotAvailableScreen)class_4372;
                screen.setConnecting();
            } else if (SocketClientUDP.client.field_1755 instanceof VoiceSettingsScreen) {
                client.execute(() -> {
                    VoiceNotAvailableScreen screen = new VoiceNotAvailableScreen();
                    screen.setConnecting();
                    client.method_1507((class_437)screen);
                });
            }
        }
        if (System.currentTimeMillis() - this.keepAlive > 30000L) {
            this.ping.timedOut = false;
            VoiceClient.LOGGER.info("UDP timed out");
            VoiceClient.disconnect();
            class_4372 = SocketClientUDP.client.field_1755;
            if (class_4372 instanceof VoiceNotAvailableScreen) {
                screen = (VoiceNotAvailableScreen)class_4372;
                screen.setCannotConnect();
            } else if (SocketClientUDP.client.field_1755 instanceof VoiceSettingsScreen) {
                client.execute(() -> {
                    VoiceNotAvailableScreen screen = new VoiceNotAvailableScreen();
                    screen.setCannotConnect();
                    client.method_1507((class_437)screen);
                });
            }
        }
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void close() {
        if (SocketClientUDP.client.field_1755 instanceof VoiceSettingsScreen) {
            client.execute(() -> client.method_1507((class_437)new VoiceNotAvailableScreen()));
        }
        VoiceClient.LOGGER.info("UDP closed");
        this.socket.close();
        if (this.auth != null && !this.auth.isInterrupted()) {
            this.auth.interrupt();
        }
        if (this.ping != null && !this.ping.isInterrupted()) {
            this.ping.interrupt();
        }
        if (this.clientQueue != null) {
            this.clientQueue.interrupt();
        }
    }

    public void send(Packet packet) throws IOException {
        byte[] data = PacketUDP.write(packet);
        this.socket.send(new DatagramPacket(data, data.length, this.addr, this.port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.socket.isClosed()) {
                this.clientQueue.queue.add(PacketUDP.read(this.socket));
                SocketClientUDPQueue socketClientUDPQueue = this.clientQueue;
                synchronized (socketClientUDPQueue) {
                    this.clientQueue.notify();
                }
            }
            return;
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Socket closed")) return;
            e.printStackTrace();
            return;
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

