/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.config.ClientConfig;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.sound.Limiter;
import su.plo.voice.client.sound.capture.AlCaptureDevice;
import su.plo.voice.client.sound.capture.CaptureDevice;
import su.plo.voice.client.sound.capture.JavaxCaptureDevice;
import su.plo.voice.client.sound.openal.CustomSoundEngine;
import su.plo.voice.client.sound.openal.CustomSource;
import su.plo.voice.client.sound.opus.OpusEncoder;
import su.plo.voice.client.utils.AudioUtils;
import su.plo.voice.common.packets.udp.VoiceClientPacket;
import su.plo.voice.common.packets.udp.VoiceEndClientPacket;
import su.plo.voice.rnnoise.Bytes;
import su.plo.voice.rnnoise.Denoiser;

public class Recorder
implements Runnable {
    private final class_310 client = class_310.method_1551();
    private static final int mtuSize = 1024;
    private static int sampleRate = 0;
    private static int frameSize = 0;
    private static AudioFormat format = null;
    private boolean available;
    private Thread thread;
    private CaptureDevice microphone;
    private OpusEncoder encoder;
    private Denoiser denoiser;
    private final Limiter limiter = new Limiter(-6.0f);
    private int jopusMode;
    private long sequenceNumber = 0L;
    private long lastSpeak;
    private byte[] lastBuffer;
    private CustomSource source;

    public Recorder() {
        if (((Boolean)VoiceClient.getClientConfig().rnNoise.get()).booleanValue()) {
            this.denoiser = new Denoiser();
        }
        VoiceClient.getSoundEngine().onInitialize(engine -> {
            if (engine.isSoundPhysics()) {
                this.source = engine.createSource();
                this.source.setLooping(false);
                this.source.setRelative(false);
                this.source.setReverbOnly(true);
            }
        });
        VoiceClient.getSoundEngine().onClose(() -> {
            if (this.source != null) {
                this.source.close();
            }
        });
        this.jopusMode = 2048;
    }

    public synchronized void toggleRnNoise() {
        if (this.denoiser != null) {
            this.denoiser.close();
            this.denoiser = null;
        } else {
            this.denoiser = new Denoiser();
        }
    }

    public void updateSampleRate(int rate) {
        if (rate == Recorder.getSampleRate() && this.thread != null) {
            return;
        }
        if (rate != 8000 && rate != 12000 && rate != 24000 && rate != 48000) {
            VoiceClient.LOGGER.info("Incorrect sample rate");
            return;
        }
        if (this.thread != null) {
            this.waitForClose().thenRun(() -> this.updateSampleRateSync(rate));
        } else {
            this.updateSampleRateSync(rate);
        }
    }

    private void updateSampleRateSync(int rate) {
        format = new AudioFormat(rate, 16, 1, true, false);
        sampleRate = rate;
        frameSize = sampleRate / 1000 * 2 * 20;
        if (this.encoder != null) {
            this.encoder.close();
        }
        this.encoder = new OpusEncoder(sampleRate, frameSize, 1024, this.jopusMode);
        this.start();
    }

    public void close(boolean disconnect) {
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        if (disconnect) {
            sampleRate = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            if (this.microphone != null && this.microphone.isOpen()) {
                Recorder recorder = this;
                synchronized (recorder) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                }
            }
            this.available = true;
            try {
                if (((Boolean)VoiceClient.getClientConfig().javaxCapture.get()).booleanValue()) {
                    VoiceClient.LOGGER.info("Using javax capture device");
                    this.microphone = new JavaxCaptureDevice();
                } else {
                    this.microphone = new AlCaptureDevice();
                }
                this.microphone.open();
                this.microphone.start();
            }
            catch (IllegalStateException e) {
                VoiceClient.LOGGER.info("Failed to open OpenAL capture device, falling back to javax capturing");
                if (!(this.microphone instanceof AlCaptureDevice)) break block21;
                VoiceClient.getClientConfig().javaxCapture.set(true);
                this.microphone = new JavaxCaptureDevice();
                try {
                    this.microphone.open();
                }
                catch (IllegalStateException ignored) {
                    VoiceClient.getClientConfig().javaxCapture.set(false);
                    VoiceClient.LOGGER.info("Capture device not available on this system");
                    this.available = false;
                    return;
                }
            }
        }
        if (this.encoder == null || this.encoder.isClosed()) {
            this.encoder = new OpusEncoder(sampleRate, frameSize, 1024, this.jopusMode);
        }
        VoiceClient.LOGGER.info("Recorder started");
        while (!this.thread.isInterrupted()) {
            try {
                class_746 player = this.client.field_1724;
                if (player == null || !VoiceClient.isConnected()) {
                    Thread.sleep(1000L);
                    continue;
                }
                byte[] normBuffer = this.readBuffer();
                if (VoiceClient.getServerConfig().getMuted().containsKey(player.method_5667()) || ((Boolean)VoiceClient.getClientConfig().microphoneMuted.get()).booleanValue() || ((Boolean)VoiceClient.getClientConfig().speakerMuted.get()).booleanValue()) {
                    if (VoiceClient.isSettingsOpen()) {
                        if (normBuffer != null) continue;
                        Thread.sleep(5L);
                        continue;
                    }
                    VoiceClient.setSpeaking(false);
                    VoiceClient.setSpeakingPriority(false);
                    Thread.sleep(1000L);
                    continue;
                }
                if (normBuffer == null) {
                    Thread.sleep(5L);
                    continue;
                }
                if (!((Boolean)VoiceClient.getClientConfig().voiceActivation.get()).booleanValue() || VoiceClient.getServerConfig().isVoiceActivationDisabled()) {
                    this.pushToTalk(normBuffer);
                    continue;
                }
                this.voiceActivation(normBuffer);
            }
            catch (InterruptedException ignored) {
                // empty catch block
                break;
            }
        }
        this.cleanup();
    }

    private void voiceActivation(byte[] normBuffer) {
        boolean priorityPressed;
        boolean bl = priorityPressed = ((ClientConfig.KeyBinding)VoiceClient.getClientConfig().keyBindings.priorityPushToTalk.get()).isPressed() && VoiceClient.getServerConfig().isPriority() && VoiceClient.getServerConfig().getPriorityDistance() > VoiceClient.getServerConfig().getMaxDistance();
        if (VoiceClient.isMicrophoneLoopback()) {
            if (VoiceClient.isSpeaking()) {
                VoiceClient.setSpeaking(false);
                VoiceClient.setSpeakingPriority(false);
            }
            return;
        }
        boolean activated = System.currentTimeMillis() - this.lastSpeak <= 500L;
        int offset = AudioUtils.getActivationOffset(normBuffer, (Double)VoiceClient.getClientConfig().voiceActivationThreshold.get());
        if (!VoiceClient.isSpeakingPriority() && priorityPressed) {
            VoiceClient.setSpeakingPriority(true);
        }
        if (priorityPressed && !VoiceClient.isSpeaking()) {
            VoiceClient.setSpeaking(true);
            this.lastSpeak = System.currentTimeMillis();
        } else if (priorityPressed && !VoiceClient.isMicrophoneLoopback()) {
            this.lastSpeak = System.currentTimeMillis();
        } else {
            if (VoiceClient.isSpeakingPriority() && !priorityPressed && (System.currentTimeMillis() - this.lastSpeak > 350L || VoiceClient.isMicrophoneLoopback()) && offset <= 0) {
                VoiceClient.setSpeaking(false);
                VoiceClient.setSpeakingPriority(false);
                this.sendEndPacket();
                return;
            }
            if (offset > 0 || activated) {
                if (offset > 0) {
                    this.lastSpeak = System.currentTimeMillis();
                    if (VoiceClient.isSpeakingPriority() && !priorityPressed) {
                        VoiceClient.setSpeakingPriority(false);
                    }
                }
                if (!VoiceClient.isSpeaking()) {
                    VoiceClient.setSpeaking(true);
                    if (this.lastBuffer != null) {
                        this.sendPacket(this.lastBuffer);
                    }
                    this.sendPacket(normBuffer);
                    return;
                }
            } else if (VoiceClient.isSpeaking()) {
                VoiceClient.setSpeaking(false);
                VoiceClient.setSpeakingPriority(false);
                this.sendPacket(normBuffer);
                this.sendEndPacket();
                return;
            }
        }
        if (VoiceClient.isSpeaking()) {
            this.sendPacket(normBuffer);
        }
        this.lastBuffer = normBuffer;
    }

    private void pushToTalk(byte[] normBuffer) {
        boolean pushToTalkPressed;
        boolean priorityPressed = ((ClientConfig.KeyBinding)VoiceClient.getClientConfig().keyBindings.priorityPushToTalk.get()).isPressed() && VoiceClient.getServerConfig().isPriority() && VoiceClient.getServerConfig().getPriorityDistance() > VoiceClient.getServerConfig().getMaxDistance();
        boolean bl = pushToTalkPressed = ((ClientConfig.KeyBinding)VoiceClient.getClientConfig().keyBindings.pushToTalk.get()).isPressed() || priorityPressed;
        if (!VoiceClient.isMicrophoneLoopback()) {
            if (!VoiceClient.isSpeakingPriority() && priorityPressed) {
                VoiceClient.setSpeakingPriority(true);
            } else if (VoiceClient.isSpeaking() && VoiceClient.isSpeakingPriority() && !priorityPressed && pushToTalkPressed) {
                VoiceClient.setSpeakingPriority(false);
            }
        }
        if (pushToTalkPressed && !VoiceClient.isSpeaking() && !VoiceClient.isMicrophoneLoopback()) {
            VoiceClient.setSpeaking(true);
            this.lastSpeak = System.currentTimeMillis();
        } else if (pushToTalkPressed && !VoiceClient.isMicrophoneLoopback()) {
            this.lastSpeak = System.currentTimeMillis();
        } else if (VoiceClient.isSpeaking() && (System.currentTimeMillis() - this.lastSpeak > 350L || VoiceClient.isMicrophoneLoopback())) {
            VoiceClient.setSpeaking(false);
            VoiceClient.setSpeakingPriority(false);
            this.sendEndPacket();
            return;
        }
        if (VoiceClient.isSpeaking()) {
            this.sendPacket(normBuffer);
        }
    }

    private synchronized byte[] readBuffer() {
        class_437 class_4372;
        if (this.encoder == null || this.encoder.isClosed()) {
            return null;
        }
        this.microphone.start();
        byte[] normBuffer = this.microphone.read(frameSize);
        if (normBuffer == null) {
            return null;
        }
        if (this.denoiser != null) {
            float[] floats = AudioUtils.bytesToFloats(normBuffer);
            this.limiter.limit(floats);
            floats = Bytes.toFloatArray(AudioUtils.floatsToBytes(floats));
            normBuffer = Bytes.toByteArray(this.denoiser.process(floats));
        }
        if ((class_4372 = this.client.field_1755) instanceof VoiceSettingsScreen) {
            VoiceSettingsScreen screen = (VoiceSettingsScreen)class_4372;
            screen.setMicrophoneValue(normBuffer);
        }
        return normBuffer;
    }

    private void sendPacket(byte[] raw) {
        if (VoiceClient.isMicrophoneLoopback()) {
            return;
        }
        if (CustomSoundEngine.soundPhysicsReverb != null && ((Boolean)VoiceClient.getClientConfig().micReverb.get()).booleanValue()) {
            VoiceClient.getSoundEngine().runInContext(() -> {
                class_243 pos = this.client.field_1724.method_19538();
                this.source.setMaxDistance(VoiceClient.getServerConfig().getDistance(), 0.95f);
                this.source.setPosition(pos);
                this.source.setVolume(((Double)VoiceClient.getClientConfig().micReverbVolume.get()).floatValue());
                this.source.write(raw);
            });
        }
        if (!VoiceClient.isConnected()) {
            return;
        }
        try {
            if (!VoiceClient.socketUDP.isClosed()) {
                VoiceClient.socketUDP.send(new VoiceClientPacket(this.encoder.encode(raw), this.sequenceNumber++, VoiceClient.isSpeakingPriority() ? VoiceClient.getServerConfig().getPriorityDistance() : VoiceClient.getServerConfig().getDistance()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendEndPacket() {
        if (!VoiceClient.isConnected()) {
            return;
        }
        this.encoder.reset();
        if (!VoiceClient.socketUDP.isClosed()) {
            try {
                VoiceClient.socketUDP.send(new VoiceEndClientPacket());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        if (this.thread != null) {
            this.waitForClose().thenRun(() -> {
                this.thread = new Thread((Runnable)this, "Input Device Recorder");
                this.thread.start();
            });
        } else {
            this.thread = new Thread((Runnable)this, "Input Device Recorder");
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        VoiceClient.LOGGER.info("Recorder cleanup");
        this.sequenceNumber = 0L;
        this.lastBuffer = null;
        if (this.encoder != null) {
            this.encoder.close();
        }
        if (this.microphone.isOpen()) {
            this.microphone.stop();
            try {
                this.microphone.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.thread = null;
        }
        Recorder recorder = this;
        synchronized (recorder) {
            this.notifyAll();
        }
    }

    public CompletableFuture<Void> waitForClose() {
        return CompletableFuture.runAsync(() -> {
            this.close(false);
            Recorder recorder = this;
            synchronized (recorder) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public static int getMtuSize() {
        return 1024;
    }

    public static int getSampleRate() {
        return sampleRate;
    }

    public static int getFrameSize() {
        return frameSize;
    }

    public static AudioFormat getFormat() {
        return format;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Thread getThread() {
        return this.thread;
    }
}

