/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.openal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4227;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.openal.SOFTHRTF;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.sound.capture.JavaxCaptureDevice;
import su.plo.voice.client.sound.openal.AlUtil;
import su.plo.voice.client.sound.openal.CustomSource;

public class CustomSoundEngine {
    private static final Logger LOGGER = LogManager.getLogger();
    private long devicePointer;
    private long contextPointer;
    public final class_4227 listener;
    public boolean initialized;
    private boolean failed;
    private boolean hrtfSupported;
    protected boolean soundPhysics;
    private final ScheduledExecutorService executor;
    private final List<Consumer<CustomSoundEngine>> initListeners = new ArrayList<Consumer<CustomSoundEngine>>();
    private final List<Runnable> closeListeners = new ArrayList<Runnable>();
    public static Method soundPhysicsPlaySound;
    public static Method soundPhysicsReverb;

    public CustomSoundEngine() {
        this.listener = new class_4227();
        this.executor = Executors.newScheduledThreadPool(1);
    }

    public synchronized CustomSource createSource() {
        if (this.initialized) {
            return CustomSource.create();
        }
        if (this.failed) {
            return null;
        }
        this.initSync();
        return CustomSource.create();
    }

    public void runInContext(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public void start() {
        if (!this.initialized) {
            this.restart();
        }
    }

    public void restart() {
        this.runInContext(this::initSync);
    }

    private void initSync() {
        this.closeSync();
        this.preInit();
        try {
            this.devicePointer = this.openDevice();
        }
        catch (IllegalStateException ignored) {
            this.failed = true;
            return;
        }
        ALCCapabilities aLCCapabilities = ALC.createCapabilities((long)this.devicePointer);
        if (AlUtil.checkAlcErrors(this.devicePointer, "Get capabilities")) {
            throw new IllegalStateException("Failed to get OpenAL capabilities");
        }
        if (!aLCCapabilities.OpenALC11) {
            throw new IllegalStateException("OpenAL 1.1 not supported");
        }
        this.contextPointer = ALC10.alcCreateContext((long)this.devicePointer, (IntBuffer)null);
        EXTThreadLocalContext.alcSetThreadContext((long)this.contextPointer);
        ALCapabilities aLCapabilities = AL.createCapabilities((ALCCapabilities)aLCCapabilities);
        AlUtil.checkErrors("Initialization");
        if (!aLCapabilities.AL_EXT_source_distance_model) {
            throw new IllegalStateException("AL_EXT_source_distance_model is not supported");
        }
        AL10.alEnable((int)512);
        if (!aLCapabilities.AL_EXT_LINEAR_DISTANCE) {
            throw new IllegalStateException("AL_EXT_LINEAR_DISTANCE is not supported");
        }
        AlUtil.checkErrors("Enable per-source distance models");
        LOGGER.info("OpenAL (Plasmo Voice) initialized.");
        int num_hrtf = ALC10.alcGetInteger((long)this.devicePointer, (int)6548);
        if (num_hrtf > 0) {
            this.hrtfSupported = true;
        }
        if (((Boolean)VoiceClient.getClientConfig().hrtf.get()).booleanValue() && num_hrtf > 0) {
            int hrtf_state;
            IntBuffer attr = BufferUtils.createIntBuffer((int)10).put(6546).put(1);
            attr.put(0);
            ((Buffer)attr).flip();
            if (!SOFTHRTF.alcResetDeviceSOFT((long)this.devicePointer, (IntBuffer)attr)) {
                LOGGER.info("Failed to reset device: {}", (Object)ALC10.alcGetString((long)this.devicePointer, (int)ALC10.alcGetError((long)this.devicePointer)));
            }
            if ((hrtf_state = ALC10.alcGetInteger((long)this.devicePointer, (int)6546)) != 0) {
                String name = ALC10.alcGetString((long)this.devicePointer, (int)6549);
                LOGGER.info("HRTF enabled, using {}", (Object)name);
            }
        }
        this.listener.method_19673();
        this.listener.method_19670(1.0f);
        this.initialized = true;
        this.failed = false;
        this.postInit();
        for (Consumer<CustomSoundEngine> listener : this.initListeners) {
            listener.accept(this);
        }
        this.executor.scheduleAtFixedRate(() -> {
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            class_243 vec3d = camera.method_19326();
            class_1160 vector3f = camera.method_19335();
            class_1160 vector3f2 = camera.method_19336();
            this.listener.method_19671(vec3d);
            this.listener.method_19672(vector3f, vector3f2);
        }, 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.runInContext(this::closeSync);
    }

    private synchronized void closeSync() {
        SocketClientUDPQueue.audioChannels.values().forEach(AbstractSoundQueue::closeAndKill);
        SocketClientUDPQueue.audioChannels.clear();
        if (this.initialized) {
            for (Runnable listener : this.closeListeners) {
                listener.run();
            }
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof VoiceSettingsScreen) {
                VoiceSettingsScreen screen = (VoiceSettingsScreen)class_4372;
                screen.closeSpeaker();
            }
            EXTThreadLocalContext.alcSetThreadContext((long)0L);
            this.initialized = false;
            ALC10.alcDestroyContext((long)this.contextPointer);
            if (this.devicePointer != 0L) {
                ALC10.alcCloseDevice((long)this.devicePointer);
            }
            this.contextPointer = 0L;
            this.devicePointer = 0L;
            VoiceClient.LOGGER.info("Audio engine closed");
        }
    }

    private long openDevice() throws IllegalStateException {
        try {
            return this.openDevice(CustomSoundEngine.getCurrentDevice());
        }
        catch (IllegalStateException ignored) {
            try {
                return this.openDevice(null);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to open OpenAL device");
            }
        }
    }

    private long openDevice(String deviceName) throws IllegalStateException {
        long l = deviceName == null ? ALC10.alcOpenDevice((ByteBuffer)null) : ALC10.alcOpenDevice((CharSequence)deviceName);
        if (l != 0L && !AlUtil.checkAlcErrors(l, "Open device")) {
            return l;
        }
        throw new IllegalStateException("Failed to open OpenAL device");
    }

    public static String getCurrentDevice() {
        String deviceName = (String)VoiceClient.getClientConfig().speaker.get();
        List<String> devices = CustomSoundEngine.getDevices();
        if (deviceName == null || !devices.contains(deviceName)) {
            deviceName = CustomSoundEngine.getDefaultDevice();
        }
        return deviceName.isEmpty() ? null : deviceName;
    }

    public static String getDefaultDevice() {
        return ALC11.alcGetString((long)0L, (int)4115);
    }

    public static List<String> getDevices() {
        List devices = ALUtil.getStringList((long)0L, (int)4115);
        return devices == null ? Collections.emptyList() : devices;
    }

    public static long openCaptureDevice() {
        try {
            return CustomSoundEngine.openCaptureDevice(CustomSoundEngine.getCurrentCaptureDevice());
        }
        catch (IllegalStateException ignored) {
            try {
                return CustomSoundEngine.openCaptureDevice(null);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to open OpenAL capture device");
            }
        }
    }

    private static long openCaptureDevice(String deviceName) {
        long l = deviceName == null ? ALC11.alcCaptureOpenDevice((ByteBuffer)null, (int)Recorder.getSampleRate(), (int)4353, (int)Recorder.getFrameSize()) : ALC11.alcCaptureOpenDevice((CharSequence)deviceName, (int)Recorder.getSampleRate(), (int)4353, (int)Recorder.getFrameSize());
        if (l != 0L && !AlUtil.checkAlcErrors(l, "Open device")) {
            return l;
        }
        throw new IllegalStateException("Failed to open OpenAL device");
    }

    public static String getCurrentCaptureDevice() {
        String deviceName = (String)VoiceClient.getClientConfig().microphone.get();
        if (((Boolean)VoiceClient.getClientConfig().javaxCapture.get()).booleanValue()) {
            List<String> devices = JavaxCaptureDevice.getNames();
            if (devices.size() == 0) {
                return null;
            }
            if (deviceName == null || !devices.contains(deviceName)) {
                deviceName = devices.get(0);
            }
        } else {
            List<String> devices = CustomSoundEngine.getCaptureDevices();
            if (deviceName == null || !devices.contains(deviceName)) {
                deviceName = CustomSoundEngine.getDefaultCaptureDevice();
            }
        }
        return deviceName.isEmpty() ? null : deviceName;
    }

    public static String getDefaultCaptureDevice() {
        if (((Boolean)VoiceClient.getClientConfig().javaxCapture.get()).booleanValue()) {
            return JavaxCaptureDevice.getNames().get(0);
        }
        return ALC11.alcGetString((long)0L, (int)784);
    }

    public static List<String> getCaptureDevices() {
        if (((Boolean)VoiceClient.getClientConfig().javaxCapture.get()).booleanValue()) {
            return JavaxCaptureDevice.getNames();
        }
        List devices = ALUtil.getStringList((long)0L, (int)784);
        return devices == null ? Collections.emptyList() : devices;
    }

    public void preInit() {
    }

    public void postInit() {
        try {
            Class<?> clazz = Class.forName("com.sonicether.soundphysics.SoundPhysics");
            clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            soundPhysicsPlaySound = clazz.getMethod("onPlaySound", Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
            soundPhysicsReverb = clazz.getMethod("onPlayReverb", Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
            this.soundPhysics = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void onClose(Runnable listener) {
        this.closeListeners.add(listener);
    }

    public void onInitialize(Consumer<CustomSoundEngine> consumer) {
        this.initListeners.add(consumer);
    }

    public long getContextPointer() {
        return this.contextPointer;
    }

    public class_4227 getListener() {
        return this.listener;
    }

    public boolean isHrtfSupported() {
        return this.hrtfSupported;
    }

    public boolean isSoundPhysics() {
        return this.soundPhysics;
    }
}

