/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.opus;

import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.utils.AudioUtils;
import tomp2p.opuswrapper.Opus;

public class OpusDecoder {
    protected PointerByReference opusDecoder;
    protected boolean closed;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;

    public OpusDecoder(int sampleRate, int frameSize, int maxPayloadSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        IntBuffer error = IntBuffer.allocate(1);
        this.opusDecoder = Opus.INSTANCE.opus_decoder_create(sampleRate, 1, error);
        if (error.get() != 0 && this.opusDecoder == null) {
            throw new IllegalStateException("Opus decoder error " + error.get());
        }
    }

    public byte[] decode(@Nullable byte[] data) {
        if (this.closed) {
            return new byte[0];
        }
        ShortBuffer decoded = ShortBuffer.allocate(4096);
        int result = data == null || data.length == 0 ? Opus.INSTANCE.opus_decode(this.opusDecoder, null, 0, decoded, this.frameSize / 2, 0) : Opus.INSTANCE.opus_decode(this.opusDecoder, data, data.length, decoded, this.frameSize / 2, 0);
        if (result < 0) {
            return new byte[0];
        }
        short[] audio = new short[result];
        decoded.get(audio);
        byte[] outData = new byte[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            byte[] split = AudioUtils.shortToBytes(audio[i]);
            outData[i * 2] = split[0];
            outData[i * 2 + 1] = split[1];
        }
        return outData;
    }

    public void reset() {
        if (!this.closed) {
            Opus.INSTANCE.opus_decoder_ctl(this.opusDecoder, 4028, new Object[0]);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        VoiceClient.LOGGER.info("Close opus decoder");
        Opus.INSTANCE.opus_decoder_destroy(this.opusDecoder);
    }
}

