/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.udp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import su.plo.voice.common.packets.Packet;

public class VoiceClientPacket
implements Packet {
    private byte[] data;
    private long sequenceNumber;
    private short distance;

    public VoiceClientPacket(byte[] data, long sequenceNumber, short distance) {
        this.data = data;
        this.sequenceNumber = sequenceNumber;
        this.distance = distance;
    }

    public VoiceClientPacket() {
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getData() {
        return this.data;
    }

    public short getDistance() {
        return this.distance;
    }

    @Override
    public void read(ByteArrayDataInput buf) throws IOException {
        int length = buf.readInt();
        byte[] data = new byte[length];
        buf.readFully(data);
        this.data = data;
        this.distance = buf.readShort();
        this.sequenceNumber = buf.readLong();
    }

    @Override
    public void write(ByteArrayDataOutput buf) throws IOException {
        buf.writeInt(this.data.length);
        buf.write(this.data);
        buf.writeShort((int)this.distance);
        buf.writeLong(this.sequenceNumber);
    }
}

