/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.config.Configuration;
import su.plo.voice.server.config.ConfigurationProvider;
import su.plo.voice.server.config.ServerConfig;
import su.plo.voice.server.config.ServerData;
import su.plo.voice.server.config.ServerMuted;
import su.plo.voice.server.config.YamlConfiguration;
import su.plo.voice.server.metrics.Metrics;
import su.plo.voice.server.network.ServerNetworkHandler;
import su.plo.voice.server.socket.SocketServerUDP;

public abstract class VoiceServer {
    protected static ServerNetworkHandler network;
    public static final String VERSION = "1.0.10";
    private static MinecraftServer server;
    private static final PlayerManager playerManager;
    private static VoiceServer instance;
    public static final Logger LOGGER;
    public static final class_2960 PLASMO_VOICE;
    public static final UUID NIL_UUID;
    public static final String rawVersion = "1.0.0";
    public static final int version;
    public static final String rawMinVersion = "0.0.6";
    public static final int minVersion;
    private static ServerConfig serverConfig;
    private SocketServerUDP udpServer;
    protected Configuration config;
    private static final ConcurrentHashMap<UUID, ServerMuted> muted;
    private Metrics metrics;

    protected void setupMetrics(String software) {
        this.metrics = new Metrics(10928, software.toLowerCase(), server);
        this.metrics.addCustomChart(new Metrics.SingleLineChart("players_with_forge_mod", () -> (int)SocketServerUDP.clients.values().stream().filter(s -> s.getType().equals("forge")).count()));
        this.metrics.addCustomChart(new Metrics.SingleLineChart("players_with_fabric_mod", () -> (int)SocketServerUDP.clients.values().stream().filter(s -> s.getType().equals("fabric")).count()));
        this.metrics.addCustomChart(new Metrics.SimplePie("server_type", () -> software));
    }

    protected void start() {
        instance = this;
        this.loadConfig();
        this.updateConfig();
        this.udpServer = new SocketServerUDP(serverConfig.getIp(), serverConfig.getPort());
        this.udpServer.start();
    }

    protected void close() {
        if (this.udpServer != null) {
            this.udpServer.close();
        }
        if (this.metrics != null) {
            this.metrics.close();
        }
        ServerNetworkHandler.playerToken.clear();
        VoiceServer.saveData(false);
    }

    public static void saveData(boolean async) {
        if (async) {
            ServerData.saveAsync(new ServerData(new ArrayList<ServerMuted>(muted.values()), playerManager.getPermissions()));
        } else {
            ServerData.save(new ServerData(new ArrayList<ServerMuted>(muted.values()), playerManager.getPermissions()));
        }
    }

    public static int calculateVersion(String s) {
        int ver = 0;
        String[] version = s.split("\\.");
        try {
            ver += Integer.parseInt(version[0]) * 1000;
            ver += Integer.parseInt(version[1]) * 100;
            ver += Integer.parseInt(version[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ver;
    }

    public void loadConfig() {
        try {
            Configuration defaults;
            File configDir = new File("config/PlasmoVoice");
            configDir.mkdirs();
            File file = new File(configDir, "server.yml");
            if (!file.exists()) {
                try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("server.yml");){
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
            }
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("server.yml");){
                defaults = ConfigurationProvider.getProvider(YamlConfiguration.class).load(in);
            }
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file, defaults);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServerData serverData = ServerData.read();
        if (serverData != null) {
            for (ServerMuted e : serverData.getMuted()) {
                muted.put(e.getUuid(), e);
            }
            playerManager.getPermissions().putAll(serverData.getPermissions());
        }
    }

    public void updateConfig() {
        int sampleRate;
        if (!this.config.getDefault("config_version").equals(this.config.getString("config_version"))) {
            LOGGER.warn("Config outdated. Check https://github.com/plasmoapp/plasmo-voice/wiki/How-to-install-Server for new config.");
        }
        if ((sampleRate = this.config.getInt("sample_rate")) != 8000 && sampleRate != 12000 && sampleRate != 24000 && sampleRate != 48000) {
            LOGGER.warn("Sample rate cannot be " + sampleRate);
            return;
        }
        List<Integer> distances = this.config.getIntList("distances");
        if (distances.size() == 0) {
            LOGGER.warn("Distances cannot be empty");
            return;
        }
        int defaultDistance = this.config.getInt("default_distance");
        if (defaultDistance == 0) {
            defaultDistance = distances.get(0);
        } else if (!distances.contains(defaultDistance)) {
            defaultDistance = distances.get(0);
        }
        int fadeDivisor = this.config.getInt("fade_divisor");
        if (fadeDivisor <= 0) {
            LOGGER.warn("Fade distance cannot be <= 0");
            return;
        }
        int priorityFadeDivisor = this.config.getInt("priority_fade_divisor");
        if (priorityFadeDivisor <= 0) {
            LOGGER.warn("Priority fade distance cannot be <= 0");
            return;
        }
        int udpPort = this.config.getInt("udp.port");
        if (udpPort == 0 && (udpPort = server.method_3756()) == -1) {
            udpPort = 60606;
        }
        serverConfig = new ServerConfig(this.config.getString("udp.ip"), udpPort, this.config.getString("udp.proxy_ip"), this.config.getInt("udp.proxy_port"), sampleRate, distances, defaultDistance, this.config.getInt("max_priority_distance"), this.config.getBoolean("disable_voice_activation"), fadeDivisor, priorityFadeDivisor);
    }

    public static boolean isLogsEnabled() {
        return !VoiceServer.getInstance().getConfig().getBoolean("disable_logs");
    }

    public String getMessagePrefix(String name) {
        String message = this.config.getString("messages." + name);
        message = message == null ? "" : message.replace('&', '\u00a7');
        return this.getPrefix() + message;
    }

    public String getMessage(String name) {
        String message = this.config.getString("messages." + name);
        message = message == null ? "" : message.replace('&', '\u00a7');
        return message;
    }

    public String getPrefix() {
        return this.config.getString("messages.prefix").replace('&', '\u00a7');
    }

    public static ServerNetworkHandler getNetwork() {
        return network;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        VoiceServer.server = server;
    }

    public static PlayerManager getPlayerManager() {
        return playerManager;
    }

    public static VoiceServer getInstance() {
        return instance;
    }

    public static ServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void setServerConfig(ServerConfig serverConfig) {
        VoiceServer.serverConfig = serverConfig;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static ConcurrentHashMap<UUID, ServerMuted> getMuted() {
        return muted;
    }

    static {
        playerManager = new PlayerManager();
        LOGGER = LogManager.getLogger((String)"Plasmo Voice");
        PLASMO_VOICE = new class_2960("plasmo:voice");
        NIL_UUID = new UUID(0L, 0L);
        version = VoiceServer.calculateVersion(rawVersion);
        minVersion = VoiceServer.calculateVersion(rawMinVersion);
        muted = new ConcurrentHashMap();
    }
}

