/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.commands.CommandManager;
import su.plo.voice.server.config.ServerConfigFabric;
import su.plo.voice.server.network.ServerNetworkHandlerFabric;

public class VoiceServerFabric
extends VoiceServer
implements ModInitializer {
    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            VoiceServerFabric.setServer(server);
            this.start();
            if (server.method_3816()) {
                this.setupMetrics("Fabric");
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.close());
        S2CPlayChannelEvents.REGISTER.register((handler, sender, server, channels) -> network.handleRegisterChannels(channels, handler.field_14140));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)VoiceServer.PLASMO_VOICE, ((ServerNetworkHandlerFabric)network)::handle);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> network.handleJoin(handler.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> network.handleQuit(handler.field_14140));
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> CommandManager.register((CommandDispatcher<class_2168>)dispatcher));
    }

    @Override
    protected void start() {
        network.start();
        super.start();
    }

    @Override
    protected void close() {
        network.close();
        super.close();
    }

    @Override
    public void updateConfig() {
        super.updateConfig();
        int clientModCheckTimeout = this.config.getInt("client_mod_check_timeout");
        if (clientModCheckTimeout < 20) {
            LOGGER.warn("Client mod check timeout cannot be < 20 ticks");
            return;
        }
        VoiceServer.setServerConfig(new ServerConfigFabric(VoiceServerFabric.getServerConfig(), this.config.getBoolean("client_mod_required"), clientModCheckTimeout));
    }

    static {
        network = new ServerNetworkHandlerFabric();
    }
}

