/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import su.plo.voice.common.packets.tcp.ClientMutedPacket;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.commands.CommandManager;
import su.plo.voice.server.config.ServerMuted;
import su.plo.voice.server.network.ServerNetworkHandler;

public class VoiceMute {
    private static final Pattern pattern = Pattern.compile("^([0-9]*)([smhdwu])?$");
    private static final Pattern integerPattern = Pattern.compile("^([0-9]*)$");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vmute").requires(source -> CommandManager.requiresPermission(source, "voice.mute"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((commandContext, suggestionsBuilder) -> {
            class_3324 playerList = ((class_2168)commandContext.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerList.method_14571().stream().map(serverPlayer -> serverPlayer.method_7334().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoiceMute.mute((CommandContext<class_2168>)ctx, VoiceServer.getServer().method_3760().method_14602(gameProfile.getId()), null, null));
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String arg = builder.getRemaining();
            ArrayList<Object> suggests = new ArrayList<Object>();
            if (arg.isEmpty()) {
                suggests.add("permanent");
            } else {
                Matcher matcher = integerPattern.matcher(arg);
                if (matcher.find()) {
                    suggests.add(arg + "m");
                    suggests.add(arg + "h");
                    suggests.add(arg + "d");
                    suggests.add(arg + "w");
                }
            }
            return class_2172.method_9265(suggests, (SuggestionsBuilder)builder);
        }).executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoiceMute.mute((CommandContext<class_2168>)ctx, VoiceServer.getServer().method_3760().method_14602(gameProfile.getId()), StringArgumentType.getString((CommandContext)ctx, (String)"duration"), null));
            return 1;
        })).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoiceMute.mute((CommandContext<class_2168>)ctx, VoiceServer.getServer().method_3760().method_14602(gameProfile.getId()), StringArgumentType.getString((CommandContext)ctx, (String)"duration"), StringArgumentType.getString((CommandContext)ctx, (String)"reason")));
            return 1;
        })))));
    }

    private static void mute(CommandContext<class_2168> ctx, class_3222 player, String rawDuration, String reason) {
        Matcher matcher;
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)new class_2585(VoiceServer.getInstance().getMessagePrefix("player_not_found")));
            return;
        }
        if (VoiceServer.getMuted().containsKey(player.method_5667())) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)new class_2585(VoiceServer.getInstance().getMessagePrefix("already_muted").replace("{player}", player.method_7334().getName())));
            return;
        }
        String durationMessage = VoiceServer.getInstance().getMessage("mute_durations.permanent");
        long duration = 0L;
        if (rawDuration != null && !rawDuration.startsWith("perm") && (matcher = pattern.matcher(rawDuration)).find()) {
            duration = Integer.parseInt(matcher.group(1));
            if (duration > 0L) {
                String type = matcher.group(2);
                if (type == null) {
                    type = "";
                }
                switch (type) {
                    case "m": {
                        durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.minutes"), duration);
                        duration *= 60L;
                        break;
                    }
                    case "h": {
                        durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.hours"), duration);
                        duration *= 3600L;
                        break;
                    }
                    case "d": {
                        durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.days"), duration);
                        duration *= 86400L;
                        break;
                    }
                    case "w": {
                        durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.weeks"), duration);
                        duration *= 604800L;
                        break;
                    }
                    default: {
                        durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.seconds"), duration);
                        break;
                    }
                }
            } else {
                durationMessage = String.format(VoiceServer.getInstance().getMessage("mute_durations.seconds"), duration);
            }
        }
        if (duration > 0L) {
            duration *= 1000L;
            duration += System.currentTimeMillis();
        }
        ServerMuted serverMuted = new ServerMuted(player.method_5667(), duration, reason);
        VoiceServer.getMuted().put(player.method_5667(), serverMuted);
        VoiceServer.saveData(true);
        ServerNetworkHandler.sendToClients(new ClientMutedPacket(serverMuted.getUuid(), serverMuted.getTo()), null);
        if (duration == 0L) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(VoiceServer.getInstance().getMessagePrefix("muted_perm").replace("{player}", player.method_7334().getName()).replace("{reason}", reason != null ? reason : VoiceServer.getInstance().getMessage("mute_no_reason"))), false);
        } else {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(VoiceServer.getInstance().getMessagePrefix("muted").replace("{player}", player.method_7334().getName()).replace("{duration}", durationMessage).replace("{reason}", reason != null ? reason : VoiceServer.getInstance().getMessage("mute_no_reason"))), false);
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585((duration > 0L ? VoiceServer.getInstance().getMessagePrefix("player_muted") : VoiceServer.getInstance().getMessagePrefix("player_muted_perm")).replace("{duration}", durationMessage).replace("{reason}", reason != null ? reason : VoiceServer.getInstance().getMessage("mute_no_reason"))), false);
    }
}

