/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.config;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import su.plo.voice.server.config.Configuration;
import su.plo.voice.server.config.ConfigurationProvider;

public class YamlConfiguration
extends ConfigurationProvider {
    private final ThreadLocal<Yaml> yaml = ThreadLocal.withInitial(() -> {
        Representer representer = new Representer(){
            {
                this.representers.put(Configuration.class, data -> this.represent(((Configuration)data).self));
            }
        };
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(new Constructor(), representer, options);
    });

    @Override
    public void save(Configuration config, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            this.save(config, writer);
        }
    }

    @Override
    public void save(Configuration config, Writer writer) {
        this.yaml.get().dump(config.self, writer);
    }

    @Override
    public Configuration load(File file) throws IOException {
        return this.load(file, null);
    }

    @Override
    public Configuration load(File file, Configuration defaults) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Configuration configuration = this.load(is, defaults);
            return configuration;
        }
    }

    @Override
    public Configuration load(Reader reader) {
        return this.load(reader, null);
    }

    @Override
    public Configuration load(Reader reader, Configuration defaults) {
        LinkedHashMap map = this.yaml.get().loadAs(reader, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    @Override
    public Configuration load(InputStream is) {
        return this.load(is, null);
    }

    @Override
    public Configuration load(InputStream is, Configuration defaults) {
        LinkedHashMap map = this.yaml.get().loadAs(is, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    @Override
    public Configuration load(String string) {
        return this.load(string, null);
    }

    @Override
    public Configuration load(String string, Configuration defaults) {
        LinkedHashMap map = this.yaml.get().loadAs(string, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    YamlConfiguration() {
    }
}

