/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.network;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectPacket;
import su.plo.voice.common.packets.tcp.ClientDisconnectedPacket;
import su.plo.voice.common.packets.tcp.ClientUnmutedPacket;
import su.plo.voice.common.packets.tcp.ConfigPacket;
import su.plo.voice.common.packets.tcp.PacketTCP;
import su.plo.voice.common.packets.tcp.ServerConnectPacket;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.config.ServerConfig;
import su.plo.voice.server.socket.SocketClientUDP;
import su.plo.voice.server.socket.SocketServerUDP;

public abstract class ServerNetworkHandler {
    protected ScheduledExecutorService scheduler;
    private static ExecutorService executor;
    public static Map<UUID, UUID> playerToken;

    public boolean isVanillaPlayer(class_3222 player) {
        return true;
    }

    public void start() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        executor = Executors.newSingleThreadExecutor();
        this.scheduler.scheduleAtFixedRate(() -> VoiceServer.getMuted().forEach((uuid, muted) -> {
            if (muted.getTo() > 0L && muted.getTo() < System.currentTimeMillis()) {
                VoiceServer.getMuted().remove(uuid);
                VoiceServer.saveData(true);
                class_3222 player = PlayerManager.getByUUID(uuid);
                if (player != null) {
                    ServerNetworkHandler.sendToClients(new ClientUnmutedPacket((UUID)uuid), null);
                    player.method_9203((class_2561)new class_2585(VoiceServer.getInstance().getMessagePrefix("player_unmuted")), VoiceServer.NIL_UUID);
                }
            }
        }), 0L, 5L, TimeUnit.SECONDS);
    }

    public void close() {
        this.scheduler.shutdown();
        executor.shutdown();
    }

    public void handleRegisterChannels(List<class_2960> channels, class_3222 player) {
        if (!playerToken.containsKey(player.method_5667()) && channels.contains(VoiceServer.PLASMO_VOICE) && !SocketServerUDP.clients.containsKey(player.method_5667())) {
            ServerNetworkHandler.reconnectClient(player);
        }
    }

    public void handleJoin(class_3222 player) {
        if (PlayerManager.isOp(player) && !SocketServerUDP.started) {
            player.method_9203((class_2561)new class_2585(VoiceServer.getInstance().getPrefix() + String.format("Voice chat is installed but doesn't work. Check if port %d UDP is open.", VoiceServer.getServerConfig().getPort())), VoiceServer.NIL_UUID);
        }
    }

    public void handleQuit(class_3222 player) {
        playerToken.remove(player.method_5667());
        ServerNetworkHandler.disconnectClient(player.method_5667());
    }

    public void handle(ClientConnectPacket packet, class_3222 player) throws IOException {
        ServerConfig config = VoiceServer.getServerConfig();
        String version = packet.getVersion();
        int ver = VoiceServer.calculateVersion(version);
        if (ver > VoiceServer.version) {
            player.method_9203((class_2561)new class_2588("message.plasmo_voice.version_not_supported", new Object[]{"1.0.0"}), VoiceServer.NIL_UUID);
            return;
        }
        if (ver < VoiceServer.minVersion) {
            player.method_9203((class_2561)new class_2588("message.plasmo_voice.min_version", new Object[]{"0.0.6"}), VoiceServer.NIL_UUID);
            return;
        }
        if (ver < VoiceServer.version) {
            class_2585 link = new class_2585("https://www.curseforge.com/minecraft/mc-mods/plasmo-voice-client/files");
            link.method_10862(link.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/plasmo-voice-client/files")));
            player.method_9203((class_2561)new class_2588("message.plasmo_voice.new_version_available", new Object[]{"1.0.0", link}), VoiceServer.NIL_UUID);
        }
        ServerNetworkHandler.sendTo(new ConfigPacket(config.getSampleRate(), new ArrayList<Integer>(config.getDistances()), config.getDefaultDistance(), config.getMaxPriorityDistance(), config.isDisableVoiceActivation() || !VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.activation"), config.getFadeDivisor(), config.getPriorityFadeDivisor()), player);
    }

    public static void reconnectClient(class_3222 player) {
        ServerNetworkHandler.disconnectClient(player.method_5667());
        UUID token = UUID.randomUUID();
        playerToken.put(player.method_5667(), token);
        try {
            executor.submit(() -> {
                try {
                    ServerNetworkHandler.sendTo(new ServerConnectPacket(token.toString(), VoiceServer.getServerConfig().getProxyIp() != null && !VoiceServer.getServerConfig().getProxyIp().isEmpty() ? VoiceServer.getServerConfig().getProxyIp() : VoiceServer.getServerConfig().getIp(), VoiceServer.getServerConfig().getProxyPort() != 0 ? VoiceServer.getServerConfig().getProxyPort() : VoiceServer.getServerConfig().getPort(), VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.priority")), player);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public static void disconnectClient(UUID uuid) {
        SocketClientUDP clientUDP = SocketServerUDP.clients.get(uuid);
        try {
            if (clientUDP != null) {
                clientUDP.close();
                ServerNetworkHandler.sendToClients(new ClientDisconnectedPacket(uuid), null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendTo(Packet packet, class_3222 player) throws IOException {
        player.field_13987.method_14364((class_2596)new class_2658(VoiceServer.PLASMO_VOICE, new class_2540(Unpooled.wrappedBuffer((byte[])PacketTCP.write(packet)))));
    }

    public static void sendToClients(Packet packet, UUID except) {
        try {
            executor.submit(() -> {
                try {
                    byte[] pkt = PacketTCP.write(packet);
                    Enumeration<UUID> it = SocketServerUDP.clients.keys();
                    while (it.hasMoreElements()) {
                        UUID uuid = it.nextElement();
                        if (uuid.equals(except)) continue;
                        class_3222 player = PlayerManager.getByUUID(uuid);
                        player.field_13987.method_14364((class_2596)new class_2658(VoiceServer.PLASMO_VOICE, new class_2540(Unpooled.wrappedBuffer((byte[])pkt))));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    static {
        playerToken = new ConcurrentHashMap<UUID, UUID>();
    }
}

