/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.udp.PacketUDP;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.socket.SocketClientUDP;
import su.plo.voice.server.socket.SocketServerUDPQueue;

public class SocketServerUDP
extends Thread {
    public static final ConcurrentHashMap<UUID, SocketClientUDP> clients = new ConcurrentHashMap();
    private final SocketAddress addr;
    public static boolean started;
    private final SocketServerUDPQueue queue;
    private static DatagramSocket socket;

    public SocketServerUDP(String ip, int port) {
        this.addr = new InetSocketAddress(ip, port);
        this.queue = new SocketServerUDPQueue();
        this.queue.start();
    }

    public static void sendToNearbyPlayers(Packet packet, class_3222 player, double maxDistance) {
        byte[] bytes;
        double maxDistanceSquared = maxDistance * maxDistance * 1.25;
        try {
            bytes = PacketUDP.write(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        clients.forEach((uuid, sock) -> {
            if (!player.method_5667().equals(uuid)) {
                class_3222 p = PlayerManager.getByUUID(uuid);
                if (maxDistanceSquared > 0.0) {
                    if (!player.method_14220().equals(p.method_14220())) {
                        return;
                    }
                    try {
                        if (player.method_19538().method_1025(p.method_19538()) > maxDistanceSquared) {
                            return;
                        }
                    }
                    catch (IllegalArgumentException ignored) {
                        return;
                    }
                }
                try {
                    SocketServerUDP.sendTo(bytes, sock);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static SocketClientUDP getSender(PacketUDP packet) {
        return clients.values().stream().filter(connection -> connection.getAddress().equals(packet.getAddress()) && connection.getPort() == packet.getPort()).findAny().orElse(null);
    }

    public static void sendTo(byte[] data, SocketClientUDP connection) throws IOException {
        socket.send(new DatagramPacket(data, data.length, connection.getAddress(), connection.getPort()));
    }

    public void close() {
        if (socket != null) {
            socket.close();
            this.queue.interrupt();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            socket = new DatagramSocket(this.addr);
            socket.setTrafficClass(4);
        }
        catch (SocketException e) {
            e.printStackTrace();
            VoiceServer.LOGGER.info(String.format("Failed to bind socket. Check if port %d UDP is open", VoiceServer.getServerConfig().getPort()));
            return;
        }
        started = true;
        VoiceServer.LOGGER.info("Voice UDP server started on {}", (Object)this.addr.toString());
        while (!socket.isClosed()) {
            try {
                PacketUDP message = PacketUDP.read(socket);
                this.queue.queue.offer(message);
                SocketServerUDPQueue socketServerUDPQueue = this.queue;
                synchronized (socketServerUDPQueue) {
                    this.queue.notify();
                }
            }
            catch (IOException | IllegalArgumentException | IllegalStateException | InstantiationException e) {
                if (!VoiceServer.getInstance().getConfig().getBoolean("debug")) continue;
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        VoiceServer.LOGGER.info("Voice UDP server stopped");
    }
}

